/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel.stream;

import com.softwareag.tamino.db.api.common.TContractVerifier;
import com.softwareag.tamino.db.api.io.TStreamReadException;
import com.softwareag.tamino.db.api.io.TStreamWriteException;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import org.xml.sax.InputSource;

public class TStreamAdapter
extends TXMLObject
implements Serializable {
    private String id = "";
    private TStreamWriter streamWriter = null;

    public TStreamAdapter() {
        this((Reader)null);
    }

    public TStreamAdapter(InputSource inputSource) {
        this.initialize(inputSource.getByteStream(), inputSource.getCharacterStream());
    }

    public TStreamAdapter(Reader reader) {
        this.initialize(null, reader);
    }

    public TStreamAdapter(InputStream inputStream) {
        this.initialize(inputStream, null);
    }

    public void setDocname(String string) {
        this.streamWriter.setDocname(string);
    }

    public void setId(String string) {
        this.streamWriter.setId(string);
    }

    public String getDocname() {
        return this.streamWriter.getDocname();
    }

    public String getId() {
        return this.streamWriter.getId();
    }

    public String getDoctype() {
        String string = super.getDoctype();
        if (string.length() == 0) {
            string = this.streamWriter.getStartTag();
        }
        return string;
    }

    public Object getDocument() {
        return this.streamWriter.getInputSource();
    }

    public Object getElement() {
        return this.streamWriter.getInputSource();
    }

    public void readFrom(InputStream inputStream) throws TStreamReadException {
        try {
            this.streamWriter.setWritableStream(inputStream);
        }
        catch (Exception exception) {
            throw new TStreamReadException("Reading from byte input stream caused problems", exception);
        }
    }

    public void readFrom(Reader reader) throws TStreamReadException {
        try {
            this.streamWriter.setWritableStream(reader);
        }
        catch (Exception exception) {
            throw new TStreamReadException("Reading from character input stream caused problems", exception);
        }
    }

    public void writeTo(OutputStream outputStream) throws TStreamWriteException {
        TContractVerifier.precondition(this.streamWriter.hasWritableStream(), "There is currently no consumable XML resource given! Provide consumable resource first!");
        try {
            this.streamWriter.writeTo(outputStream);
        }
        catch (Exception exception) {
            throw new TStreamWriteException("Problem during serialization to output stream.", exception);
        }
    }

    public void writeTo(Writer writer) throws TStreamWriteException {
        TContractVerifier.precondition(this.streamWriter.hasWritableStream(), "There is currently no consumable XML resource given! Provide consumable resource first!");
        try {
            this.streamWriter.writeTo(writer);
        }
        catch (Exception exception) {
            throw new TStreamWriteException("Problem during serialization to writer.", exception);
        }
    }

    protected boolean canWriteToOutputStream() {
        return this.streamWriter.hasWritableStream();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        super.writeStateTo(objectOutputStream, true);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            this.streamWriter = new TStreamWriter();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.readStateFrom(objectInputStream);
    }

    private void initialize(InputStream inputStream, Reader reader) {
        try {
            this.streamWriter = inputStream != null ? new TStreamWriter(inputStream) : (reader != null ? new TStreamWriter(reader) : new TStreamWriter());
        }
        catch (Exception exception) {
            TContractVerifier.precondition(false, "TStreamAdapter could not be intitialized with underlying input stream. Check for XML stream correctness!");
        }
    }
}

