/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel.sax;

import com.softwareag.tamino.db.api.common.TContractVerifier;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.io.TStreamReadException;
import com.softwareag.tamino.db.api.io.TStreamWriteException;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXDocument;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXDocumentDefaultHandler;
import com.softwareag.tamino.db.api.objectModel.sax.TSAXElement;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class TSAXAdapter
extends TXMLObject {
    private boolean isBuildFromDocument = false;
    private TSAXDocument document = null;
    private TSAXElement element = null;
    private TSAXDocumentDefaultHandler defaultHandler = null;
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$objectModel$sax$TSAXDocumentDefaultHandler;

    public TSAXAdapter() {
        this((TSAXElement)null);
    }

    public TSAXAdapter(TSAXDocument tSAXDocument) {
        this(tSAXDocument != null ? tSAXDocument.getRootElement() : (TSAXElement)null);
        this.document = tSAXDocument;
        this.isBuildFromDocument = true;
    }

    public TSAXAdapter(TSAXElement tSAXElement) {
        this.element = tSAXElement;
    }

    public void setDocname(String string) {
        if (this.element != null) {
            this.element.setDocname(string);
        } else {
            super.setDocname(string);
        }
    }

    public void setId(String string) {
        if (this.element != null) {
            this.element.setId(string);
        } else {
            super.setId(string);
        }
    }

    public String getDocname() {
        String string = "";
        string = this.element != null ? this.element.getDocname() : super.getDocname();
        return string;
    }

    public String getId() {
        String string = "";
        string = this.element != null ? ((string = this.element.getId()) != null ? string : "") : super.getId();
        return string;
    }

    public String getDoctype() {
        String string = super.getDoctype();
        if (string.equals("") && this.element != null) {
            string = this.element.getDoctype();
        }
        return string;
    }

    public Object getDocument() {
        return this.document;
    }

    public Object getElement() {
        return this.element;
    }

    public void readFrom(InputStream inputStream) throws TStreamReadException {
        TContractVerifier.precondition(this.providesSAXHandler(), "Reading from byte input stream not possible. No SAX handler given!");
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)this.defaultHandler);
            this.document = this.defaultHandler.getDocument();
            if (this.element == null) {
                super.setDocname(null);
                super.setId(null);
            }
            this.element = this.document.getRootElement();
            this.isBuildFromDocument = true;
        }
        catch (Exception exception) {
            throw new TStreamReadException("Reading from byte input stream caused problems", exception);
        }
    }

    public void readFrom(Reader reader) throws TStreamReadException {
        TContractVerifier.precondition(this.providesSAXHandler(), "Reading from character input stream not possible. No SAX handler given!");
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            sAXParser.parse(new InputSource(reader), (DefaultHandler)this.defaultHandler);
            this.document = this.defaultHandler.getDocument();
            if (this.element == null) {
                super.setDocname(null);
                super.setId(null);
            }
            this.element = this.document.getRootElement();
            this.isBuildFromDocument = true;
        }
        catch (Exception exception) {
            throw new TStreamReadException("Reading from character input stream caused problems", exception);
        }
    }

    public void writeTo(OutputStream outputStream) throws TStreamWriteException {
        TContractVerifier.precondition(this.element != null || this.document != null, "There is currently no consumable XML resource given! Provide consumable resource first!");
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, TPreference.getInstance().getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            TContractVerifier.precondition(false, "Unsupported encoding!");
        }
        this.writeTo(outputStreamWriter);
    }

    public void writeTo(Writer writer) throws TStreamWriteException {
        TContractVerifier.precondition(this.element != null || this.document != null, "There is currently no consumable XML resource given! Provide consumable resource first!");
        try {
            if (this.isBuildFromDocument) {
                this.document.writeTo(writer);
            } else {
                this.element.writeTo(writer);
            }
            writer.flush();
        }
        catch (Exception exception) {
            throw new TStreamWriteException("Problem during serialization to writer.", exception);
        }
    }

    protected boolean canWriteToOutputStream() {
        return this.element != null || this.document != null;
    }

    protected void setProperty(String string, Object object) {
        if (string.equals(TSAXDocumentDefaultHandler.SPECIFIER) && (class$com$softwareag$tamino$db$api$objectModel$sax$TSAXDocumentDefaultHandler == null ? (class$com$softwareag$tamino$db$api$objectModel$sax$TSAXDocumentDefaultHandler = TSAXAdapter.class$("com.softwareag.tamino.db.api.objectModel.sax.TSAXDocumentDefaultHandler")) : class$com$softwareag$tamino$db$api$objectModel$sax$TSAXDocumentDefaultHandler).isInstance(object)) {
            this.defaultHandler = (TSAXDocumentDefaultHandler)object;
        }
    }

    private boolean providesSAXHandler() {
        return this.defaultHandler != null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

