/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel.jdom;

import com.softwareag.tamino.db.api.common.TContractVerifier;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.io.TStreamReadException;
import com.softwareag.tamino.db.api.io.TStreamWriteException;
import com.softwareag.tamino.db.api.namespace.TInoNamespace;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.jdom.TJDOMXMLOutputter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class TJDOMAdapter
extends TXMLObject
implements Serializable {
    private String encoding = "";
    private boolean isBuildFromDocument = false;
    private Document document = null;
    private Element element = null;
    private TJDOMXMLOutputter outputter = null;
    private static Namespace inoNamespace = Namespace.getNamespace((String)TInoNamespace.getInstance().getPrefix(), (String)TInoNamespace.getInstance().getUri());

    public TJDOMAdapter() {
        this((Element)null);
    }

    public TJDOMAdapter(Document document) {
        this(document != null ? document.getRootElement() : (Element)null);
        this.isBuildFromDocument = true;
    }

    public TJDOMAdapter(Element element) {
        if (element != null) {
            this.document = element.getDocument();
            this.element = element;
        }
        this.initializeIOHelpers();
    }

    public void setDocname(String string) {
        if (string == null || string.equals("")) {
            if (this.element == null) {
                super.setDocname(null);
            } else {
                this.element.removeAttribute(TInoNamespace.DOCNAME.getName(), inoNamespace);
            }
        } else if (this.element == null) {
            super.setDocname(string);
        } else {
            Attribute attribute = this.element.getAttribute(TInoNamespace.DOCNAME.getName(), inoNamespace);
            if (attribute != null) {
                attribute.setValue(string);
            } else {
                attribute = new Attribute(TInoNamespace.DOCNAME.getName(), string, inoNamespace);
                this.element.addAttribute(attribute);
            }
        }
    }

    public void setId(String string) {
        if (string == null || string.length() == 0) {
            if (this.element == null) {
                super.setId(null);
            } else {
                this.element.removeAttribute(TInoNamespace.ID.getName(), inoNamespace);
            }
        } else if (this.element == null) {
            super.setId(string);
        } else {
            Attribute attribute = this.element.getAttribute(TInoNamespace.ID.getName(), inoNamespace);
            if (attribute != null) {
                attribute = attribute.setValue(string);
            } else {
                attribute = new Attribute(TInoNamespace.ID.getName(), string, inoNamespace);
                this.element.addAttribute(attribute);
            }
        }
    }

    public String getDocname() {
        if (this.element == null) {
            return super.getDocname();
        }
        Attribute attribute = this.element.getAttribute(TInoNamespace.DOCNAME.getName(), inoNamespace);
        return attribute != null ? attribute.getValue() : "";
    }

    public String getId() {
        if (this.element == null) {
            return super.getId();
        }
        Attribute attribute = this.element.getAttribute(TInoNamespace.ID.getName(), inoNamespace);
        return attribute != null ? attribute.getValue() : "";
    }

    public String getDoctype() {
        String string = super.getDoctype();
        if (this.element != null && string.equals("")) {
            string = this.element.getQualifiedName();
        }
        return string;
    }

    public Object getDocument() {
        return this.document;
    }

    public Object getElement() {
        return this.element;
    }

    public void readFrom(InputStream inputStream) throws TStreamReadException {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            this.document = sAXBuilder.build(inputStream);
            if (this.element == null) {
                super.setDocname(null);
                super.setId(null);
            }
            this.element = this.document.getRootElement();
            this.isBuildFromDocument = true;
        }
        catch (Exception exception) {
            throw new TStreamReadException("Problems during parsing input stream and building JDOM document.", exception);
        }
    }

    public void readFrom(Reader reader) throws TStreamReadException {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            this.document = sAXBuilder.build(reader);
            if (this.element == null) {
                super.setDocname(null);
                super.setId(null);
            }
            this.element = this.document.getRootElement();
            this.isBuildFromDocument = true;
        }
        catch (Exception exception) {
            throw new TStreamReadException("Problems during parsing input stream and building JDOM document.", exception);
        }
    }

    public void writeTo(OutputStream outputStream) throws TStreamWriteException {
        TContractVerifier.precondition(this.getElement() != null, "No DOM element is given. Writing to output stream not possible!");
        try {
            if (this.isBuildFromDocument) {
                this.outputter.output(this.document, outputStream);
            } else {
                this.outputter.output(this.element, outputStream);
            }
        }
        catch (IOException iOException) {
            throw new TStreamWriteException(iOException);
        }
    }

    public void writeTo(Writer writer) throws TStreamWriteException {
        TContractVerifier.precondition(this.getElement() != null, "No DOM element is given. Writing to output stream not possible!");
        try {
            if (this.isBuildFromDocument) {
                this.outputter.output(this.document, writer);
            } else {
                this.outputter.output(this.element, writer);
            }
        }
        catch (IOException iOException) {
            throw new TStreamWriteException(iOException);
        }
    }

    protected boolean canWriteToOutputStream() {
        return this.getElement() != null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(new Boolean(this.document != null));
        if (this.document != null) {
            objectOutputStream.writeObject(this.document);
            objectOutputStream.writeObject(new Boolean(this.isBuildFromDocument));
        }
        super.writeStateTo(objectOutputStream, false);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.initializeIOHelpers();
        boolean bl = (Boolean)objectInputStream.readObject();
        if (bl) {
            this.document = (Document)objectInputStream.readObject();
            this.element = this.document.getRootElement();
            this.isBuildFromDocument = (Boolean)objectInputStream.readObject();
        } else {
            this.document = null;
            this.element = null;
            this.isBuildFromDocument = false;
        }
        super.readStateFrom(objectInputStream);
    }

    private String getStartTag(Element element) {
        StringBuffer stringBuffer = new StringBuffer("<" + element.getQualifiedName());
        String string = "</" + element.getQualifiedName() + ">";
        List list = element.getAttributes();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                stringBuffer.append(" " + attribute.getQualifiedName() + "=\"");
                stringBuffer.append(attribute.getValue() + "\"");
            }
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    private String getEndTag(Element element) {
        return "</" + element.getQualifiedName() + ">";
    }

    private void initializeIOHelpers() {
        this.outputter = new TJDOMXMLOutputter();
        this.encoding = TPreference.getInstance().getEncoding();
        this.outputter.setEncoding(this.encoding);
        this.outputter.setOmitEncoding(false);
    }
}

