/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel.dom;

import com.softwareag.tamino.db.api.common.TContractVerifier;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TDOMWriter {
    private Writer out;
    private String eol = System.getProperty("line.separator", "\n");
    private HashMap nodeTypeMap = new HashMap();

    public TDOMWriter() {
        this.nodeTypeMap.put(new Integer(1), new ElementNodeWriter());
        this.nodeTypeMap.put(new Integer(3), new TextNodeWriter());
        this.nodeTypeMap.put(new Integer(4), new CDataSectionNodeWriter());
        this.nodeTypeMap.put(new Integer(7), new ProcessingInstructionNodeWriter());
        this.nodeTypeMap.put(new Integer(8), new CommentNodeWriter());
        this.nodeTypeMap.put(new Integer(9), new DocumentNodeWriter());
    }

    public void write(Node node, Writer writer) throws IOException {
        TContractVerifier.precondition(node != null, "No DOM node given.");
        TContractVerifier.precondition(writer != null, "No Writer given.");
        this.out = writer;
        this.writeNode(node);
        this.out.flush();
        this.out = null;
    }

    private void writeNode(Node node) throws IOException {
        TContractVerifier.precondition(node != null, "No DOM node given.");
        NodeWriter nodeWriter = (NodeWriter)this.nodeTypeMap.get(new Integer(node.getNodeType()));
        if (nodeWriter != null) {
            nodeWriter.write(node);
        }
    }

    private void writeChildNodes(Node node) throws IOException {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            this.writeNode(nodeList.item(n));
            ++n;
        }
    }

    private final void writeRaw(char[] cArray, int n, int n2) throws IOException {
        this.out.write(cArray, n, n2);
    }

    private final void writeRaw(String string, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n2) {
            this.out.write(string.charAt(n3));
            ++n3;
        }
    }

    private final void writeRaw(String string) throws IOException {
        this.out.write(string);
    }

    private final void writeRaw(char c) throws IOException {
        this.out.write(c);
    }

    private class DocumentNodeWriter
    implements NodeWriter {
        private DocumentNodeWriter() {
        }

        public void write(Node node) throws IOException {
            TDOMWriter.this.writeRaw("<?xml version=\"1.0\"?>");
            TDOMWriter.this.writeRaw(TDOMWriter.this.eol);
            if (node.hasChildNodes()) {
                TDOMWriter.this.writeChildNodes(node);
            }
        }
    }

    private class CommentNodeWriter
    implements NodeWriter {
        private CommentNodeWriter() {
        }

        public void write(Node node) throws IOException {
            TDOMWriter.this.writeRaw("<!-- ");
            TDOMWriter.this.writeRaw(node.getNodeValue());
            TDOMWriter.this.writeRaw(" -->");
        }
    }

    private class ProcessingInstructionNodeWriter
    implements NodeWriter {
        private ProcessingInstructionNodeWriter() {
        }

        public void write(Node node) throws IOException {
            String string = node.getNodeName();
            String string2 = node.getNodeValue();
            TDOMWriter.this.writeRaw("<?");
            TDOMWriter.this.writeRaw(string);
            if (string2 != null && string2.length() > 0) {
                TDOMWriter.this.writeRaw(' ');
                TDOMWriter.this.writeRaw(string2);
            }
            TDOMWriter.this.writeRaw("?>");
        }
    }

    private class CDataSectionNodeWriter
    implements NodeWriter {
        private CDataSectionNodeWriter() {
        }

        public void write(Node node) throws IOException {
            TDOMWriter.this.writeRaw("<![CDATA[");
            TDOMWriter.this.writeRaw(node.getNodeValue());
            TDOMWriter.this.writeRaw("]]>");
        }
    }

    private class TextNodeWriter
    implements NodeWriter {
        private TextNodeWriter() {
        }

        public void write(Node node) throws IOException {
            String string = node.getNodeValue();
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                if (c < '&' && c > '>') {
                    TDOMWriter.this.writeRaw(c);
                } else if (c == '&') {
                    TDOMWriter.this.writeRaw("&amp;");
                } else if (c == '<') {
                    TDOMWriter.this.writeRaw("&lt;");
                } else if (c == '>') {
                    TDOMWriter.this.writeRaw("&gt;");
                } else {
                    TDOMWriter.this.writeRaw(c);
                }
                ++n2;
            }
        }
    }

    private class ElementNodeWriter
    implements NodeWriter {
        private ElementNodeWriter() {
        }

        public void write(Node node) throws IOException {
            String string = node.getNodeName();
            TDOMWriter.this.writeRaw('<');
            TDOMWriter.this.writeRaw(string);
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap != null ? namedNodeMap.getLength() : 0;
            int n2 = 0;
            while (n2 < n) {
                Node node2 = namedNodeMap.item(n2);
                TDOMWriter.this.writeRaw(' ');
                TDOMWriter.this.writeRaw(node2.getNodeName());
                TDOMWriter.this.writeRaw("=\"");
                String string2 = node2.getNodeValue();
                int n3 = string2.length();
                int n4 = 0;
                while (n4 < n3) {
                    char c = string2.charAt(n4);
                    if (c < '\"' || c > '>') {
                        TDOMWriter.this.writeRaw(c);
                    } else if (c == '\"') {
                        TDOMWriter.this.writeRaw("&quot;");
                    } else if (c == '\'') {
                        TDOMWriter.this.writeRaw("&apos;");
                    } else if (c == '&') {
                        TDOMWriter.this.writeRaw("&amp;");
                    } else if (c == '<') {
                        TDOMWriter.this.writeRaw("&lt;");
                    } else if (c == '>') {
                        TDOMWriter.this.writeRaw("&gt;");
                    } else {
                        TDOMWriter.this.writeRaw(c);
                    }
                    ++n4;
                }
                TDOMWriter.this.writeRaw('\"');
                ++n2;
            }
            TDOMWriter.this.writeRaw('>');
            if (node.hasChildNodes()) {
                TDOMWriter.this.writeChildNodes(node);
            }
            TDOMWriter.this.writeRaw("</");
            TDOMWriter.this.writeRaw(string);
            TDOMWriter.this.writeRaw('>');
        }
    }

    private static interface NodeWriter {
        public void write(Node var1) throws IOException;
    }
}

