/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel.dom;

import com.softwareag.tamino.db.api.common.TContractVerifier;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.io.TStreamReadException;
import com.softwareag.tamino.db.api.io.TStreamWriteException;
import com.softwareag.tamino.db.api.namespace.TInoNamespace;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.dom.TDOMReader;
import com.softwareag.tamino.db.api.objectModel.dom.TDOMWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TDOMAdapter
extends TXMLObject
implements Serializable {
    private boolean isBuildFromDocument = false;
    private Document document = null;
    private Element element = null;
    private String encoding = "";
    private TDOMWriter domWriter = null;
    private TDOMReader domReader = null;
    private static String inoNamespace = TInoNamespace.getInstance().getUri();

    public TDOMAdapter() {
        this((Element)null);
    }

    public TDOMAdapter(Document document) {
        this(document != null ? document.getDocumentElement() : (Element)null);
        this.isBuildFromDocument = true;
    }

    public TDOMAdapter(Element element) {
        if (element != null) {
            this.document = element.getOwnerDocument();
            this.element = element;
        }
        this.initializeIOHelpers();
    }

    public void setDocname(String string) {
        if (string == null || string.equals("")) {
            if (this.element == null) {
                super.setDocname(null);
            } else if (this.element.hasAttribute(TInoNamespace.DOCNAME.getQualifiedName())) {
                this.element.removeAttribute(TInoNamespace.DOCNAME.getQualifiedName());
            }
        } else if (this.element == null) {
            super.setDocname(string);
        } else {
            this.element.setAttribute(TInoNamespace.DOCNAME.getQualifiedName(), string);
        }
    }

    public void setId(String string) {
        if (string == null || string.length() == 0) {
            if (this.element == null) {
                super.setId(null);
            } else if (this.element.hasAttribute(TInoNamespace.ID.getQualifiedName())) {
                this.element.removeAttribute(TInoNamespace.ID.getQualifiedName());
            }
        } else if (this.element == null) {
            super.setId(string);
        } else {
            Attr attr = this.element.getAttributeNode(TInoNamespace.ID.getQualifiedName());
            if (attr != null) {
                attr.setValue(string);
            } else {
                this.element.setAttribute(TInoNamespace.ID.getQualifiedName(), string);
            }
        }
    }

    public String getDocname() {
        if (this.element == null) {
            return super.getDocname();
        }
        String string = this.element.getAttribute(TInoNamespace.DOCNAME.getQualifiedName());
        return string != null ? string : "";
    }

    public String getId() {
        if (this.element == null) {
            return super.getId();
        }
        Attr attr = this.element.getAttributeNode(TInoNamespace.ID.getQualifiedName());
        return attr != null ? attr.getValue() : "";
    }

    public String getDoctype() {
        String string = super.getDoctype();
        if (this.element != null && string.equals("")) {
            string = this.element.getTagName();
        }
        return string;
    }

    public Object getDocument() {
        return this.document;
    }

    public Object getElement() {
        return this.element;
    }

    public void readFrom(InputStream inputStream) throws TStreamReadException {
        try {
            this.document = this.domReader.read(inputStream);
            if (this.element == null) {
                super.setDocname(null);
                super.setId(null);
            }
            this.element = this.document.getDocumentElement();
            this.isBuildFromDocument = true;
        }
        catch (Exception exception) {
            throw new TStreamReadException("Problems during parsing input stream and building DOM document.", exception);
        }
    }

    public void readFrom(Reader reader) throws TStreamReadException {
        try {
            this.document = this.domReader.read(reader);
            if (this.element == null) {
                super.setDocname(null);
                super.setId(null);
            }
            this.element = this.document.getDocumentElement();
            this.isBuildFromDocument = true;
        }
        catch (Exception exception) {
            throw new TStreamReadException("Problems during parsing input stream and building DOM document.", exception);
        }
    }

    public void writeTo(OutputStream outputStream) throws TStreamWriteException {
        TContractVerifier.precondition(this.getElement() != null, "No DOM element is given. Writing to output stream not possible!");
        try {
            this.writeTo(new OutputStreamWriter(outputStream, this.encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TStreamWriteException(unsupportedEncodingException);
        }
    }

    public void writeTo(Writer writer) throws TStreamWriteException {
        TContractVerifier.precondition(this.getElement() != null, "No DOM element is given. Writing to output stream not possible!");
        try {
            if (this.isBuildFromDocument) {
                this.domWriter.write(this.document, writer);
            } else {
                this.domWriter.write(this.element, writer);
            }
        }
        catch (IOException iOException) {
            throw new TStreamWriteException(iOException);
        }
    }

    protected boolean canWriteToOutputStream() {
        return this.getElement() != null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        super.writeStateTo(objectOutputStream, true);
        objectOutputStream.writeObject(new Boolean(this.isBuildFromDocument));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.initializeIOHelpers();
        super.readStateFrom(objectInputStream);
        this.isBuildFromDocument = (Boolean)objectInputStream.readObject();
    }

    private void initializeIOHelpers() {
        this.encoding = TPreference.getInstance().getEncoding();
        this.domWriter = new TDOMWriter();
        this.domReader = new TDOMReader();
    }
}

