/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public abstract class TXMLObjectModel {
    private HashMap properties = new HashMap();
    private static HashMap xmlObjectModels = new HashMap();
    private final String SPECIFIER;
    private final Class DOCUMENT_CLASS;
    private final Class ELEMENT_CLASS;
    private final Class ADAPTER_CLASS;
    private final Class INPUTSTREAM_INTERPRETER_CLASS;

    protected TXMLObjectModel(String string, Class clazz, Class clazz2, Class clazz3, Class clazz4) {
        this.SPECIFIER = string;
        this.DOCUMENT_CLASS = clazz;
        this.ELEMENT_CLASS = clazz2;
        this.ADAPTER_CLASS = clazz3;
        this.INPUTSTREAM_INTERPRETER_CLASS = clazz4;
    }

    public static void register(TXMLObjectModel tXMLObjectModel) {
        if (tXMLObjectModel == null) {
            return;
        }
        xmlObjectModels.put(tXMLObjectModel.getSpecifier(), tXMLObjectModel);
    }

    public static void deregister(String string) {
        xmlObjectModels.remove(string);
    }

    public static TXMLObjectModel getRegisteredModel(String string) {
        return (TXMLObjectModel)xmlObjectModels.get(string);
    }

    public static TXMLObjectModel getRegisteredModel(Object object) {
        Iterator iterator = TXMLObjectModel.getRegisteredModels().iterator();
        while (iterator.hasNext()) {
            TXMLObjectModel tXMLObjectModel = (TXMLObjectModel)iterator.next();
            Class clazz = tXMLObjectModel.getDocumentClass();
            Class clazz2 = tXMLObjectModel.getElementClass();
            if ((clazz == null || !clazz.isInstance(object)) && (clazz2 == null || !clazz2.isInstance(object))) continue;
            return tXMLObjectModel;
        }
        return null;
    }

    public static Collection getRegisteredModels() {
        return xmlObjectModels.values();
    }

    public static boolean isRegistered(String string) {
        return xmlObjectModels.containsKey(string);
    }

    public Class getDocumentClass() {
        return this.DOCUMENT_CLASS;
    }

    public Class getElementClass() {
        return this.ELEMENT_CLASS;
    }

    public Class getAdapterClass() {
        return this.ADAPTER_CLASS;
    }

    public Class getInputStreamInterpreterClass() {
        return this.INPUTSTREAM_INTERPRETER_CLASS;
    }

    public Constructor getAdapterConstructor(Object object) {
        Constructor constructor = null;
        Class[] classArray = new Class[]{object.getClass()};
        try {
            if (this.DOCUMENT_CLASS != null && this.DOCUMENT_CLASS.isInstance(object)) {
                return this.findConstructor(object, this.ADAPTER_CLASS);
            }
            if (this.ELEMENT_CLASS != null && this.ELEMENT_CLASS.isInstance(object)) {
                return this.findConstructor(object, this.ADAPTER_CLASS);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return constructor;
    }

    public String getSpecifier() {
        return this.SPECIFIER;
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public Iterator getPropertyKeyIterator() {
        return this.properties.keySet().iterator();
    }

    public Iterator getPropertyIterator() {
        return this.properties.values().iterator();
    }

    private Constructor findConstructor(Object object, Class clazz) {
        Constructor<?> constructor = null;
        Constructor<?>[] constructorArray = clazz.getConstructors();
        int n = 0;
        while (n < constructorArray.length) {
            constructor = constructorArray[n];
            Class<?>[] classArray = constructor.getParameterTypes();
            if (classArray.length == 1 && classArray[0].isInstance(object)) {
                return constructor;
            }
            ++n;
        }
        return null;
    }
}

