/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel;

import com.softwareag.tamino.db.api.common.TContractVerifier;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectModel;
import com.softwareag.tamino.db.api.objectModel.dom.TDOMObjectModel;
import com.softwareag.tamino.db.api.objectModel.jdom.TJDOMObjectModel;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamAdapter;
import com.softwareag.tamino.db.api.objectModel.stream.TStreamObjectModel;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import org.xml.sax.InputSource;

public final class TXMLObjectFactory {
    private static TXMLObjectFactory singleton = null;

    protected TXMLObjectFactory() {
        TXMLObjectModel.register(TJDOMObjectModel.getInstance());
        TXMLObjectModel.register(TDOMObjectModel.getInstance());
        TXMLObjectModel.register(TStreamObjectModel.getInstance());
    }

    public static synchronized TXMLObjectFactory getInstance() {
        if (singleton == null) {
            singleton = new TXMLObjectFactory();
        }
        return singleton;
    }

    public TXMLObject newXMLObject(TXMLObjectModel tXMLObjectModel) {
        TContractVerifier.precondition(tXMLObjectModel != null, "No TXMLObjectModel given. TXMLObject cannot be instantiated!");
        TXMLObject tXMLObject = null;
        try {
            Class clazz = tXMLObjectModel.getAdapterClass();
            tXMLObject = (TXMLObject)clazz.newInstance();
            this.addProperties(tXMLObject, tXMLObjectModel);
        }
        catch (Exception exception) {
            TContractVerifier.precondition(false, "TXMLObject adapter class does not provide default constructor");
        }
        return tXMLObject;
    }

    public TXMLObject newXMLObject(Object object) {
        if (object instanceof Reader) {
            object = new InputSource((Reader)object);
        } else if (object instanceof InputStream) {
            object = new InputSource((InputStream)object);
        }
        TXMLObjectModel tXMLObjectModel = TXMLObjectModel.getRegisteredModel(object);
        TContractVerifier.precondition(tXMLObjectModel != null, "No TXMLObjectModel registered for given class " + object.getClass().getName() + ".");
        TXMLObject tXMLObject = null;
        try {
            Constructor constructor = tXMLObjectModel.getAdapterConstructor(object);
            Object[] objectArray = new Object[]{object};
            tXMLObject = (TXMLObject)constructor.newInstance(objectArray);
            this.addProperties(tXMLObject, tXMLObjectModel);
        }
        catch (Exception exception) {
            TContractVerifier.precondition(false, "TXMLObject adapter class does not provide appropiate constructor");
        }
        return tXMLObject;
    }

    public TXMLObject newXMLObject(InputStream inputStream) {
        return new TStreamAdapter(inputStream);
    }

    public TXMLObject newXMLObject(Reader reader) {
        return new TStreamAdapter(reader);
    }

    private void addProperties(TXMLObject tXMLObject, TXMLObjectModel tXMLObjectModel) {
        Iterator iterator = tXMLObjectModel.getPropertyKeyIterator();
        Iterator iterator2 = tXMLObjectModel.getPropertyIterator();
        while (iterator.hasNext()) {
            tXMLObject.setProperty((String)iterator.next(), iterator2.next());
        }
    }
}

