/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel;

import com.softwareag.tamino.db.api.common.TContractVerifier;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.io.TStreamReadException;
import com.softwareag.tamino.db.api.io.TStreamWriteException;
import com.softwareag.tamino.db.api.objectModel.TDataObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectFactory;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;

public abstract class TXMLObject
extends TDataObject {
    private static TXMLObjectFactory factory = TXMLObjectFactory.getInstance();
    private String docname = "";
    private String id = "";

    protected TXMLObject() {
        this("", "");
    }

    protected TXMLObject(String string, String string2) {
        super(string, string2, "text/xml");
    }

    public static TXMLObject newInstance(TXMLObjectModel tXMLObjectModel) {
        return factory.newXMLObject(tXMLObjectModel);
    }

    public static TXMLObject newInstance(Object object) {
        if (factory == null) {
            factory = TXMLObjectFactory.getInstance();
        }
        return factory.newXMLObject(object);
    }

    public static TXMLObject newInstance(InputStream inputStream) {
        if (factory == null) {
            factory = TXMLObjectFactory.getInstance();
        }
        return factory.newXMLObject(inputStream);
    }

    public static TXMLObject newInstance(Reader reader) {
        if (factory == null) {
            factory = TXMLObjectFactory.getInstance();
        }
        return factory.newXMLObject(reader);
    }

    public static TXMLObject newInstance(String string) {
        return TXMLObject.newInstance(new StringReader(string));
    }

    public static TXMLObject newInstance(URL uRL) {
        TXMLObject tXMLObject = null;
        try {
            tXMLObject = TXMLObject.newInstance(uRL.openStream());
        }
        catch (IOException iOException) {
            TContractVerifier.precondition(false, "Problem opening the url stream!");
        }
        return tXMLObject;
    }

    public static TXMLObject newInstance(File file) {
        TXMLObject tXMLObject = null;
        try {
            tXMLObject = TXMLObject.newInstance(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            TContractVerifier.precondition(false, "File not found!");
        }
        return tXMLObject;
    }

    public abstract Object getDocument();

    public abstract Object getElement();

    public void setDocname(String string) {
        this.docname = string != null ? string : "";
    }

    public void setId(String string) {
        this.id = string != null ? string : "";
    }

    public void setContentType(String string) {
        if (string.equals("text/xml")) {
            super.setContentType(string);
        }
    }

    public String getDocname() {
        return this.docname;
    }

    public String getId() {
        return this.id;
    }

    protected abstract boolean canWriteToOutputStream();

    protected void setProperty(String string, Object object) {
    }

    protected void writeStateTo(ObjectOutputStream objectOutputStream, boolean bl) throws IOException {
        objectOutputStream.writeObject(this.getCollection());
        objectOutputStream.writeObject(this.getDoctype());
        objectOutputStream.writeObject(this.getDocname());
        objectOutputStream.writeObject(this.getId());
        objectOutputStream.writeObject(this.getLastModified());
        objectOutputStream.writeObject(this.getContentType());
        objectOutputStream.writeObject(new Boolean(this.canWriteToOutputStream() && bl));
        if (this.canWriteToOutputStream() && bl) {
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)objectOutputStream, TPreference.getInstance().getEncoding());
                this.writeTo(outputStreamWriter);
                outputStreamWriter.flush();
            }
            catch (TStreamWriteException tStreamWriteException) {
                throw new IOException(tStreamWriteException.getMessage());
            }
        }
    }

    protected void readStateFrom(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.setCollection((String)objectInputStream.readObject());
        this.setDoctype((String)objectInputStream.readObject());
        this.setDocname((String)objectInputStream.readObject());
        this.setId((String)objectInputStream.readObject());
        this.setLastModified((String)objectInputStream.readObject());
        this.setContentType((String)objectInputStream.readObject());
        boolean bl = (Boolean)objectInputStream.readObject();
        if (bl) {
            try {
                this.readFrom(objectInputStream);
            }
            catch (TStreamReadException tStreamReadException) {
                throw new IOException(tStreamReadException.getMessage());
            }
        }
    }
}

