/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.objectModel;

import com.softwareag.tamino.db.api.common.TContractVerifier;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.io.TStreamReadException;
import com.softwareag.tamino.db.api.io.TStreamWriteException;
import com.softwareag.tamino.db.api.objectModel.TDataObject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;

public class TNonXMLObject
extends TDataObject
implements Serializable {
    private String id = "";
    private String docname = "";
    private boolean hasConsumableStream = false;
    private InputStream inputStream = null;
    private Reader reader = null;

    protected TNonXMLObject(InputStream inputStream, String string, String string2, String string3, String string4) {
        this.initialize(inputStream, null);
        this.setCollection(string);
        this.setDoctype(string2);
        this.setDocname(string3);
        this.setContentType(string4);
    }

    protected TNonXMLObject(InputStream inputStream) {
        this.initialize(inputStream, null);
    }

    protected TNonXMLObject(Reader reader, String string, String string2, String string3, String string4) {
        this.initialize(null, reader);
        this.setCollection(string);
        this.setDoctype(string2);
        this.setDocname(string3);
        this.setContentType(string4);
    }

    protected TNonXMLObject(Reader reader) {
        this.initialize(null, reader);
    }

    public static TNonXMLObject newInstance(InputStream inputStream, String string, String string2, String string3, String string4) {
        TNonXMLObject tNonXMLObject = TNonXMLObject.newInstance(inputStream);
        tNonXMLObject.setCollection(string);
        tNonXMLObject.setDoctype(string2);
        tNonXMLObject.setDocname(string3);
        tNonXMLObject.setContentType(string4);
        return tNonXMLObject;
    }

    public static TNonXMLObject newInstance(InputStream inputStream) {
        return new TNonXMLObject(inputStream);
    }

    public static TNonXMLObject newInstance(Reader reader, String string, String string2, String string3, String string4) {
        TNonXMLObject tNonXMLObject = TNonXMLObject.newInstance(reader);
        tNonXMLObject.setCollection(string);
        tNonXMLObject.setDoctype(string2);
        tNonXMLObject.setDocname(string3);
        tNonXMLObject.setContentType(string4);
        return tNonXMLObject;
    }

    public static TNonXMLObject newInstance(Reader reader) {
        return new TNonXMLObject(reader);
    }

    public static TNonXMLObject newInstance(String string, String string2, String string3, String string4, String string5) {
        TNonXMLObject tNonXMLObject = TNonXMLObject.newInstance(string);
        tNonXMLObject.setCollection(string2);
        tNonXMLObject.setDoctype(string3);
        tNonXMLObject.setDocname(string4);
        tNonXMLObject.setContentType(string5);
        return tNonXMLObject;
    }

    public static TNonXMLObject newInstance(String string) {
        TNonXMLObject tNonXMLObject = null;
        try {
            tNonXMLObject = new TNonXMLObject(new FileInputStream(string));
        }
        catch (IOException iOException) {
            TContractVerifier.precondition(false, "FileInputStream for " + string + " could not be instantiated!");
        }
        return tNonXMLObject;
    }

    public void readFrom(InputStream inputStream) throws TStreamReadException {
        this.initialize(inputStream, null);
    }

    public void readFrom(Reader reader) throws TStreamReadException {
        this.initialize(null, reader);
    }

    public void writeTo(OutputStream outputStream) throws TStreamWriteException {
        TContractVerifier.precondition(this.hasConsumableStream(), "No consumable stream given! Object cannot be written.");
        try {
            this.writeStreamTo(outputStream);
        }
        catch (IOException iOException) {
            throw new TStreamWriteException("Problems during writing input stream to byte output stream!", iOException);
        }
    }

    public void writeTo(Writer writer) throws TStreamWriteException {
        TContractVerifier.precondition(this.hasConsumableStream(), "No consumable stream given! Object cannot be written.");
        TContractVerifier.precondition(this.inputStream == null, "Underlying byte input stream cannot be written to character output stream!");
        try {
            this.writeStreamTo(writer);
        }
        catch (IOException iOException) {
            throw new TStreamWriteException("Problems during writing character input stream to character output stream!", iOException);
        }
    }

    protected boolean canWriteToOutputStream() {
        return this.hasConsumableStream();
    }

    public void setDocname(String string) {
        this.docname = string != null ? string : "";
    }

    public void setId(String string) {
        this.id = string != null ? string : "";
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Reader getReader() {
        return this.reader;
    }

    public String getDocname() {
        return this.docname;
    }

    public String getId() {
        return this.id;
    }

    public boolean hasConsumableStream() {
        return this.hasConsumableStream;
    }

    private void writeStreamTo(OutputStream outputStream) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        if (this.inputStream != null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.inputStream);
            byte[] byArray = new byte[1024];
            int n = -1;
            while ((n = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        } else {
            String string = TPreference.getInstance().getEncoding();
            BufferedReader bufferedReader = new BufferedReader(this.reader);
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                bufferedOutputStream.write(string2.getBytes(string));
            }
        }
        bufferedOutputStream.flush();
        this.hasConsumableStream = false;
    }

    private void writeStreamTo(Writer writer) throws IOException {
        TContractVerifier.precondition(this.reader != null, "No character input stream given for the writing to character output stream!");
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        BufferedReader bufferedReader = new BufferedReader(this.reader);
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            bufferedWriter.write(string, 0, string.length());
        }
        bufferedWriter.flush();
        this.hasConsumableStream = false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.getCollection());
        objectOutputStream.writeObject(this.getDoctype());
        objectOutputStream.writeObject(this.getDocname());
        objectOutputStream.writeObject(this.getId());
        objectOutputStream.writeObject(this.getLastModified());
        objectOutputStream.writeObject(this.getContentType());
        objectOutputStream.writeObject(new Boolean(this.canWriteToOutputStream()));
        if (this.canWriteToOutputStream()) {
            try {
                this.writeTo(objectOutputStream);
            }
            catch (TStreamWriteException tStreamWriteException) {
                throw new IOException(tStreamWriteException.getMessage());
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.setCollection((String)objectInputStream.readObject());
        this.setDoctype((String)objectInputStream.readObject());
        this.setDocname((String)objectInputStream.readObject());
        this.setId((String)objectInputStream.readObject());
        this.setLastModified((String)objectInputStream.readObject());
        this.setContentType((String)objectInputStream.readObject());
        boolean bl = (Boolean)objectInputStream.readObject();
        if (bl) {
            try {
                this.readFrom(objectInputStream);
            }
            catch (TStreamReadException tStreamReadException) {
                throw new IOException(tStreamReadException.getMessage());
            }
        }
    }

    private void initialize(InputStream inputStream, Reader reader) {
        TContractVerifier.precondition(inputStream != null || reader != null, "No input stream is given!");
        this.inputStream = inputStream;
        this.reader = reader;
        this.hasConsumableStream = true;
    }
}

