/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation.http;

import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TContractVerifier;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.common.TTrace;
import com.softwareag.tamino.db.api.invocation.TAbstractInvocation;
import com.softwareag.tamino.db.api.invocation.TAuthorizationException;
import com.softwareag.tamino.db.api.invocation.TCommunicationException;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.invocation.http.THTTPAuthorization;
import com.softwareag.tamino.db.api.invocation.http.THTTPAuthorizationResult;
import com.softwareag.tamino.db.api.invocation.http.THTTPInvocationRequestWriter;
import com.softwareag.tamino.db.api.invocation.http.TURLPathEncoder;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import com.softwareag.tamino.db.api.namespace.TInoNamespace;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class THTTPInvocation
extends TAbstractInvocation {
    private THTTPInvocationRequestWriter invocationRequestWriter = new THTTPInvocationRequestWriter();
    private THTTPAuthorization authorization = new THTTPAuthorization();
    private TURLPathEncoder urlPathEncoder = TURLPathEncoder.getInstance();

    public THTTPInvocation(String string, String string2, String string3) throws TInvocationException {
        super(string, string2, string3);
        TCommunicationException tCommunicationException = this.checkAvailableServer();
        if (tCommunicationException != null) {
            throw tCommunicationException;
        }
    }

    public THTTPInvocation(String string) throws TInvocationException {
        this(string, "", "");
    }

    protected TInputStream doInvoke(TCommandStatement tCommandStatement, String string, String string2, String string3, boolean bl) throws TInvocationException {
        if (!(tCommandStatement != null || string == null || string.equals("") || string2 == null || string2.equals("") || string3 == null || string3.equals(""))) {
            return this.doGetInvoke(null, string, string2, string3, bl);
        }
        if (this.workaroundIsRequiredFor(tCommandStatement.getCommand())) {
            return this.doGetInvoke(tCommandStatement, string, string2, string3, bl);
        }
        TContractVerifier.precondition(tCommandStatement != null && !tCommandStatement.toString().equals(""), "No TCommandStatement instance given!");
        TContractVerifier.precondition(!this.isClosed(), "Connection with Tamino is closed. Commands cannot be invoked on Tamino anymore!");
        try {
            Object object;
            String string4 = this.getURL(this.getDatabaseURI(), string, string2, string3);
            TTrace.trace(this, "Invoke for url: " + string4);
            TTrace.trace(this, "On collection: " + string + " doctype: " + string2 + " docname: " + string3);
            TTrace.trace(this, "Command Statement: " + tCommandStatement.toString());
            TInputStream tInputStream = null;
            String string5 = "BASIC";
            while (string5.length() > 0) {
                object = this.getHttpURLConnection(string4);
                THTTPAuthorizationResult tHTTPAuthorizationResult = this.authorize(string5, (URLConnection)object, this.getUserId(), this.getPassword());
                this.invocationRequestWriter.setConnection((HttpURLConnection)object);
                this.invocationRequestWriter.write(tCommandStatement);
                tInputStream = this.getInputStream((HttpURLConnection)object);
                string5 = this.verifyAuthorizationResult(tHTTPAuthorizationResult);
            }
            object = tInputStream.getHeader();
            ((TStreamHeader)object).put("X-API-Collection", string);
            ((TStreamHeader)object).put("X-API-Doctype", string2);
            TTrace.trace(this, "Stream Header: " + object);
            return tInputStream;
        }
        catch (TInvocationException tInvocationException) {
            throw tInvocationException;
        }
        catch (Exception exception) {
            throw new TCommunicationException(exception);
        }
    }

    protected void doClose() {
    }

    private TInputStream doGetInvoke(TCommandStatement tCommandStatement, String string, String string2, String string3, boolean bl) throws TInvocationException {
        TContractVerifier.precondition(!this.isClosed(), "Connection with Tamino is closed. Commands cannot be invoked on Tamino anymore!");
        TTrace.trace(this, "Perform a workaround invocation with HTTP GET.");
        try {
            Object object;
            String string4 = this.getURL(this.getDatabaseURI(), string, string2, string3);
            if (tCommandStatement != null) {
                string4 = string4 + "?" + tCommandStatement.toString();
            }
            TTrace.trace(this, "Invoke for url: " + string4);
            TInputStream tInputStream = null;
            String string5 = "BASIC";
            while (string5.length() > 0) {
                object = this.getHttpURLConnection(string4);
                THTTPAuthorizationResult tHTTPAuthorizationResult = this.authorize(string5, (URLConnection)object, this.getUserId(), this.getPassword());
                ((HttpURLConnection)object).setRequestMethod("GET");
                if (this.getTransactionModeCoordinator() != null && bl) {
                    this.getTransactionModeCoordinator().writeModeTo((URLConnection)object);
                }
                tInputStream = this.getInputStream((HttpURLConnection)object);
                string5 = this.verifyAuthorizationResult(tHTTPAuthorizationResult);
            }
            object = tInputStream.getHeader();
            ((TStreamHeader)object).put("X-API-Collection", string);
            ((TStreamHeader)object).put("X-API-Doctype", string2);
            TTrace.trace(this, "Stream Header: " + object);
            return tInputStream;
        }
        catch (TInvocationException tInvocationException) {
            throw tInvocationException;
        }
        catch (IOException iOException) {
            throw new TCommunicationException(iOException);
        }
    }

    private TCommunicationException checkAvailableServer() {
        try {
            TCommandStatement tCommandStatement = new TCommandStatement(TCommand.DIAGNOSE, TCommandValue.PING);
            TInputStream tInputStream = this.doInvoke(tCommandStatement, null, null, null, false);
            Document document = this.getDocument(tInputStream);
            NodeList nodeList = document.getElementsByTagName(TInoNamespace.MESSAGE_LINE.getQualifiedName());
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node;
                Element element = (Element)nodeList.item(n);
                if (element.getAttribute(TInoNamespace.SUBJECT.getQualifiedName()) != null && (node = element.getFirstChild()) != null && node.getNodeValue().equals("is alive")) {
                    return null;
                }
                ++n;
            }
            return new TCommunicationException("Server not available for " + this.getDatabaseURI() + " because of wrong response");
        }
        catch (Exception exception) {
            return new TCommunicationException("Server not available for " + this.getDatabaseURI() + " because of a deeper exception", exception);
        }
    }

    private TInputStream getInputStream(HttpURLConnection httpURLConnection) throws TCommunicationException {
        try {
            if (httpURLConnection.getResponseCode() == 404) {
                TTrace.trace("File not found while retrieving!");
                return new TInputStream(null, this.getStreamHeader(httpURLConnection));
            }
            if (httpURLConnection.getResponseCode() != 200 && httpURLConnection.getResponseCode() != 401) {
                throw new TCommunicationException("HTTP error " + httpURLConnection.getResponseCode() + " " + httpURLConnection.getResponseMessage());
            }
            if (!TTrace.hasActiveTrace()) {
                return new TInputStream(httpURLConnection.getInputStream(), this.getStreamHeader(httpURLConnection));
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream(), TPreference.getInstance().getDefaultBufferSize());
            bufferedInputStream.mark(TPreference.getInstance().getDefaultBufferSize());
            byte[] byArray = new byte[TPreference.getInstance().getDefaultBufferSize()];
            int n = bufferedInputStream.read(byArray);
            TTrace.trace(this, "Stream Contents: " + TTrace.TConverter.toString(byArray, n));
            bufferedInputStream.reset();
            return new TInputStream(bufferedInputStream, this.getStreamHeader(httpURLConnection));
        }
        catch (IOException iOException) {
            TTrace.trace("IOException while retrieving HttpConnection.getResponseCode()");
            return new TInputStream(null, this.getStreamHeader(httpURLConnection));
        }
    }

    public TStreamHeader getStreamHeader(URLConnection uRLConnection) {
        String string;
        TStreamHeader tStreamHeader = new TStreamHeader();
        int n = 1;
        while (uRLConnection.getHeaderFieldKey(n) != null) {
            string = uRLConnection.getHeaderFieldKey(n);
            String string2 = uRLConnection.getHeaderField(n);
            tStreamHeader.put(string, string2);
            ++n;
        }
        string = uRLConnection.getHeaderField("Last-Modified");
        if (string != null && string.length() > 0) {
            tStreamHeader.put("X-API-LastModified", string);
        }
        return tStreamHeader;
    }

    private String getURL(String string, String string2, String string3, String string4) {
        String string5 = null;
        string5 = string2 == null || string2.equals("") ? string : (string3 == null || string3.equals("") ? string + "/" + string2 : (string4 == null || string4.equals("") ? string + "/" + string2 + "/" + string3 : string + "/" + this.urlPathEncoder.encode(string2) + "/" + this.urlPathEncoder.encode(string3) + "/" + this.urlPathEncoder.encode(string4)));
        return string5;
    }

    private HttpURLConnection getHttpURLConnection(String string) throws TCommunicationException {
        try {
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            return httpURLConnection;
        }
        catch (MalformedURLException malformedURLException) {
            throw new TCommunicationException("URL did not exist " + string, malformedURLException);
        }
        catch (IOException iOException) {
            throw new TCommunicationException("Error open HttpUrlConnection (" + iOException.getMessage() + ")", iOException);
        }
    }

    private Document getDocument(InputStream inputStream) throws Exception {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return documentBuilder.parse(new InputSource(inputStream));
    }

    private boolean workaroundIsRequiredFor(TCommand tCommand) {
        return tCommand == TCommand.DIAGNOSE;
    }

    private boolean requiresAuthorization() {
        return this.getUserId().length() > 0 || this.getPassword().length() > 0;
    }

    private THTTPAuthorizationResult authorize(String string, URLConnection uRLConnection, String string2, String string3) {
        THTTPAuthorizationResult tHTTPAuthorizationResult = null;
        if (this.requiresAuthorization()) {
            tHTTPAuthorizationResult = this.authorization.authorize(string, uRLConnection, this.getUserId(), this.getPassword());
        }
        return tHTTPAuthorizationResult;
    }

    private String verifyAuthorizationResult(THTTPAuthorizationResult tHTTPAuthorizationResult) throws TAuthorizationException {
        String string = "";
        if (tHTTPAuthorizationResult != null && !tHTTPAuthorizationResult.isSuccessfull()) {
            if (!this.authorization.supportsScheme(tHTTPAuthorizationResult.getAuthenticationScheme())) {
                throw new TAuthorizationException("Authorization failed. Requested Scheme is not supported by API!");
            }
            if (tHTTPAuthorizationResult.getScheme().equals(tHTTPAuthorizationResult.getAuthenticationScheme())) {
                throw new TAuthorizationException("Authorization failed. Invalid userId and password!");
            }
            string = tHTTPAuthorizationResult.getAuthenticationScheme();
        }
        return string;
    }
}

