/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation.http;

import com.softwareag.tamino.db.api.common.TContractVerifier;
import com.softwareag.tamino.db.api.common.TTrace;
import com.softwareag.tamino.db.api.invocation.TBase64EncodingStrategy;
import com.softwareag.tamino.db.api.invocation.TEncodingStrategy;
import com.softwareag.tamino.db.api.invocation.http.THTTPAuthorizationResult;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;

public class THTTPAuthorization {
    public static final String BASIC_SCHEME = "BASIC";
    public static final String DIGEST_SCHEME = "DIGEST";
    private HashMap encodingStrategyMap = new HashMap();
    private TEncodingStrategy defaultEncodingStrategy;
    private static THTTPAuthorization singleton = null;

    public THTTPAuthorization() {
        this.encodingStrategyMap.put(BASIC_SCHEME, TBase64EncodingStrategy.getInstance());
        this.defaultEncodingStrategy = (TEncodingStrategy)this.encodingStrategyMap.get(BASIC_SCHEME);
    }

    public static synchronized THTTPAuthorization getInstance() {
        if (singleton == null) {
            singleton = new THTTPAuthorization();
        }
        return singleton;
    }

    public THTTPAuthorizationResult authorize(URLConnection uRLConnection, String string, String string2) {
        return this.authorize(BASIC_SCHEME, uRLConnection, string, string2);
    }

    public THTTPAuthorizationResult authorize(String string, URLConnection uRLConnection, String string2, String string3) {
        TContractVerifier.precondition(this.supportsScheme(string), "Authorization with requested scheme " + string + " not supported!");
        TEncodingStrategy tEncodingStrategy = (TEncodingStrategy)this.encodingStrategyMap.get(string);
        String string4 = string + " " + tEncodingStrategy.encode(string2 + ":" + string3);
        uRLConnection.setRequestProperty("Authorization", string4);
        uRLConnection.setRequestProperty("User", string2);
        uRLConnection.setRequestProperty("X-INO-Authentication", string2);
        TTrace.trace(this, "Authorization: " + string4);
        return new THTTPAuthorizationResult(uRLConnection, string2, string3, string);
    }

    public boolean supportsScheme(String string) {
        Iterator iterator = this.encodingStrategyMap.keySet().iterator();
        while (iterator.hasNext()) {
            if (string != iterator.next()) continue;
            return true;
        }
        return this.encodingStrategyMap.get(string.toUpperCase()) != null;
    }

    public void registerEncodingStrategy(String string, TEncodingStrategy tEncodingStrategy) {
        this.encodingStrategyMap.put(string, tEncodingStrategy);
    }
}

