/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.invocation;

import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TTrace;
import com.softwareag.tamino.db.api.connection.TTransactionModeCoordinator;
import com.softwareag.tamino.db.api.connection.TTransactionModeUpdateException;
import com.softwareag.tamino.db.api.invocation.TInvocation;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.io.TInputStream;

public abstract class TAbstractInvocation
implements TInvocation {
    private String databaseURI = "";
    private String userId = "";
    private String password = "";
    private TTransactionModeCoordinator transactionModeCoordinator = null;
    private boolean isClosed = false;

    public TAbstractInvocation(String string, String string2, String string3) throws TInvocationException {
        this.databaseURI = string;
        this.userId = string2 != null ? string2 : "";
        this.password = string3 != null ? string3 : "";
    }

    public TAbstractInvocation(String string) throws TInvocationException {
        this.databaseURI = string;
    }

    public TInputStream invoke(TCommandStatement tCommandStatement) throws TInvocationException {
        return this.invoke(tCommandStatement, true);
    }

    public TInputStream invoke(TCommandStatement tCommandStatement, boolean bl) throws TInvocationException {
        return this.doTemplateInvoke(tCommandStatement, null, null, null, bl);
    }

    public TInputStream invoke(TCommandStatement tCommandStatement, String string) throws TInvocationException {
        return this.invoke(tCommandStatement, string, true);
    }

    public TInputStream invoke(TCommandStatement tCommandStatement, String string, boolean bl) throws TInvocationException {
        return this.doTemplateInvoke(tCommandStatement, string, null, null, bl);
    }

    public TInputStream invoke(TCommandStatement tCommandStatement, String string, String string2, String string3) throws TInvocationException {
        return this.invoke(tCommandStatement, string, string2, string3, true);
    }

    public TInputStream invoke(TCommandStatement tCommandStatement, String string, String string2, String string3, boolean bl) throws TInvocationException {
        return this.doTemplateInvoke(tCommandStatement, string, string2, string3, bl);
    }

    public boolean supports(TCommand tCommand) {
        if (tCommand == TCommand.CURSOR) {
            return this.transactionModeCoordinator != null && this.transactionModeCoordinator.supports(tCommand);
        }
        return true;
    }

    public void setTransactionModeCoordinator(TTransactionModeCoordinator tTransactionModeCoordinator) {
        this.transactionModeCoordinator = tTransactionModeCoordinator;
    }

    public void close() throws TInvocationException {
        this.doClose();
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    protected String getUserId() {
        return this.userId;
    }

    protected String getPassword() {
        return this.password;
    }

    protected abstract TInputStream doInvoke(TCommandStatement var1, String var2, String var3, String var4, boolean var5) throws TInvocationException;

    protected abstract void doClose() throws TInvocationException;

    protected String getDatabaseURI() {
        return this.databaseURI;
    }

    protected TTransactionModeCoordinator getTransactionModeCoordinator() {
        return this.transactionModeCoordinator;
    }

    private synchronized TInputStream doTemplateInvoke(TCommandStatement tCommandStatement, String string, String string2, String string3, boolean bl) throws TInvocationException {
        TInputStream tInputStream = null;
        try {
            if (this.transactionModeCoordinator != null && tCommandStatement != null) {
                this.transactionModeCoordinator.writeModeTo(tCommandStatement);
                if (TTrace.hasActiveTrace()) {
                    TTrace.trace("TaminoAPI > thread > time > command >");
                    TTrace.trace("TaminoAPI > " + Thread.currentThread() + " > " + System.currentTimeMillis() + " > " + tCommandStatement + " >");
                }
            }
            tInputStream = this.doInvoke(tCommandStatement, string, string2, string3, bl);
            if (bl && tInputStream != null) {
                this.transactionModeCoordinator.updateModeFrom(tInputStream);
                if (TTrace.hasActiveTrace()) {
                    TCommandStatement tCommandStatement2 = new TCommandStatement(TCommand.API_TEST, new TCommandValue("dummy"));
                    this.transactionModeCoordinator.writeModeTo(tCommandStatement2);
                    TTrace.trace("TaminoAPI < thread < time < command <");
                    TTrace.trace("TaminoAPI < " + Thread.currentThread() + " < " + System.currentTimeMillis() + " < " + tCommandStatement2 + " <");
                }
                if (!tInputStream.isGiven()) {
                    throw new TInvocationException("Exception retrieving the response stream!");
                }
            }
        }
        catch (TTransactionModeUpdateException tTransactionModeUpdateException) {
            throw new TInvocationException("Exception during updating transaction mode!", tTransactionModeUpdateException);
        }
        return tInputStream;
    }
}

