/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.ejb.datasource;

import com.softwareag.tamino.db.api.common.TTrace;
import com.softwareag.tamino.db.api.ejb.common.ErrorHandler;
import com.softwareag.tamino.db.api.ejb.datasource.TConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class TPooledConnection
implements PooledConnection {
    private Vector listeners = new Vector();
    private String databaseName;
    private String user = null;
    private String password = null;
    private Properties info;
    private TConnection tConnection = null;
    private static final String CLASS_NAME = "TPooledConnection";

    public TPooledConnection(String string, Properties properties) throws SQLException {
        this.databaseName = string;
        if (!string.toLowerCase().startsWith("http://")) {
            throw new SQLException(ErrorHandler.getMessage("NoValidTaminoURL"));
        }
        if (properties != null) {
            this.info = properties;
            this.user = this.info.getProperty("user");
            this.password = this.info.getProperty("password");
        }
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.trace("TPooledConnection: addConnectionEventListener called");
        this.listeners.addElement(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.trace("TPooledConnection: removeConnectionEventListener called");
        this.listeners.removeElement(connectionEventListener);
    }

    public void close() throws SQLException {
        this.trace("TPooledConnection: close called");
        if (!this.tConnection.isClosed()) {
            this.tConnection.close();
        }
    }

    public Connection getConnection() throws SQLException {
        this.trace("TPooledConnection: getConnection called to " + this.databaseName);
        this.tConnection = new TConnection(this.databaseName, null, this.user, this.password);
        return this.tConnection;
    }

    private void trace(String string) {
        TTrace.trace(Thread.currentThread().getName() + " " + CLASS_NAME + " (" + new Date().toString() + ": " + string);
    }
}

