/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.ejb.datasource;

import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TInvalidatableAccessor;
import com.softwareag.tamino.db.api.accessor.TNonXMLObjectAccessor;
import com.softwareag.tamino.db.api.accessor.TSchemaDefinition2Accessor;
import com.softwareag.tamino.db.api.accessor.TSchemaDefinition3Accessor;
import com.softwareag.tamino.db.api.accessor.TStreamAccessor;
import com.softwareag.tamino.db.api.accessor.TSystemAccessor;
import com.softwareag.tamino.db.api.accessor.TXMLObjectAccessor;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.common.TTrace;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionFactory;
import com.softwareag.tamino.db.api.connection.TIsolationLevel;
import com.softwareag.tamino.db.api.connection.TLocalTransaction;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;
import com.softwareag.tamino.db.api.connection.TServerNotAvailableException;
import com.softwareag.tamino.db.api.connection.TTransactionException;
import com.softwareag.tamino.db.api.connection.TTransactionModeChangeException;
import com.softwareag.tamino.db.api.ejb.TEJBConnection;
import com.softwareag.tamino.db.api.ejb.TEJBConnectionException;
import com.softwareag.tamino.db.api.ejb.TEJBTransactionException;
import com.softwareag.tamino.db.api.ejb.common.ErrorHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

public class TEJBConnectionImpl
implements TEJBConnection {
    private boolean verbose = false;
    private String taminoUrl;
    private boolean autoCommit = false;
    private boolean transactionTerminated = true;
    private TConnection tConnection;
    private TLocalTransaction tTransaction;
    private Connection sqlConnection;
    private ArrayList accessorList = null;

    public TEJBConnectionImpl(String string, String string2, String string3) throws TEJBConnectionException {
        this.taminoUrl = string;
        this.trace("taminoUrl =" + string);
        this.trace("user      =" + string2);
        try {
            TConnectionFactory tConnectionFactory = TConnectionFactory.getInstance();
            this.trace("connection instantiated:" + tConnectionFactory.toString());
            this.tConnection = tConnectionFactory.newConnection(string, string2, string3);
        }
        catch (TServerNotAvailableException tServerNotAvailableException) {
            this.trace("exception when instantiating connection");
            throw new TEJBConnectionException(ErrorHandler.getMessage("TaminoCommunicationEx"), tServerNotAvailableException);
        }
        this.trace("connection established");
    }

    public TNonXMLObjectAccessor newNonXMLObjectAccessor(TAccessLocation tAccessLocation) throws TEJBTransactionException {
        if (this.transactionTerminated) {
            throw new TEJBTransactionException(ErrorHandler.getMessage("NoTransaction"));
        }
        TNonXMLObjectAccessor tNonXMLObjectAccessor = this.tConnection.newNonXMLObjectAccessor(tAccessLocation);
        this.trace("for invalidation: save object in arraylist");
        this.rememberAccessor(tNonXMLObjectAccessor);
        return tNonXMLObjectAccessor;
    }

    public TXMLObjectAccessor newXMLObjectAccessor(TAccessLocation tAccessLocation, Object object) throws TEJBTransactionException {
        if (this.transactionTerminated) {
            throw new TEJBTransactionException(ErrorHandler.getMessage("NoTransaction"));
        }
        TXMLObjectAccessor tXMLObjectAccessor = this.tConnection.newXMLObjectAccessor(tAccessLocation, object);
        this.trace("for invalidation: save object in arraylist");
        this.rememberAccessor(tXMLObjectAccessor);
        return tXMLObjectAccessor;
    }

    public TSchemaDefinition2Accessor newSchemaDefinition2Accessor(Object object) throws TEJBTransactionException {
        if (this.transactionTerminated) {
            throw new TEJBTransactionException(ErrorHandler.getMessage("NoTransaction"));
        }
        TSchemaDefinition2Accessor tSchemaDefinition2Accessor = this.tConnection.newSchemaDefinition2Accessor(object);
        this.trace("for invalidation: save object in arraylist");
        this.rememberAccessor(tSchemaDefinition2Accessor);
        return tSchemaDefinition2Accessor;
    }

    public TSchemaDefinition3Accessor newSchemaDefinition3Accessor(Object object) throws TEJBTransactionException {
        if (this.transactionTerminated) {
            throw new TEJBTransactionException(ErrorHandler.getMessage("NoTransaction"));
        }
        TSchemaDefinition3Accessor tSchemaDefinition3Accessor = this.tConnection.newSchemaDefinition3Accessor(object);
        this.trace("for invalidation: save object in arraylist");
        this.rememberAccessor(tSchemaDefinition3Accessor);
        return tSchemaDefinition3Accessor;
    }

    public TStreamAccessor newStreamAccessor(TAccessLocation tAccessLocation) throws TEJBTransactionException {
        if (this.transactionTerminated) {
            throw new TEJBTransactionException(ErrorHandler.getMessage("NoTransaction"));
        }
        TStreamAccessor tStreamAccessor = this.tConnection.newStreamAccessor(tAccessLocation);
        this.trace("for invalidation: save object in arraylist");
        this.rememberAccessor(tStreamAccessor);
        return tStreamAccessor;
    }

    public TSystemAccessor newSystemAccessor() throws TEJBTransactionException {
        if (this.transactionTerminated) {
            throw new TEJBTransactionException(ErrorHandler.getMessage("NoTransaction"));
        }
        TSystemAccessor tSystemAccessor = this.tConnection.newSystemAccessor();
        this.trace("for invalidation: save object in arraylist");
        this.rememberAccessor(tSystemAccessor);
        return tSystemAccessor;
    }

    public TIsolationLevel getIsolationLevel() {
        return this.tConnection.getIsolationLevel();
    }

    public TLockwaitMode getLockwaitMode() {
        return this.tConnection.getLockwaitMode();
    }

    public void close() throws TEJBTransactionException {
        this.trace("close called");
        try {
            if (this.sqlConnection != null) {
                this.sqlConnection.close();
            } else {
                this.trace("sqlConnection is null, anybody has closed before, just continue");
            }
        }
        catch (SQLException sQLException) {
            this.trace("exception when close");
            throw new TEJBTransactionException(ErrorHandler.getMessage("CloseFailed"), sQLException);
        }
        this.trace("close passed");
        this.sqlConnection = null;
    }

    protected void startSession(Connection connection, TLockwaitMode tLockwaitMode, TIsolationLevel tIsolationLevel) throws TTransactionModeChangeException {
        this.sqlConnection = connection;
        this.transactionTerminated = false;
        this.trace("in startSession");
        this.trace("init ArrayList for invalidation");
        this.accessorList = new ArrayList();
        this.trace("switch on invalidation");
        TPreference.getInstance().setUseInvalidatableAccessorsIsEnabled(true);
        this.trace("switch on invalidation done");
        if (!this.tConnection.usesLocalTransactionMode()) {
            this.trace("LocalTransaction mode is false, so set to true");
            if (tLockwaitMode != null) {
                this.trace("set lockwaitMode to " + tLockwaitMode.toString());
                this.tConnection.setLockwaitMode(tLockwaitMode);
            }
            if (tIsolationLevel != null) {
                this.trace("set isolationLevel to " + tIsolationLevel.toString());
                this.tConnection.setIsolationLevel(tIsolationLevel);
            }
            this.tTransaction = this.tConnection.useLocalTransactionMode();
            this.trace("got tamino transaction ");
        } else {
            this.trace("session already running, ignore that ...");
            this.trace("...and don't set isolation level and lockwaitmode...");
            this.trace("...we must assume, that this is already set");
        }
    }

    protected void closeByContainer() throws TTransactionException, TTransactionModeChangeException {
        if (this.tConnection.usesLocalTransactionMode()) {
            this.tTransaction.rollback();
            this.tConnection.useAutoCommitMode();
        }
    }

    protected void commit() throws TTransactionException, TEJBTransactionException, TTransactionModeChangeException {
        this.trace("in taminoEjbApi commit");
        if (this.transactionTerminated) {
            throw new TEJBTransactionException(ErrorHandler.getMessage("NoTransaction"));
        }
        this.trace("call taminoApi commit");
        this.tTransaction.commit();
        this.trace("call invalidate");
        this.invalidateAccessor();
        this.trace("and disconnect");
        this.tConnection.useAutoCommitMode();
        this.transactionTerminated = true;
    }

    protected void rollback() throws TTransactionException, TEJBTransactionException, TTransactionModeChangeException {
        if (this.transactionTerminated) {
            throw new TEJBTransactionException(ErrorHandler.getMessage("NoTransaction"));
        }
        this.tTransaction.rollback();
        this.invalidateAccessor();
        this.tConnection.useAutoCommitMode();
        this.transactionTerminated = true;
    }

    private void invalidateAccessor() {
        this.trace("invalidate() the accessor");
        Object object = null;
        int n = 0;
        while (n < this.accessorList.size()) {
            this.trace("index in ArrayList is: " + n);
            Object e = this.accessorList.get(n);
            object = e;
            if (e != null) {
                this.trace("at position " + n + " invalidate() accessor:" + object.toString());
                ((TInvalidatableAccessor)object).invalidate();
            }
            ++n;
        }
        this.trace("invalidate() the accessor done");
    }

    private void rememberAccessor(Object object) {
        this.trace("remember accessor");
        this.accessorList.add((TInvalidatableAccessor)object);
        this.trace("remember accessor done");
    }

    private void trace(String string) {
        TTrace.trace("TEJBConnectionImpl: " + string);
    }
}

