/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.ejb.datasource;

import com.softwareag.tamino.db.api.common.TTrace;
import com.softwareag.tamino.db.api.connection.TIsolationLevel;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;
import com.softwareag.tamino.db.api.connection.TTransactionException;
import com.softwareag.tamino.db.api.connection.TTransactionModeChangeException;
import com.softwareag.tamino.db.api.ejb.TEJBConnection;
import com.softwareag.tamino.db.api.ejb.TEJBConnectionException;
import com.softwareag.tamino.db.api.ejb.TEJBTransactionException;
import com.softwareag.tamino.db.api.ejb.common.ErrorHandler;
import com.softwareag.tamino.db.api.ejb.datasource.TDriver;
import com.softwareag.tamino.db.api.ejb.datasource.TEJBConnectionImpl;
import com.softwareag.tamino.db.api.ejb.datasource.TMetaData;
import com.softwareag.tamino.db.api.ejb.datasource.TStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Date;
import java.util.Map;

public class TConnection
implements Connection {
    TDriver driver;
    String taminoUrl;
    TEJBConnectionImpl tamino;
    String catalog = null;
    boolean isClosed = true;
    boolean readOnly = false;
    boolean autoCommit = true;
    int transactionIsolation = 2;
    TMetaData databaseMetaData;
    private boolean verbose = false;
    String className = this.toString().substring(this.toString().lastIndexOf(".") + 1);

    public TConnection(String string, TDriver tDriver, String string2, String string3) throws SQLException {
        this.taminoUrl = string;
        this.driver = tDriver;
        try {
            this.tamino = new TEJBConnectionImpl(string, string2, string3);
            this.isClosed = false;
            this.databaseMetaData = new TMetaData(this);
        }
        catch (Exception exception) {
            throw new SQLException(ErrorHandler.getMessage("ConnectFailed") + " " + exception.getMessage());
        }
    }

    public Statement createStatement() throws SQLException {
        this.trace("createStatement called");
        return new TStatement(this);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.trace("prepareStatement called");
        return null;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.trace("prepareCall called");
        return null;
    }

    public String nativeSQL(String string) throws SQLException {
        this.trace("nativeSQL called");
        return null;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.trace("setAutoCommit called: " + bl);
        this.autoCommit = bl;
    }

    public boolean getAutoCommit() throws SQLException {
        this.trace("getAutoCommit called, return autoCommit: " + this.autoCommit + " (initial value was true)");
        return this.autoCommit;
    }

    public void commit() throws SQLException {
        try {
            this.trace("commit called");
            this.tamino.commit();
            this.trace("commit done");
        }
        catch (TTransactionModeChangeException tTransactionModeChangeException) {
            throw new SQLException(ErrorHandler.getMessage("TaminoCommunicationEx") + " " + tTransactionModeChangeException.getMessage());
        }
        catch (TTransactionException tTransactionException) {
            throw new SQLException(ErrorHandler.getMessage("CommitFailed") + " " + tTransactionException.getMessage());
        }
        catch (TEJBTransactionException tEJBTransactionException) {
            throw new SQLException(ErrorHandler.getMessage("CommitReqBegin") + "  " + tEJBTransactionException.getMessage());
        }
    }

    public void rollback() throws SQLException {
        try {
            this.trace("rollback called");
            this.tamino.rollback();
            this.trace("rollback done");
        }
        catch (TTransactionModeChangeException tTransactionModeChangeException) {
            throw new SQLException(ErrorHandler.getMessage("TaminoCommunicationEx") + " " + tTransactionModeChangeException.getMessage());
        }
        catch (TTransactionException tTransactionException) {
            throw new SQLException(ErrorHandler.getMessage("RollbackFailed") + " " + tTransactionException.getMessage());
        }
        catch (TEJBTransactionException tEJBTransactionException) {
            throw new SQLException(ErrorHandler.getMessage("RollbackReqBegin") + " " + tEJBTransactionException.getMessage());
        }
    }

    public void close() throws SQLException {
        this.trace("close called");
        try {
            this.tamino.closeByContainer();
            this.tamino = null;
            this.isClosed = true;
        }
        catch (TTransactionModeChangeException tTransactionModeChangeException) {
            throw new SQLException(ErrorHandler.getMessage("TaminoCommunicationEx") + " " + tTransactionModeChangeException.getMessage());
        }
        catch (TTransactionException tTransactionException) {
            throw new SQLException(ErrorHandler.getMessage("TaminoTransactionEx") + " " + tTransactionException.getMessage());
        }
    }

    public boolean isClosed() throws SQLException {
        this.trace("isClosed called; returns " + this.isClosed);
        return this.isClosed;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.trace("getMetaData called");
        return this.databaseMetaData;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.trace("setReadOnly called: " + bl);
        this.readOnly = bl;
    }

    public boolean isReadOnly() throws SQLException {
        this.trace("isReadOnly called: " + this.readOnly);
        return this.readOnly;
    }

    public void setCatalog(String string) throws SQLException {
        this.trace("setCatalog called: " + string);
        this.catalog = string;
    }

    public String getCatalog() throws SQLException {
        this.trace("getCatalog called: " + this.catalog);
        return null;
    }

    public void setTransactionIsolation(int n) throws SQLException {
    }

    public int getTransactionIsolation() throws SQLException {
        this.trace("getTransactionIsolation called: " + this.transactionIsolation);
        return this.transactionIsolation;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.trace("getWarnings called: ");
        return null;
    }

    public void clearWarnings() throws SQLException {
        this.trace("clearWarnings called: ");
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.trace("createStatement called: ");
        return null;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.trace("prepareStatement called: ");
        return null;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.trace("prepareCall called: ");
        return null;
    }

    public Map getTypeMap() throws SQLException {
        this.trace("getTypeMap called: ");
        return null;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.trace("setTypeMap called: ");
    }

    public String getURL() {
        this.trace("getURL called: ");
        return this.taminoUrl;
    }

    public String getDriverName() {
        this.trace("getDriverName called: ");
        if (this.driver == null) {
            return "";
        }
        return this.driver.getDriverName();
    }

    public TEJBConnection getTEJBConnection(Connection connection, TLockwaitMode tLockwaitMode, TIsolationLevel tIsolationLevel) throws TEJBConnectionException {
        this.trace("getTEJBConnection called: ");
        try {
            this.tamino.startSession(connection, tLockwaitMode, tIsolationLevel);
        }
        catch (TTransactionModeChangeException tTransactionModeChangeException) {
            throw new TEJBConnectionException(ErrorHandler.getMessage("TaminoConnectionEx") + " " + tTransactionModeChangeException.getMessage(), tTransactionModeChangeException);
        }
        catch (TTransactionException tTransactionException) {
            throw new TEJBConnectionException(ErrorHandler.getMessage("TaminoTransactionEx") + " " + tTransactionException.getMessage(), tTransactionException);
        }
        return this.tamino;
    }

    private void trace(String string) {
        TTrace.trace(Thread.currentThread().getName() + " " + this.className + " (" + new Date().toString() + ": " + string);
    }
}

