/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.ejb.datasource;

import com.softwareag.tamino.db.api.common.TTrace;
import com.softwareag.tamino.db.api.ejb.datasource.TBaseDataSource;
import com.softwareag.tamino.db.api.ejb.datasource.TPooledConnection;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class TConnPoolDataSource
extends TBaseDataSource
implements ConnectionPoolDataSource {
    private transient PrintWriter log = null;
    private int timeout = 0;
    private static final String CLASS_NAME = "TConnPoolDataSource";
    private Context context = null;
    private Hashtable hashtable = null;

    public PooledConnection getPooledConnection() throws SQLException {
        this.trace("getPooledConnection() with no user or password");
        return this.getPooledConnection(this.user, this.password);
    }

    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        this.trace("getPooledConnection(): databaseName = " + this.databaseName + " user = " + string);
        Properties properties = new Properties();
        ((Hashtable)properties).put("trace", this.trace);
        ((Hashtable)properties).put("language", this.language);
        if (string != null) {
            ((Hashtable)properties).put("user", string);
            this.user = string;
        }
        if (string2 != null) {
            ((Hashtable)properties).put("password", string2);
            this.password = string2;
        }
        if (this.connectionAttribute != null) {
            ((Hashtable)properties).put("connectionAttribute", this.connectionAttribute);
        }
        return new TPooledConnection(this.databaseName, properties);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.log;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.log = printWriter;
    }

    public int getLoginTimeout() throws SQLException {
        return this.timeout;
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.timeout = n;
    }

    protected void setProperties(Hashtable hashtable) {
        this.hashtable = hashtable;
    }

    protected void setContext(Context context) {
        this.context = context;
    }

    private void trace(String string) {
        TTrace.trace(Thread.currentThread().getName() + " " + CLASS_NAME + " (" + new Date().toString() + ": " + string);
    }
}

