/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.ejb;

import com.softwareag.tamino.db.api.common.TTrace;
import com.softwareag.tamino.db.api.connection.TIsolationLevel;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;
import com.softwareag.tamino.db.api.ejb.TEJBConnection;
import com.softwareag.tamino.db.api.ejb.TEJBException;
import com.softwareag.tamino.db.api.ejb.TEJBSystemException;
import com.softwareag.tamino.db.api.ejb.common.ErrorHandler;
import com.softwareag.tamino.db.api.ejb.datasource.TConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class TEJBConnectionFactory {
    private static TEJBConnectionFactory singleton = new TEJBConnectionFactory();
    private static final String CLASS_NAME = "TEJBConnectionFactory";

    private TEJBConnectionFactory() {
    }

    public TEJBConnection newConnection(String string) throws TEJBException {
        return this.newConnection(string, null, null);
    }

    public TEJBConnection newConnection(String string, TLockwaitMode tLockwaitMode, TIsolationLevel tIsolationLevel) throws TEJBException {
        TEJBConnection tEJBConnection = null;
        try {
            this.trace("looking for data source " + string);
            InitialContext initialContext = new InitialContext();
            DataSource dataSource = (DataSource)initialContext.lookup(string);
            Connection connection = dataSource.getConnection();
            Statement statement = connection.createStatement();
            statement.execute("nix");
            Connection connection2 = connection.getMetaData().getConnection();
            tEJBConnection = ((TConnection)connection2).getTEJBConnection(connection, tLockwaitMode, tIsolationLevel);
        }
        catch (NamingException namingException) {
            throw new TEJBSystemException(ErrorHandler.getMessage("LookupFailed") + " " + namingException.getMessage(), namingException);
        }
        catch (SQLException sQLException) {
            throw new TEJBSystemException(ErrorHandler.getMessage("ConnectFailed") + " " + sQLException.getMessage(), sQLException);
        }
        return tEJBConnection;
    }

    public static TEJBConnectionFactory getInstance() {
        return singleton;
    }

    private void trace(String string) {
        TTrace.trace(Thread.currentThread().getName() + " " + CLASS_NAME + " (" + new Date().toString() + ": " + string);
    }
}

