/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.tamino.db.api.accessor.TAccessFailureMessage;
import com.softwareag.tamino.db.api.accessor.TAccessorException;
import com.softwareag.tamino.db.api.accessor.TGenericAccessor;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TContractVerifier;
import com.softwareag.tamino.db.api.common.TTrace;
import com.softwareag.tamino.db.api.connection.TAbstractTransaction;
import com.softwareag.tamino.db.api.connection.TAutoCommitTransactionMode;
import com.softwareag.tamino.db.api.connection.TGlobalTransactionMode;
import com.softwareag.tamino.db.api.connection.TIsolationLevel;
import com.softwareag.tamino.db.api.connection.TIsolationMode;
import com.softwareag.tamino.db.api.connection.TLocalTransaction;
import com.softwareag.tamino.db.api.connection.TLocalTransactionImpl;
import com.softwareag.tamino.db.api.connection.TLocalTransactionMode;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;
import com.softwareag.tamino.db.api.connection.TSessionState;
import com.softwareag.tamino.db.api.connection.TTransactionMode;
import com.softwareag.tamino.db.api.connection.TTransactionModeChangeException;
import com.softwareag.tamino.db.api.connection.TTransactionModeCoordinator;
import com.softwareag.tamino.db.api.connection.TTransactionModeUpdateException;
import com.softwareag.tamino.db.api.io.TInputStream;
import java.net.URLConnection;
import java.util.HashMap;

public class TTransactionModeCoordinatorImpl
implements TTransactionModeCoordinator {
    private static final String AUTOCOMMIT_TRANSACTION_MODE = "AutoCommitTransactionMode";
    private static final String LOCAL_TRANSACTION_MODE = "LocalTransactionMode";
    private static final String GLOBAL_TRANSACTION_MODE = "GlobalTransactionMode";
    private TGenericAccessor genericAccessor = null;
    private TSessionState sessionState = null;
    private TIsolationMode isolationMode = null;
    private HashMap transactionModeMap = null;
    private TTransactionMode transactionMode = null;
    private TAbstractTransaction transaction = null;

    public TTransactionModeCoordinatorImpl(TGenericAccessor tGenericAccessor) {
        this.initialize(tGenericAccessor);
    }

    public synchronized void useAutoCommitMode() throws TTransactionModeChangeException {
        try {
            block6: {
                if (this.usesAutoCommitMode()) {
                    this.releaseAutoCommitTransactionMode();
                    break block6;
                }
                if (this.usesLocalTransactionMode()) {
                    this.releaseLocalTransactionMode();
                    break block6;
                }
                if (!this.usesGlobalTransactionMode()) break block6;
                this.releaseGlobalTransactionMode();
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.transactionMode = (TTransactionMode)this.transactionModeMap.get(AUTOCOMMIT_TRANSACTION_MODE);
            this.transaction = null;
            throw throwable;
        }
        this.transactionMode = (TTransactionMode)this.transactionModeMap.get(AUTOCOMMIT_TRANSACTION_MODE);
        this.transaction = null;
    }

    public synchronized boolean usesAutoCommitMode() {
        return this.transactionMode == this.transactionModeMap.get(AUTOCOMMIT_TRANSACTION_MODE);
    }

    public synchronized TLocalTransaction useLocalTransactionMode() throws TTransactionModeChangeException {
        TContractVerifier.precondition(this.usesAutoCommitMode(), "Currently no autocommit mode given. Local transaction mode cannot be initiated!");
        try {
            TTransactionMode tTransactionMode;
            this.releaseAutoCommitTransactionMode();
            this.transactionMode = tTransactionMode = (TTransactionMode)this.transactionModeMap.get(LOCAL_TRANSACTION_MODE);
            TCommandStatement tCommandStatement = this.createCommandStatement();
            tCommandStatement.addCommand(TCommand.CONNECT, new TCommandValue("*"));
            this.isolationMode.writeTo(tCommandStatement);
            this.genericAccessor.execute(tCommandStatement);
            this.transaction = new TLocalTransactionImpl(this.genericAccessor);
            return (TLocalTransaction)((Object)this.transaction);
        }
        catch (TAccessorException tAccessorException) {
            this.transactionMode = (TTransactionMode)this.transactionModeMap.get(AUTOCOMMIT_TRANSACTION_MODE);
            this.useAutoCommitMode();
            if (tAccessorException.hasAccessFailureMessage()) {
                throw new TTransactionModeChangeException(tAccessorException.getAccessFailureMessage().toString(), tAccessorException);
            }
            throw new TTransactionModeChangeException("Local transaction mode could not be established. Falling back to autocommit mode!", tAccessorException);
        }
    }

    public synchronized boolean usesLocalTransactionMode() {
        return this.transactionMode == this.transactionModeMap.get(LOCAL_TRANSACTION_MODE);
    }

    public synchronized boolean usesGlobalTransactionMode() {
        return this.transactionMode == this.transactionModeMap.get(GLOBAL_TRANSACTION_MODE);
    }

    public synchronized void resetIsolationMode() {
        TContractVerifier.precondition(this.usesAutoCommitMode(), "Isolation Mode can only be changed during autocommit mode!");
        this.isolationMode.reset();
    }

    public synchronized void setIsolationLevel(TIsolationLevel tIsolationLevel) {
        TContractVerifier.precondition(this.usesAutoCommitMode(), "Isolation Level can only be changed during autocommit mode!");
        this.isolationMode.setIsolationLevel(tIsolationLevel);
    }

    public synchronized void setLockwaitMode(TLockwaitMode tLockwaitMode) {
        TContractVerifier.precondition(this.usesAutoCommitMode(), "Lockwait Mode can only be changed during autocommit state!");
        this.isolationMode.setLockwaitMode(tLockwaitMode);
    }

    public synchronized TIsolationLevel getIsolationLevel() {
        TIsolationLevel tIsolationLevel = this.isolationMode.getIsolationLevel();
        if (tIsolationLevel == null) {
            if (this.usesLocalTransactionMode()) {
                tIsolationLevel = TIsolationMode.DEFAULT_LOCAL_TRANSACTION_MODE.getIsolationLevel();
            } else if (this.usesAutoCommitMode()) {
                tIsolationLevel = TIsolationMode.DEFAULT_AUTO_COMMIT_MODE.getIsolationLevel();
            } else {
                TTrace.trace(this, "Unsopported transaction mode!");
            }
        }
        return tIsolationLevel;
    }

    public synchronized TLockwaitMode getLockwaitMode() {
        TLockwaitMode tLockwaitMode = this.isolationMode.getLockwaitMode();
        if (tLockwaitMode == null) {
            if (this.usesLocalTransactionMode()) {
                tLockwaitMode = TIsolationMode.DEFAULT_LOCAL_TRANSACTION_MODE.getLockwaitMode();
            } else if (this.usesAutoCommitMode()) {
                tLockwaitMode = TIsolationMode.DEFAULT_AUTO_COMMIT_MODE.getLockwaitMode();
            } else {
                TTrace.trace(this, "Unsopported transaction mode!");
            }
        }
        return tLockwaitMode;
    }

    public synchronized void writeModeTo(TCommandStatement tCommandStatement) {
        this.transactionMode.writeTo(tCommandStatement);
    }

    public synchronized void writeModeTo(URLConnection uRLConnection) {
        this.transactionMode.writeTo(uRLConnection);
    }

    public synchronized void updateModeFrom(TInputStream tInputStream) throws TTransactionModeUpdateException {
        this.transactionMode.update(tInputStream);
    }

    public synchronized boolean supports(TCommand tCommand) {
        return this.transactionMode.supports(tCommand);
    }

    private synchronized void releaseAutoCommitTransactionMode() throws TTransactionModeChangeException {
    }

    private synchronized void releaseLocalTransactionMode() throws TTransactionModeChangeException {
        if (this.usesLocalTransactionMode() && this.transaction == null) {
            return;
        }
        TContractVerifier.precondition(this.usesLocalTransactionMode() && !this.transaction.isReleased(), "Local transaction can only be released within active local transaction mode!");
        int n = 0;
        boolean bl = true;
        while (bl) {
            Object var7_7;
            try {
                try {
                    ++n;
                    TCommandStatement tCommandStatement = this.createCommandStatement();
                    tCommandStatement.addCommand(TCommand.DISCONNECT, new TCommandValue("*"));
                    this.genericAccessor.execute(tCommandStatement);
                    bl = false;
                }
                catch (TAccessorException tAccessorException) {
                    if (tAccessorException.hasAccessFailureMessage()) {
                        TAccessFailureMessage tAccessFailureMessage = tAccessorException.getAccessFailureMessage();
                        String string = tAccessFailureMessage.getReturnValue();
                        if (n >= 2 || !tAccessFailureMessage.matchesReturnValue("9490", "9499")) {
                            bl = false;
                            throw new TTransactionModeChangeException(tAccessorException.getAccessFailureMessage().toString(), tAccessorException);
                        }
                    } else {
                        bl = false;
                        throw new TTransactionModeChangeException("Local transaction mode could not be released properly. Falling back to autocommit mode.", tAccessorException);
                    }
                    bl = true;
                    var7_7 = null;
                    if (bl) continue;
                    this.sessionState.reset();
                    this.transaction.release();
                    continue;
                }
                var7_7 = null;
                if (bl) continue;
                this.sessionState.reset();
                this.transaction.release();
            }
            catch (Throwable throwable) {
                var7_7 = null;
                if (!bl) {
                    this.sessionState.reset();
                    this.transaction.release();
                }
                throw throwable;
            }
        }
    }

    private synchronized void releaseGlobalTransactionMode() throws TTransactionModeChangeException {
    }

    private void initialize(TGenericAccessor tGenericAccessor) {
        this.genericAccessor = tGenericAccessor;
        this.sessionState = new TSessionState();
        this.isolationMode = new TIsolationMode();
        this.transactionModeMap = new HashMap();
        this.transactionModeMap.put(AUTOCOMMIT_TRANSACTION_MODE, new TAutoCommitTransactionMode(this.isolationMode, this.sessionState));
        this.transactionModeMap.put(LOCAL_TRANSACTION_MODE, new TLocalTransactionMode(this.isolationMode, this.sessionState));
        this.transactionModeMap.put(GLOBAL_TRANSACTION_MODE, new TGlobalTransactionMode(this.isolationMode, this.sessionState));
        this.transactionMode = (TTransactionMode)this.transactionModeMap.get(AUTOCOMMIT_TRANSACTION_MODE);
    }

    private TCommandStatement createCommandStatement() {
        return new TCommandStatement();
    }
}

