/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.common.TTrace;
import com.softwareag.tamino.db.api.connection.TIsolationMode;
import com.softwareag.tamino.db.api.connection.TSessionState;
import com.softwareag.tamino.db.api.connection.TTransactionModeUpdateException;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class TTransactionMode {
    private TIsolationMode isolationMode = null;
    private TSessionState sessionState = null;

    public TTransactionMode(TIsolationMode tIsolationMode, TSessionState tSessionState) {
        this.isolationMode = tIsolationMode;
        this.sessionState = tSessionState;
    }

    public void update(TInputStream tInputStream) throws TTransactionModeUpdateException {
        boolean bl = false;
        try {
            bl = this.doUpdate(tInputStream.getHeader());
        }
        catch (Exception exception) {
            TTrace.trace(exception, "Transaction mode cannot be updated. Parsing of Tamino response document caused problems.");
            throw new TTransactionModeUpdateException("Transaction mode cannot be updated. Parsing of Tamino response document caused problems." + this.toString(), exception);
        }
        if (!bl) {
            throw new TTransactionModeUpdateException("Transaction mode cannot be updated. No appropiate transaction state obtained from Tamino!" + this.toString());
        }
    }

    protected abstract boolean doUpdate(TStreamHeader var1);

    protected abstract boolean doUpdate(Document var1);

    public abstract void writeTo(TCommandStatement var1);

    public abstract void writeTo(URLConnection var1);

    public abstract boolean supports(TCommand var1);

    public TIsolationMode getIsolationMode() {
        return this.isolationMode;
    }

    public TSessionState getSessionState() {
        return this.sessionState;
    }

    protected Document getDocument(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return documentBuilder.parse(new InputSource(inputStream));
    }

    protected Document getDocument(Object object) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return documentBuilder.parse(new InputSource(new StringReader(object.toString())));
    }
}

