/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandParameter;
import com.softwareag.tamino.db.api.command.TCommandParameterValue;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.common.TString;
import com.softwareag.tamino.db.api.common.TTrace;
import com.softwareag.tamino.db.api.connection.TTransactionModeUpdateException;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import com.softwareag.tamino.db.api.namespace.TInoNamespace;
import java.net.URLConnection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TSessionState {
    private String sessionId = "";
    private String sessionKey = "";

    protected TSessionState() {
    }

    protected void writeTo(TCommandStatement tCommandStatement) {
        if (this.isGiven()) {
            tCommandStatement.addCommandParameter(TCommandParameter.SESSION_ID, new TCommandParameterValue(this.getSessionId()));
            tCommandStatement.addCommandParameter(TCommandParameter.SESSION_KEY, new TCommandParameterValue(this.getSessionKey()));
        }
    }

    protected void writeTo(URLConnection uRLConnection) {
        if (this.isGiven()) {
            TTrace.trace(this, "Writing session state to URLConnection, sessionId:" + this.getSessionId() + ", sessionKey:" + this.getSessionKey());
            uRLConnection.setRequestProperty("X-INO-Sessionid", this.getSessionId());
            uRLConnection.setRequestProperty("X-INO-Sessionkey", this.getSessionKey());
        }
    }

    protected boolean update(TStreamHeader tStreamHeader) {
        boolean bl = false;
        String string = null;
        String string2 = null;
        if (tStreamHeader != null) {
            string = tStreamHeader.getValue("X-INO-Sessionid");
            string2 = tStreamHeader.getValue("X-INO-Sessionkey");
        }
        if (string != null && string2 != null) {
            if (string.equals(this.getSessionId()) && string2.equals(this.getSessionKey())) {
                return true;
            }
            TTrace.trace(this, "Updating the session state by header, sessionId=" + string + " newSessionKey=" + this.sessionKey);
            this.setSessionId(string);
            this.setSessionKey(string2);
            bl = true;
        } else if (string != null && string.equals("0") && string2 == null) {
            if (this.getSessionId().equals("") && this.getSessionKey().equals("")) {
                return true;
            }
            TTrace.trace(this, "Session has been closed.");
            this.setSessionId(null);
            this.setSessionKey(null);
            bl = true;
        }
        return bl;
    }

    protected boolean update(Document document) {
        boolean bl = false;
        String string = null;
        String string2 = null;
        Element element = document.getDocumentElement();
        string = element.getAttribute(TInoNamespace.SESSION_ID.getQualifiedName());
        string2 = element.getAttribute(TInoNamespace.SESSION_KEY.getQualifiedName());
        if (string != null && !string.equals("") && string2 != null && !string2.equals("")) {
            if (string.equals(this.getSessionId()) && string2.equals(this.getSessionKey())) {
                return true;
            }
            TTrace.trace(this, "Updating the session state by document: sessionId=" + string + " sessionKey=" + string2);
            this.setSessionId(string);
            this.setSessionKey(string2);
            bl = true;
        }
        if (!bl) {
            NodeList nodeList = element.getElementsByTagName(TInoNamespace.MESSAGE_LINE.getQualifiedName());
            int n = 0;
            while (n < nodeList.getLength() && !bl) {
                Node node = nodeList.item(n).getFirstChild();
                if (node != null && node.getNodeValue().indexOf(TCommand.DISCONNECT.toString().toUpperCase()) != -1) {
                    if (this.getSessionId().equals("") && this.getSessionKey().equals("")) {
                        return true;
                    }
                    TTrace.trace(this, "Session has been closed.");
                    this.setSessionId(null);
                    this.setSessionKey(null);
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }

    protected boolean update(String string, String string2) throws TTransactionModeUpdateException {
        string = TString.stringize(string);
        string2 = TString.stringize(string2);
        boolean bl = this.isGiven();
        if (string.equals(this.getSessionId()) && string2.equals(this.getSessionKey())) {
            TTrace.trace(this, "Session state update without a change!?");
            return true;
        }
        if (string.equals("0") && string2.equals("")) {
            TTrace.trace(this, "Session has been closed.");
            this.setSessionId(null);
            this.setSessionKey(null);
            return true;
        }
        if (bl) {
            if (string.equals(this.getSessionId()) && !string2.equals(this.getSessionKey())) {
                TTrace.trace(this, "Updating the session state by header, sessionId=" + string + " newSessionKey=" + this.sessionKey);
                this.setSessionId(string);
                this.setSessionKey(string2);
                return true;
            }
            throw new TTransactionModeUpdateException("Failure updating the session state by header, sessionId=" + string + " newSessionKey=" + this.sessionKey);
        }
        TTrace.trace(this, "Set the session state by header, sessionId=" + string + " newSessionKey=" + this.sessionKey);
        this.setSessionId(string);
        this.setSessionKey(string2);
        return true;
    }

    protected void setSessionId(String string) {
        this.sessionId = TString.stringize(string);
    }

    protected void setSessionKey(String string) {
        this.sessionKey = TString.stringize(string);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public boolean isGiven() {
        return !this.sessionId.equals("") && !this.sessionKey.equals("");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Session State");
        stringBuffer.append("\tsessionId= " + this.sessionId + " sessionKey=" + this.sessionKey);
        return stringBuffer.toString();
    }

    public void reset() {
        this.sessionId = "";
        this.sessionKey = "";
    }
}

