/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.tamino.db.api.accessor.TAccessFailureMessage;
import com.softwareag.tamino.db.api.accessor.TAccessorException;
import com.softwareag.tamino.db.api.accessor.TGenericAccessor;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TContractVerifier;
import com.softwareag.tamino.db.api.common.TTrace;
import com.softwareag.tamino.db.api.connection.TAbstractTransaction;
import com.softwareag.tamino.db.api.connection.TLocalTransaction;
import com.softwareag.tamino.db.api.connection.TTransactionException;
import com.softwareag.tamino.db.api.response.TResponse;

public class TLocalTransactionImpl
extends TAbstractTransaction
implements TLocalTransaction {
    public TLocalTransactionImpl(TGenericAccessor tGenericAccessor) {
        super(tGenericAccessor);
    }

    public synchronized void commit() throws TTransactionException {
        TContractVerifier.precondition(!this.isReleased(), "Precondition Violation. Local transaction has already been released!");
        TTrace.trace(this, "commit");
        TCommandStatement tCommandStatement = this.createCommandStatement();
        tCommandStatement.addCommand(TCommand.COMMIT, new TCommandValue("*"));
        try {
            TResponse tResponse = this.getGenericAccessor().execute(tCommandStatement);
        }
        catch (TAccessorException tAccessorException) {
            TAccessFailureMessage tAccessFailureMessage = tAccessorException.getAccessFailureMessage();
            if (tAccessFailureMessage != null) {
                throw new TTransactionException(tAccessFailureMessage.toString(), tAccessorException);
            }
            throw new TTransactionException(tAccessorException);
        }
    }

    public synchronized void rollback() throws TTransactionException {
        TContractVerifier.precondition(!this.isReleased(), "Precondition Violation. Local transaction has already been released!");
        TTrace.trace(this, "rollback");
        TCommandStatement tCommandStatement = this.createCommandStatement();
        tCommandStatement.addCommand(TCommand.ROLLBACK, new TCommandValue("*"));
        try {
            TResponse tResponse = this.getGenericAccessor().execute(tCommandStatement);
        }
        catch (TAccessorException tAccessorException) {
            TAccessFailureMessage tAccessFailureMessage = tAccessorException.getAccessFailureMessage();
            if (tAccessFailureMessage != null) {
                throw new TTransactionException(tAccessFailureMessage.toString(), tAccessorException);
            }
            throw new TTransactionException(tAccessorException);
        }
    }
}

