/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.tamino.db.api.command.TCommandParameter;
import com.softwareag.tamino.db.api.command.TCommandParameterValue;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.common.TTrace;
import com.softwareag.tamino.db.api.connection.TIsolationLevel;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;

public class TIsolationMode {
    public static final TIsolationMode DEFAULT_LOCAL_TRANSACTION_MODE = new TIsolationMode(TIsolationLevel.SHARED, TLockwaitMode.YES);
    public static final TIsolationMode DEFAULT_AUTO_COMMIT_MODE = new TIsolationMode(TIsolationLevel.UNPROTECTED, TLockwaitMode.NO);
    private TIsolationLevel isolationLevel = null;
    private TLockwaitMode lockwaitMode = null;

    protected TIsolationMode() {
        this.isolationLevel = null;
        this.lockwaitMode = null;
    }

    protected TIsolationMode(TIsolationLevel tIsolationLevel, TLockwaitMode tLockwaitMode) {
        this.isolationLevel = tIsolationLevel;
        this.lockwaitMode = tLockwaitMode;
    }

    protected void writeTo(TCommandStatement tCommandStatement) {
        if (this.isolationLevel != null) {
            TTrace.trace(this, "Writing isolation mode to CommandStatement, isolationLevel:" + this.getIsolationLevel());
            tCommandStatement.addCommandParameter(TCommandParameter.ISOLATION_LEVEL, new TCommandParameterValue(this.getIsolationLevel().toString()));
        }
        if (this.lockwaitMode != null) {
            TTrace.trace(this, "Writing isolation mode to CommandStatement, lockwaitMode:" + this.getLockwaitMode());
            tCommandStatement.addCommandParameter(TCommandParameter.LOCKWAIT_MODE, new TCommandParameterValue(this.getLockwaitMode().toString()));
        }
    }

    protected void setIsolationLevel(TIsolationLevel tIsolationLevel) {
        this.isolationLevel = tIsolationLevel;
    }

    protected void setLockwaitMode(TLockwaitMode tLockwaitMode) {
        this.lockwaitMode = tLockwaitMode;
    }

    public TIsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public TLockwaitMode getLockwaitMode() {
        return this.lockwaitMode;
    }

    public boolean isGiven() {
        return this.lockwaitMode != null && this.isolationLevel != null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Session State");
        stringBuffer.append("\tIsolationLevel=" + this.isolationLevel + " LockwaitMode=" + this.lockwaitMode);
        return stringBuffer.toString();
    }

    public void reset() {
        this.isolationLevel = null;
        this.lockwaitMode = null;
    }
}

