/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TInvalidatableAccessor;
import com.softwareag.tamino.db.api.accessor.TNonXMLObjectAccessor;
import com.softwareag.tamino.db.api.accessor.TSchemaDefinition2Accessor;
import com.softwareag.tamino.db.api.accessor.TSchemaDefinition3Accessor;
import com.softwareag.tamino.db.api.accessor.TStreamAccessor;
import com.softwareag.tamino.db.api.accessor.TSystemAccessor;
import com.softwareag.tamino.db.api.accessor.TXMLObjectAccessor;
import com.softwareag.tamino.db.api.common.TContractVerifier;
import com.softwareag.tamino.db.api.common.TException;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionCloseException;
import com.softwareag.tamino.db.api.connection.TConnectionPool;
import com.softwareag.tamino.db.api.connection.TIsolationLevel;
import com.softwareag.tamino.db.api.connection.TLocalTransaction;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;
import com.softwareag.tamino.db.api.connection.TTransactionModeChangeException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

class TConnectionWrapper
implements TConnection {
    TConnection wrappedConnection;
    private TConnectionPool pool;
    private ArrayList invalidatableAccessors = null;
    private boolean isClosed = false;

    public TConnectionWrapper(TConnection tConnection, TConnectionPool tConnectionPool) {
        this.wrappedConnection = tConnection;
        this.pool = tConnectionPool;
        this.invalidatableAccessors = new ArrayList();
    }

    public TNonXMLObjectAccessor newNonXMLObjectAccessor(TAccessLocation tAccessLocation) {
        TContractVerifier.precondition(!this.isClosed, "Pooled Connection already closed!");
        TNonXMLObjectAccessor tNonXMLObjectAccessor = this.wrappedConnection.newNonXMLObjectAccessor(tAccessLocation);
        this.invalidatableAccessors.add((TInvalidatableAccessor)((Object)tNonXMLObjectAccessor));
        return tNonXMLObjectAccessor;
    }

    public TXMLObjectAccessor newXMLObjectAccessor(TAccessLocation tAccessLocation, Object object) {
        TContractVerifier.precondition(!this.isClosed, "Pooled Connection already closed!");
        TXMLObjectAccessor tXMLObjectAccessor = this.wrappedConnection.newXMLObjectAccessor(tAccessLocation, object);
        this.invalidatableAccessors.add((TInvalidatableAccessor)((Object)tXMLObjectAccessor));
        return tXMLObjectAccessor;
    }

    public TStreamAccessor newStreamAccessor(TAccessLocation tAccessLocation) {
        TContractVerifier.precondition(!this.isClosed, "Pooled Connection already closed!");
        TStreamAccessor tStreamAccessor = this.wrappedConnection.newStreamAccessor(tAccessLocation);
        this.invalidatableAccessors.add((TInvalidatableAccessor)((Object)tStreamAccessor));
        return tStreamAccessor;
    }

    public TSchemaDefinition2Accessor newSchemaDefinition2Accessor(Object object) {
        TContractVerifier.precondition(!this.isClosed, "Pooled Connection already closed!");
        TSchemaDefinition2Accessor tSchemaDefinition2Accessor = this.wrappedConnection.newSchemaDefinition2Accessor(object);
        this.invalidatableAccessors.add((TInvalidatableAccessor)((Object)tSchemaDefinition2Accessor));
        return tSchemaDefinition2Accessor;
    }

    public TSchemaDefinition3Accessor newSchemaDefinition3Accessor(Object object) {
        TContractVerifier.precondition(!this.isClosed, "Pooled Connection already closed!");
        TSchemaDefinition3Accessor tSchemaDefinition3Accessor = this.wrappedConnection.newSchemaDefinition3Accessor(object);
        this.invalidatableAccessors.add((TInvalidatableAccessor)((Object)tSchemaDefinition3Accessor));
        return tSchemaDefinition3Accessor;
    }

    public TSystemAccessor newSystemAccessor() {
        TContractVerifier.precondition(!this.isClosed, "Pooled Connection already closed!");
        TSystemAccessor tSystemAccessor = this.wrappedConnection.newSystemAccessor();
        this.invalidatableAccessors.add((TInvalidatableAccessor)((Object)tSystemAccessor));
        return tSystemAccessor;
    }

    public void useAutoCommitMode() throws TTransactionModeChangeException {
        TContractVerifier.precondition(!this.isClosed, "Pooled Connection already closed!");
        this.wrappedConnection.useAutoCommitMode();
    }

    public boolean usesAutoCommitMode() {
        TContractVerifier.precondition(!this.isClosed, "Pooled Connection already closed!");
        return this.wrappedConnection.usesAutoCommitMode();
    }

    public TLocalTransaction useLocalTransactionMode() throws TTransactionModeChangeException {
        TContractVerifier.precondition(!this.isClosed, "Pooled Connection already closed!");
        return this.wrappedConnection.useLocalTransactionMode();
    }

    public boolean usesLocalTransactionMode() {
        TContractVerifier.precondition(!this.isClosed, "Pooled Connection already closed!");
        return this.wrappedConnection.usesLocalTransactionMode();
    }

    public void reset() throws TTransactionModeChangeException {
        TContractVerifier.precondition(!this.isClosed, "Pooled Connection already closed!");
        this.wrappedConnection.reset();
    }

    public void setIsolationLevel(TIsolationLevel tIsolationLevel) throws TTransactionModeChangeException {
        TContractVerifier.precondition(!this.isClosed, "Pooled Connection already closed!");
        this.wrappedConnection.setIsolationLevel(tIsolationLevel);
    }

    public void setLockwaitMode(TLockwaitMode tLockwaitMode) {
        TContractVerifier.precondition(!this.isClosed, "Pooled Connection already closed!");
        this.wrappedConnection.setLockwaitMode(tLockwaitMode);
    }

    public TIsolationLevel getIsolationLevel() {
        TContractVerifier.precondition(!this.isClosed, "Pooled Connection already closed!");
        return this.wrappedConnection.getIsolationLevel();
    }

    public TLockwaitMode getLockwaitMode() {
        TContractVerifier.precondition(!this.isClosed, "Pooled Connection already closed!");
        return this.wrappedConnection.getLockwaitMode();
    }

    public void close() throws TConnectionCloseException {
        this.isClosed = true;
        try {
            this.wrappedConnection.useAutoCommitMode();
            Iterator iterator = ((AbstractList)this.invalidatableAccessors).iterator();
            while (iterator.hasNext()) {
                TInvalidatableAccessor tInvalidatableAccessor = (TInvalidatableAccessor)iterator.next();
                tInvalidatableAccessor.invalidate();
            }
            this.invalidatableAccessors.clear();
        }
        catch (TException tException) {
            // empty catch block
        }
        this.pool.retainConnection(this.wrappedConnection);
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

