/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.tamino.db.api.common.TContractVerifier;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionNotAvailableException;
import com.softwareag.tamino.db.api.connection.TConnectionPool;
import com.softwareag.tamino.db.api.connection.TConnectionPoolImpl;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TConnectionPoolManager {
    private static final String MANAGED_POOLS_RESOURCE = "ManagedConnectionPools.xml";
    private static TConnectionPoolManager singleton = null;
    private HashMap pools = null;

    private TConnectionPoolManager() {
        this.initialize();
    }

    public static synchronized TConnectionPoolManager getInstance() {
        if (singleton == null) {
            singleton = new TConnectionPoolManager();
        }
        TPreference.getInstance().setUseInvalidatableAccessorsIsEnabled(true);
        return singleton;
    }

    public TConnection getConnection(String string) throws TConnectionNotAvailableException {
        TConnection tConnection = null;
        TConnectionPool tConnectionPool = (TConnectionPool)this.pools.get(string);
        if (tConnectionPool != null) {
            tConnection = tConnectionPool.getConnection();
        } else {
            TContractVerifier.precondition(false, "No pool has been found, thus no connection is available!");
        }
        return tConnection;
    }

    public synchronized void release() {
        Iterator iterator = this.pools.values().iterator();
        while (iterator.hasNext()) {
            TConnectionPool tConnectionPool = (TConnectionPool)iterator.next();
            tConnectionPool.release();
        }
        TPreference.getInstance().setUseInvalidatableAccessorsIsEnabled(false);
    }

    public Iterator getPoolNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.pools.values().iterator();
        while (iterator.hasNext()) {
            arrayList.add(((TConnectionPool)iterator.next()).getName());
        }
        return ((AbstractList)arrayList).iterator();
    }

    public boolean hasPool(String string) {
        return this.pools.containsKey(string);
    }

    public String toString() {
        Iterator iterator = this.pools.values().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            stringBuffer.append(((TConnectionPool)iterator.next()).toString());
            stringBuffer.append(System.getProperty("line.separator"));
        }
        return stringBuffer.toString();
    }

    private void initialize() {
        this.pools = new HashMap();
        this.getClass().getClassLoader();
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(MANAGED_POOLS_RESOURCE);
        TContractVerifier.precondition(inputStream != null, "ManagedConnectionPools.xml could not be located within the classpath! TConnectionPoolManager not usable!");
        this.createPools(inputStream);
    }

    private void createPools(InputStream inputStream) {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = documentBuilder.parse(inputStream);
        }
        catch (Exception exception) {
            return;
        }
        NodeList nodeList = document.getElementsByTagName("ConnectionPool");
        int n = 0;
        while (n < nodeList.getLength()) {
            TConnectionPoolImpl tConnectionPoolImpl = new TConnectionPoolImpl((Element)nodeList.item(n));
            this.pools.put(tConnectionPoolImpl.getName(), tConnectionPoolImpl);
            ++n;
        }
    }
}

