/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connection;

import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TAccessorFactory;
import com.softwareag.tamino.db.api.accessor.TGenericAccessor;
import com.softwareag.tamino.db.api.accessor.TNonXMLObjectAccessor;
import com.softwareag.tamino.db.api.accessor.TSchemaDefinition2Accessor;
import com.softwareag.tamino.db.api.accessor.TSchemaDefinition3Accessor;
import com.softwareag.tamino.db.api.accessor.TStreamAccessor;
import com.softwareag.tamino.db.api.accessor.TSystemAccessor;
import com.softwareag.tamino.db.api.accessor.TXMLObjectAccessor;
import com.softwareag.tamino.db.api.common.TContractVerifier;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.common.TTrace;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionCloseException;
import com.softwareag.tamino.db.api.connection.TIsolationLevel;
import com.softwareag.tamino.db.api.connection.TLocalTransaction;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;
import com.softwareag.tamino.db.api.connection.TTransactionModeChangeException;
import com.softwareag.tamino.db.api.connection.TTransactionModeCoordinator;
import com.softwareag.tamino.db.api.connection.TTransactionModeCoordinatorImpl;
import com.softwareag.tamino.db.api.invocation.TInvocation;
import com.softwareag.tamino.db.api.response.TResponseBuilder;
import com.softwareag.tamino.db.api.response.TResponseBuilderFactory;

public class TConnectionImpl
implements TConnection {
    private TInvocation invocation = null;
    private TTransactionModeCoordinator transactionModeCoordinator = null;
    private TResponseBuilderFactory responseBuilderFactory = null;
    private TAccessorFactory accessorFactory = null;

    protected TConnectionImpl(TInvocation tInvocation) {
        this.invocation = tInvocation;
        this.accessorFactory = TAccessorFactory.getInstance();
        this.responseBuilderFactory = TResponseBuilderFactory.getInstance();
        Object object = TPreference.getInstance().getDefaultObjectModel();
        TResponseBuilder tResponseBuilder = this.responseBuilderFactory.newResponseBuilder(object, tInvocation);
        TAccessLocation tAccessLocation = TAccessLocation.newInstance("");
        TGenericAccessor tGenericAccessor = this.accessorFactory.newGenericAccessor(tAccessLocation, tInvocation, tResponseBuilder);
        this.transactionModeCoordinator = new TTransactionModeCoordinatorImpl(tGenericAccessor);
        this.invocation.setTransactionModeCoordinator(this.transactionModeCoordinator);
    }

    public TStreamAccessor newStreamAccessor(TAccessLocation tAccessLocation) {
        TContractVerifier.precondition(!this.isClosed(), "Connection is already closed!");
        return this.accessorFactory.newStreamAccessor(tAccessLocation, this.invocation);
    }

    public TNonXMLObjectAccessor newNonXMLObjectAccessor(TAccessLocation tAccessLocation) {
        TContractVerifier.precondition(!this.isClosed(), "Connection is already closed!");
        return this.accessorFactory.newNonXMLObjectAccessor(tAccessLocation, this.invocation, this.responseBuilderFactory.newResponseBuilder(TPreference.getInstance().getDefaultObjectModel(), this.invocation));
    }

    public TXMLObjectAccessor newXMLObjectAccessor(TAccessLocation tAccessLocation, Object object) {
        TContractVerifier.precondition(!this.isClosed(), "Connection is already closed!");
        TStreamAccessor tStreamAccessor = this.newStreamAccessor(tAccessLocation);
        return this.accessorFactory.newXMLObjectAccessor(tStreamAccessor, this.responseBuilderFactory.newResponseBuilder(object, this.invocation));
    }

    public TSchemaDefinition2Accessor newSchemaDefinition2Accessor(Object object) {
        TContractVerifier.precondition(!this.isClosed(), "Connection is already closed!");
        TStreamAccessor tStreamAccessor = this.newStreamAccessor(TAccessLocation.newInstance("ino:collection"));
        return this.accessorFactory.newSchemaDefinition2Accessor(tStreamAccessor, this.responseBuilderFactory.newResponseBuilder(object, this.invocation));
    }

    public TSchemaDefinition3Accessor newSchemaDefinition3Accessor(Object object) {
        TContractVerifier.precondition(!this.isClosed(), "Connection is already closed!");
        TStreamAccessor tStreamAccessor = this.newStreamAccessor(TAccessLocation.newInstance("ino:collection"));
        return this.accessorFactory.newSchemaDefinition3Accessor(tStreamAccessor, this.responseBuilderFactory.newResponseBuilder(object, this.invocation));
    }

    public TSystemAccessor newSystemAccessor() {
        TContractVerifier.precondition(!this.isClosed(), "Connection is already closed!");
        return this.accessorFactory.newSystemAccessor(this.invocation, this.responseBuilderFactory.newResponseBuilder(TPreference.getInstance().getDefaultObjectModel(), this.invocation));
    }

    public void useAutoCommitMode() throws TTransactionModeChangeException {
        TContractVerifier.precondition(!this.isClosed(), "Connection is already closed!");
        TTrace.trace(this, "useAutoCommitMode");
        this.transactionModeCoordinator.useAutoCommitMode();
    }

    public boolean usesAutoCommitMode() {
        TContractVerifier.precondition(!this.isClosed(), "Connection is already closed!");
        return this.transactionModeCoordinator.usesAutoCommitMode();
    }

    public TLocalTransaction useLocalTransactionMode() throws TTransactionModeChangeException {
        TContractVerifier.precondition(!this.isClosed(), "Connection is already closed!");
        TTrace.trace(this, "useLocalTransactionMode");
        return this.transactionModeCoordinator.useLocalTransactionMode();
    }

    public boolean usesLocalTransactionMode() {
        TContractVerifier.precondition(!this.isClosed(), "Connection is already closed!");
        return this.transactionModeCoordinator.usesLocalTransactionMode();
    }

    public void reset() throws TTransactionModeChangeException {
        TContractVerifier.precondition(!this.isClosed(), "Connection is already closed!");
        this.transactionModeCoordinator.useAutoCommitMode();
        this.transactionModeCoordinator.resetIsolationMode();
    }

    public void setIsolationLevel(TIsolationLevel tIsolationLevel) {
        TContractVerifier.precondition(!this.isClosed(), "Connection is already closed!");
        this.transactionModeCoordinator.setIsolationLevel(tIsolationLevel);
    }

    public void setLockwaitMode(TLockwaitMode tLockwaitMode) {
        TContractVerifier.precondition(!this.isClosed(), "Connection is already closed!");
        this.transactionModeCoordinator.setLockwaitMode(tLockwaitMode);
    }

    public TIsolationLevel getIsolationLevel() {
        TContractVerifier.precondition(!this.isClosed(), "Connection is already closed!");
        return this.transactionModeCoordinator.getIsolationLevel();
    }

    public TLockwaitMode getLockwaitMode() {
        TContractVerifier.precondition(!this.isClosed(), "Connection is already closed!");
        return this.transactionModeCoordinator.getLockwaitMode();
    }

    public void close() throws TConnectionCloseException {
        TTransactionModeCoordinator tTransactionModeCoordinator = this.transactionModeCoordinator;
        synchronized (tTransactionModeCoordinator) {
            TContractVerifier.precondition(!this.isClosed(), "Connection is already closed!");
            TTrace.trace(this, "close");
            try {
                this.useAutoCommitMode();
                this.invocation.close();
            }
            catch (Exception exception) {
                throw new TConnectionCloseException("Exception during closing the connection!", exception);
            }
        }
    }

    public boolean isClosed() {
        TTransactionModeCoordinator tTransactionModeCoordinator = this.transactionModeCoordinator;
        synchronized (tTransactionModeCoordinator) {
            boolean bl = this.invocation.isClosed();
            return bl;
        }
    }
}

