/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.common;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.LogControl;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import java.io.PrintWriter;
import java.io.StringWriter;

public class TTrace {
    private static Logger logger = LoggerFactory.getLogger("TaminoAPI.Trace");

    public static final void trace(String string) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(string);
        }
    }

    public static final void trace(Object object, String string) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(object.getClass().getName(), "", string);
        }
    }

    public static final void traceStackTrace(String string) {
        if (logger.isLoggable(Level.INFO)) {
            Exception exception = new Exception("Stacktrace");
            exception.fillInStackTrace();
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            logger.info(string + ":" + System.getProperty("line.separator") + stringWriter.toString());
        }
    }

    public static final void setActiveTrace(boolean bl) {
        if (bl) {
            LogControl.switchLoggingOn();
        } else {
            LogControl.switchLoggingOff();
        }
    }

    public static final boolean hasActiveTrace() {
        return LogControl.isLoggingOn();
    }

    public static class TConverter {
        public static String toString(byte[] byArray) {
            return TConverter.toString(byArray, byArray.length);
        }

        public static String toString(byte[] byArray, int n) {
            StringBuffer stringBuffer = new StringBuffer(n);
            int n2 = 0;
            while (n2 < n) {
                if (byArray[n2] >= 32) {
                    stringBuffer.append((char)byArray[n2]);
                } else {
                    stringBuffer.append("\\x" + Integer.toHexString(0xFF & byArray[n2]));
                }
                ++n2;
            }
            return stringBuffer.toString();
        }
    }
}

