/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.command;

import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandItemPair;
import com.softwareag.tamino.db.api.command.TCommandParameter;
import com.softwareag.tamino.db.api.command.TCommandParameterValue;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TContractVerifier;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class TCommandStatement {
    private ArrayList commandItemList = new ArrayList();
    private TCommand mainCommand = null;
    private TCommandValue mainCommandValue = null;
    private boolean isGiven = false;

    public TCommandStatement() {
    }

    public TCommandStatement(TCommand tCommand, TCommandValue tCommandValue) {
        this.addCommand(tCommand, tCommandValue);
    }

    public void addCommand(TCommand tCommand, TCommandValue tCommandValue) {
        if (tCommand != null && tCommandValue != null) {
            this.isGiven = true;
            this.commandItemList.add(new TCommandItemPair(tCommand, tCommandValue));
            if (this.mainCommand == null) {
                this.mainCommand = tCommand;
                this.mainCommandValue = tCommandValue;
            }
        }
    }

    public void addCommandParameter(TCommandParameter tCommandParameter, TCommandParameterValue tCommandParameterValue) {
        TContractVerifier.precondition(this.isGiven, "No command is given. Adding a command parameter is not possible!");
        this.commandItemList.add(new TCommandItemPair(tCommandParameter, tCommandParameterValue));
    }

    public Iterator getIterator() {
        return ((AbstractList)this.commandItemList).iterator();
    }

    public TCommand getCommand() {
        return this.mainCommand;
    }

    public TCommandValue getCommandValue() {
        return this.mainCommandValue;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.commandItemList.size()) {
            if (n == 0) {
                stringBuffer.append(this.commandItemList.get(0).toString());
            } else {
                stringBuffer.append("&");
                stringBuffer.append(this.commandItemList.get(n).toString());
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    public void clear() {
        var1_1 = this.commandItemList.iterator();
        if (var1_1.hasNext()) ** GOTO lbl7
        return;
lbl-1000:
        // 1 sources

        {
            var1_1.next();
            var1_1.remove();
lbl7:
            // 2 sources

            ** while (var1_1.hasNext())
        }
lbl8:
        // 1 sources

        this.mainCommand = null;
        this.mainCommandValue = null;
        this.isGiven = false;
    }

    protected boolean isGiven() {
        return this.isGiven;
    }

    public static void main(String[] stringArray) throws Exception {
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.CONNECT, new TCommandValue("*"));
        System.out.println("CommandStatement:" + tCommandStatement.toString());
        tCommandStatement.clear();
        tCommandStatement.addCommand(TCommand.PROCESS, new TCommandValue("<xml>Hello World</xml>"));
        tCommandStatement.addCommand(TCommand.COMMIT, new TCommandValue("*"));
        tCommandStatement.addCommandParameter(TCommandParameter.SESSION_ID, new TCommandParameterValue("1"));
        tCommandStatement.addCommandParameter(TCommandParameter.SESSION_KEY, new TCommandParameterValue("11"));
        System.out.println("CommandStatement:" + tCommandStatement.toString());
    }
}

