/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.accessor;

import com.softwareag.tamino.db.api.accessor.TAbstractAccessor;
import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TAccessorException;
import com.softwareag.tamino.db.api.accessor.TSystemAccessor;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TTrace;
import com.softwareag.tamino.db.api.invocation.TInvocation;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.response.TMessageContentItem;
import com.softwareag.tamino.db.api.response.TMessageLineContentItem;
import com.softwareag.tamino.db.api.response.TResponse;
import com.softwareag.tamino.db.api.response.TResponseBuildException;
import com.softwareag.tamino.db.api.response.TResponseBuilder;
import com.softwareag.tamino.db.api.response.TResponseHandle;
import com.softwareag.tamino.db.api.response.TServerEcho;
import com.softwareag.tamino.db.api.response.TServerEchoImpl;
import com.softwareag.tamino.db.api.response.TServerTime;
import com.softwareag.tamino.db.api.response.TServerTimeImpl;

public class TSystemAccessorImpl
extends TAbstractAccessor
implements TSystemAccessor {
    private TResponseBuilder responseBuilder = null;
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$accessor$TSystemAccessorImpl;

    public TSystemAccessorImpl(TInvocation tInvocation, TResponseBuilder tResponseBuilder) {
        super(TAccessLocation.newInstance(""), tInvocation);
        this.responseBuilder = tResponseBuilder;
    }

    public boolean isServerAlive() throws TAccessorException {
        TTrace.trace(this, "isServerAlive");
        TResponseHandle tResponseHandle = (TResponseHandle)this.diagnose(TCommandValue.PING);
        TMessageContentItem tMessageContentItem = (TMessageContentItem)tResponseHandle.getInfoContent().getItem(0, TMessageContentItem.SPECIFIER);
        if (tMessageContentItem != null) {
            TMessageLineContentItem tMessageLineContentItem = tMessageContentItem.getMessageLine(0);
            return tMessageLineContentItem != null && tMessageLineContentItem.getSubject().equals("Server") && tMessageLineContentItem.getText().equals("is alive");
        }
        return false;
    }

    public TServerEcho getServerEcho() throws TAccessorException {
        TTrace.trace(this, "getServerEcho");
        TResponseHandle tResponseHandle = (TResponseHandle)this.diagnose(TCommandValue.ECHO);
        TMessageContentItem tMessageContentItem = (TMessageContentItem)tResponseHandle.getInfoContent().getItem(0, TMessageContentItem.SPECIFIER);
        if (tMessageContentItem != null) {
            return new TServerEchoImpl(tMessageContentItem);
        }
        return null;
    }

    public String getServerVersion() throws TAccessorException {
        TMessageLineContentItem tMessageLineContentItem;
        TTrace.trace(this, "getServerVersion");
        TResponseHandle tResponseHandle = (TResponseHandle)this.diagnose(TCommandValue.VERSION);
        TMessageContentItem tMessageContentItem = (TMessageContentItem)tResponseHandle.getInfoContent().getItem(0, TMessageContentItem.SPECIFIER);
        if (tMessageContentItem != null && (tMessageLineContentItem = tMessageContentItem.getMessageLine(0)) != null && tMessageLineContentItem.getSubject().equals("Version")) {
            return tMessageLineContentItem.getText();
        }
        return "";
    }

    public String getServerAPIVersion() throws TAccessorException {
        TMessageLineContentItem tMessageLineContentItem;
        TTrace.trace(this, "getServerAPIVersion");
        TResponseHandle tResponseHandle = (TResponseHandle)this.diagnose(TCommandValue.API_VERSION);
        TMessageContentItem tMessageContentItem = (TMessageContentItem)tResponseHandle.getInfoContent().getItem(0, TMessageContentItem.SPECIFIER);
        if (tMessageContentItem != null && (tMessageLineContentItem = tMessageContentItem.getMessageLine(0)) != null && tMessageLineContentItem.getSubject().equals("apiVersion")) {
            return tMessageLineContentItem.getText();
        }
        return "";
    }

    public TServerTime getServerTime() throws TAccessorException {
        TTrace.trace(this, "getServerTime");
        TResponseHandle tResponseHandle = (TResponseHandle)this.diagnose(TCommandValue.TIME);
        TMessageContentItem tMessageContentItem = (TMessageContentItem)tResponseHandle.getInfoContent().getItem(0, TMessageContentItem.SPECIFIER);
        if (tMessageContentItem != null) {
            return new TServerTimeImpl(tMessageContentItem);
        }
        return null;
    }

    public String getAPIVersion() {
        Package package_ = (class$com$softwareag$tamino$db$api$accessor$TSystemAccessorImpl == null ? (class$com$softwareag$tamino$db$api$accessor$TSystemAccessorImpl = TSystemAccessorImpl.class$("com.softwareag.tamino.db.api.accessor.TSystemAccessorImpl")) : class$com$softwareag$tamino$db$api$accessor$TSystemAccessorImpl).getPackage();
        return package_ != null ? package_.getSpecificationVersion() : null;
    }

    protected TResponse diagnose(TCommandValue tCommandValue) throws TAccessorException {
        TCommandStatement tCommandStatement = this.getCommandStatement();
        tCommandStatement.addCommand(TCommand.DIAGNOSE, tCommandValue);
        TInputStream tInputStream = null;
        try {
            tInputStream = this.getInvocation().invoke(tCommandStatement, this.getAccessCollection(), null, null, false);
        }
        catch (TInvocationException tInvocationException) {
            throw new TAccessorException("Could not invoke", tInvocationException);
        }
        TResponse tResponse = null;
        try {
            tResponse = this.responseBuilder.buildForXML(tInputStream);
        }
        catch (TResponseBuildException tResponseBuildException) {
            TTrace.trace(tResponseBuildException, "Response could not be built!");
            throw new TAccessorException("Response could not be built", tResponseBuildException);
        }
        return tResponse;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

