/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.accessor;

import com.softwareag.tamino.db.api.accessor.TAbstractAccessor;
import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TCursorException;
import com.softwareag.tamino.db.api.accessor.TDefineException;
import com.softwareag.tamino.db.api.accessor.TDeleteException;
import com.softwareag.tamino.db.api.accessor.TInsertException;
import com.softwareag.tamino.db.api.accessor.TQuery;
import com.softwareag.tamino.db.api.accessor.TQueryException;
import com.softwareag.tamino.db.api.accessor.TRetrieveException;
import com.softwareag.tamino.db.api.accessor.TStreamAccessor;
import com.softwareag.tamino.db.api.accessor.TUndefineException;
import com.softwareag.tamino.db.api.accessor.TUpdateException;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandParameter;
import com.softwareag.tamino.db.api.command.TCommandParameterValue;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TContractVerifier;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.common.TTrace;
import com.softwareag.tamino.db.api.invocation.TInvocation;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.namespace.TInoNamespace;
import com.softwareag.tamino.db.api.objectModel.TDataObject;

public class TStreamAccessorImpl
extends TAbstractAccessor
implements TStreamAccessor {
    private TPreference preference = TPreference.getInstance();

    public TStreamAccessorImpl(TAccessLocation tAccessLocation, TInvocation tInvocation) {
        super(tAccessLocation, tInvocation);
    }

    public synchronized TInputStream insert(TDataObject tDataObject) throws TInsertException {
        TContractVerifier.precondition(tDataObject != null, "");
        TContractVerifier.precondition(tDataObject.getCollection().equals("") || tDataObject.getCollection().equals(this.getAccessCollection()), "The accessor's collection " + this.getAccessCollection() + " does not match the dataObject's collection " + tDataObject.getCollection() + "!");
        TTrace.trace(this, "insert");
        String string = tDataObject.getId();
        tDataObject.setId(null);
        String string2 = tDataObject.getDocname();
        tDataObject.setDocname(null);
        String string3 = tDataObject.getDoctype();
        try {
            try {
                TInputStream tInputStream = null;
                tInputStream = string2.length() > 0 ? this.process(tDataObject, string3, string2) : this.process(tDataObject, null, null);
                tDataObject.setCollection(this.getAccessCollection());
                TInputStream tInputStream2 = tInputStream;
                Object var8_8 = null;
                tDataObject.setId(string);
                tDataObject.setDocname(string2);
                return tInputStream2;
            }
            catch (TInvocationException tInvocationException) {
                throw new TInsertException(tInvocationException);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            tDataObject.setId(string);
            tDataObject.setDocname(string2);
            throw throwable;
        }
    }

    public synchronized TInputStream update(TDataObject tDataObject) throws TUpdateException {
        TContractVerifier.precondition(tDataObject != null, "");
        TContractVerifier.precondition(tDataObject.getCollection().equals("") || tDataObject.getCollection().equals(this.getAccessCollection()), "The accessor's collection " + this.getAccessCollection() + " does not match the dataObject's collection " + tDataObject.getCollection() + "!");
        TContractVerifier.precondition(tDataObject.hasId() || tDataObject.hasDocname(), "Update not possible. TXMLObject instance does not contain an ino:id!");
        TTrace.trace(this, "update");
        String string = tDataObject.getId();
        String string2 = tDataObject.getDocname();
        tDataObject.setDocname(null);
        String string3 = tDataObject.getDoctype();
        try {
            try {
                TInputStream tInputStream = null;
                tInputStream = string.length() == 0 && string2.length() > 0 ? this.process(tDataObject, string3, string2) : this.process(tDataObject, null, null);
                tDataObject.setCollection(this.getAccessCollection());
                TInputStream tInputStream2 = tInputStream;
                Object var8_8 = null;
                tDataObject.setId(string);
                tDataObject.setDocname(string2);
                return tInputStream2;
            }
            catch (TInvocationException tInvocationException) {
                throw new TUpdateException(tInvocationException);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            tDataObject.setId(string);
            tDataObject.setDocname(string2);
            throw throwable;
        }
    }

    public synchronized TInputStream delete(TDataObject tDataObject) throws TDeleteException {
        TContractVerifier.precondition(!tDataObject.getDoctype().equals(""), "Delete not possible. TXMLObject instance does not contain doctype information.");
        TContractVerifier.precondition(tDataObject.getCollection().equals("") || tDataObject.getCollection().equals(this.getAccessCollection()), "The accessor's collection " + this.getAccessCollection() + " does not match the dataObject's collection " + tDataObject.getCollection() + "!");
        TContractVerifier.precondition(tDataObject.hasId() || tDataObject.hasDocname(), "Delete not possible. TXMLObject instance does not an ino:id.");
        TTrace.trace(this, "delete");
        TCommandStatement tCommandStatement = this.getCommandStatement();
        String string = null;
        string = tDataObject.hasId() ? tDataObject.getDoctype() + "[@" + TInoNamespace.ID + "=\"" + tDataObject.getId() + "\"]" : tDataObject.getDoctype() + "[@" + TInoNamespace.DOCNAME + "=\"" + tDataObject.getDocname() + "\"]";
        tCommandStatement.addCommand(TCommand.DELETE, new TCommandValue(string));
        try {
            return this.getInvocation().invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TDeleteException(tInvocationException);
        }
    }

    public synchronized TInputStream delete(TQuery tQuery) throws TDeleteException {
        TContractVerifier.precondition(tQuery != null && !tQuery.getExpression().equals(""), "");
        TTrace.trace(this, "delete");
        TCommandStatement tCommandStatement = this.getCommandStatement();
        tCommandStatement.addCommand(TCommand.DELETE, new TCommandValue(tQuery.getExpression()));
        try {
            return this.getInvocation().invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TDeleteException(tInvocationException);
        }
    }

    public synchronized TInputStream query(TQuery tQuery) throws TQueryException {
        TContractVerifier.precondition(tQuery != null && !tQuery.getExpression().equals(""), "");
        TTrace.trace(this, "query");
        TCommandStatement tCommandStatement = this.getCommandStatement();
        tCommandStatement.addCommand(TCommand.XQL, new TCommandValue(tQuery.getExpression()));
        try {
            return this.getInvocation().invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TQueryException(tInvocationException);
        }
    }

    public synchronized TInputStream retrieve(TDataObject tDataObject) throws TRetrieveException {
        TContractVerifier.precondition(!tDataObject.getDoctype().equals(""), "No doctype information given!");
        TContractVerifier.precondition(!tDataObject.getId().equals("") || !tDataObject.getDocname().equals(""), "Either no id or docname is given!");
        TTrace.trace(this, "query");
        TCommandStatement tCommandStatement = this.getCommandStatement();
        tCommandStatement.addCommand(TCommand.XQL, new TCommandValue("?"));
        String string = tDataObject.getDocname();
        string = !string.equals("") ? string : "@" + tDataObject.getId();
        tCommandStatement.addCommandParameter(TCommandParameter.DOCUMENT, new TCommandParameterValue(string));
        tCommandStatement.addCommandParameter(TCommandParameter.DOCTYPE, new TCommandParameterValue(tDataObject.getDoctype()));
        try {
            return this.getInvocation().invoke(null, this.getAccessCollection(), tDataObject.getDoctype(), string);
        }
        catch (TInvocationException tInvocationException) {
            throw new TRetrieveException(tInvocationException);
        }
    }

    public synchronized TInputStream define(TDataObject tDataObject) throws TDefineException {
        return this.define(tDataObject, false);
    }

    public TInputStream define(TDataObject tDataObject, boolean bl) throws TDefineException {
        TContractVerifier.precondition(tDataObject != null, "");
        TContractVerifier.precondition(tDataObject.getCollection().equals("") || tDataObject.getCollection().equals(this.getAccessCollection()), "The accessor's collection " + this.getAccessCollection() + " does not match the dataObject's collection " + tDataObject.getCollection() + "!");
        TTrace.trace(this, "define");
        String string = tDataObject.getId();
        tDataObject.setId(null);
        String string2 = tDataObject.getDocname();
        tDataObject.setDocname(null);
        TCommandStatement tCommandStatement = this.getCommandStatement();
        tCommandStatement.addCommand(TCommand.DEFINE, new TCommandValue(tDataObject));
        if (bl) {
            tCommandStatement.addCommandParameter(TCommandParameter.MODE, TCommandParameterValue.TEST);
        }
        tCommandStatement.addCommandParameter(TCommandParameter.ENCODING, new TCommandParameterValue(this.preference.getEncoding()));
        try {
            try {
                TInputStream tInputStream = this.getInvocation().invoke(tCommandStatement);
                Object var8_8 = null;
                tDataObject.setId(string);
                tDataObject.setDocname(string2);
                return tInputStream;
            }
            catch (TInvocationException tInvocationException) {
                throw new TDefineException(tInvocationException);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            tDataObject.setId(string);
            tDataObject.setDocname(string2);
            throw throwable;
        }
    }

    public synchronized TInputStream undefine(String string, String string2) throws TUndefineException {
        TContractVerifier.precondition(string != null && !string.equals(""), "No collection information given!");
        TCommandStatement tCommandStatement = this.getCommandStatement();
        String string3 = string;
        if (string2 != null && !string2.equals("")) {
            string3 = string3 + "/" + string2;
        }
        tCommandStatement.addCommand(TCommand.UNDEFINE, new TCommandValue(string3));
        try {
            return this.getInvocation().invoke(tCommandStatement);
        }
        catch (TInvocationException tInvocationException) {
            throw new TUndefineException(tInvocationException);
        }
    }

    public synchronized TInputStream openCursor(TQuery tQuery) throws TCursorException {
        TContractVerifier.precondition(this.getInvocation().supports(TCommand.CURSOR), "Open cursor is not supported here. Change to local transaction mode!");
        TContractVerifier.precondition(tQuery != null && !tQuery.getExpression().equals(""), "");
        TTrace.trace(this, "openCursor");
        TCommandStatement tCommandStatement = this.getCommandStatement();
        tCommandStatement.addCommand(TCommand.CURSOR, TCommandValue.OPEN);
        tCommandStatement.addCommand(TCommand.XQL, new TCommandValue(tQuery.getExpression()));
        try {
            return this.getInvocation().invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TCursorException(tInvocationException);
        }
    }

    public synchronized TInputStream openCursor(TQuery tQuery, int n, int n2) throws TCursorException {
        TContractVerifier.precondition(this.getInvocation().supports(TCommand.CURSOR), "Open cursor is not supported here. Change to local transaction mode!");
        TContractVerifier.precondition(tQuery != null && !tQuery.getExpression().equals(""), "XPath statement needs to be given!");
        TContractVerifier.precondition(n >= 1, "Cursor position need to be equal or greater than 1!");
        TContractVerifier.precondition(n2 > 0, "Fetch quantity needs to be greater than 0!");
        TTrace.trace(this, "openCursor");
        TCommandStatement tCommandStatement = this.getCommandStatement();
        tCommandStatement.addCommand(TCommand.CURSOR, TCommandValue.OPEN);
        tCommandStatement.addCommand(TCommand.XQL, new TCommandValue(tQuery.getExpression()));
        tCommandStatement.addCommandParameter(TCommandParameter.SCROLL, new TCommandParameterValue("yes"));
        tCommandStatement.addCommandParameter(TCommandParameter.POSITION, new TCommandParameterValue(n));
        tCommandStatement.addCommandParameter(TCommandParameter.QUANTITY, new TCommandParameterValue(n2));
        try {
            return this.getInvocation().invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TCursorException(tInvocationException);
        }
    }

    public synchronized TInputStream fetchCursor(String string, int n, int n2) throws TCursorException {
        TContractVerifier.precondition(this.getInvocation().supports(TCommand.CURSOR), "Fetch cursor is not supported here. Change to local transaction mode and open cursor first!");
        TContractVerifier.precondition(string != null, "");
        TContractVerifier.precondition(n >= 1, "Cursor position need to be equal or greater than 1!");
        TContractVerifier.precondition(n2 > 0, "Fetch quantity needs to be greater than 0!");
        TTrace.trace(this, "fetchCursor");
        TCommandStatement tCommandStatement = this.getCommandStatement();
        tCommandStatement.addCommand(TCommand.CURSOR, TCommandValue.FETCH);
        tCommandStatement.addCommandParameter(TCommandParameter.HANDLE, new TCommandParameterValue(string));
        tCommandStatement.addCommandParameter(TCommandParameter.POSITION, new TCommandParameterValue(n));
        tCommandStatement.addCommandParameter(TCommandParameter.QUANTITY, new TCommandParameterValue(n2));
        try {
            return this.getInvocation().invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TCursorException(tInvocationException);
        }
    }

    public synchronized TInputStream closeCursor(String string) throws TCursorException {
        TContractVerifier.precondition(this.getInvocation().supports(TCommand.CURSOR), "Close cursor is not supported here. Change to local transaction mode and open cursor first!");
        TContractVerifier.precondition(string != null, "");
        TTrace.trace(this, "closeCursor");
        TCommandStatement tCommandStatement = this.getCommandStatement();
        tCommandStatement.addCommand(TCommand.CURSOR, TCommandValue.CLOSE);
        tCommandStatement.addCommandParameter(TCommandParameter.HANDLE, new TCommandParameterValue(string));
        try {
            return this.getInvocation().invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TCursorException(tInvocationException);
        }
    }

    private synchronized TInputStream process(TDataObject tDataObject, String string, String string2) throws TInvocationException {
        TCommandStatement tCommandStatement = this.getCommandStatement();
        tCommandStatement.addCommand(TCommand.PROCESS, new TCommandValue(tDataObject));
        tCommandStatement.addCommandParameter(TCommandParameter.ENCODING, new TCommandParameterValue(this.preference.getEncoding()));
        if (string != null && string2 != null) {
            return this.getInvocation().invoke(tCommandStatement, this.getAccessCollection(), string, string2);
        }
        return this.getInvocation().invoke(tCommandStatement, this.getAccessCollection(), null, null);
    }
}

