/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.accessor;

import com.softwareag.tamino.db.api.accessor.TAbstractAccessor;
import com.softwareag.tamino.db.api.accessor.TAccessFailureVerifier;
import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TDeleteException;
import com.softwareag.tamino.db.api.accessor.TInsertException;
import com.softwareag.tamino.db.api.accessor.TNonXMLObjectAccessor;
import com.softwareag.tamino.db.api.accessor.TQuery;
import com.softwareag.tamino.db.api.accessor.TQueryBuilder;
import com.softwareag.tamino.db.api.accessor.TQueryException;
import com.softwareag.tamino.db.api.accessor.TRetrieveException;
import com.softwareag.tamino.db.api.accessor.TUpdateException;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandParameter;
import com.softwareag.tamino.db.api.command.TCommandParameterValue;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TContractVerifier;
import com.softwareag.tamino.db.api.common.TTrace;
import com.softwareag.tamino.db.api.invocation.TInvocation;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TStreamReadException;
import com.softwareag.tamino.db.api.objectModel.TDataObject;
import com.softwareag.tamino.db.api.objectModel.TNonXMLObject;
import com.softwareag.tamino.db.api.response.THeaderEnlister;
import com.softwareag.tamino.db.api.response.TObjectContentItem;
import com.softwareag.tamino.db.api.response.TResponse;
import com.softwareag.tamino.db.api.response.TResponseBuildException;
import com.softwareag.tamino.db.api.response.TResponseBuilder;
import com.softwareag.tamino.db.api.response.TResponseHandle;

public class TNonXMLObjectAccessorImpl
extends TAbstractAccessor
implements TNonXMLObjectAccessor {
    private TResponseBuilder responseBuilder = null;
    private TAccessFailureVerifier accessFailureVerifier = TAccessFailureVerifier.getInstance();
    private THeaderEnlister headerEnlister = THeaderEnlister.getInstance();

    public TNonXMLObjectAccessorImpl(TAccessLocation tAccessLocation, TInvocation tInvocation, TResponseBuilder tResponseBuilder) {
        super(tAccessLocation, tInvocation);
        this.responseBuilder = tResponseBuilder;
    }

    public synchronized TResponse insert(TNonXMLObject tNonXMLObject) throws TInsertException {
        TContractVerifier.precondition(tNonXMLObject != null, "");
        TContractVerifier.precondition(tNonXMLObject.getCollection().equals("") || tNonXMLObject.getCollection().equals(this.getAccessCollection()), "The accessor's collection " + this.getAccessCollection() + " does not match the xmlObject's collection " + tNonXMLObject.getCollection() + "!");
        TContractVerifier.precondition(!tNonXMLObject.getDoctype().equals(""), "TNonXMLObject does not contain doctype information!");
        TContractVerifier.precondition(!tNonXMLObject.getContentType().equals(""), "TNonXMLObject does not contain content type information!");
        TTrace.trace(this, "Insert");
        TCommandStatement tCommandStatement = this.getCommandStatement();
        tCommandStatement.addCommand(TCommand.PROCESS, new TCommandValue(tNonXMLObject));
        TResponse tResponse = null;
        try {
            TInputStream tInputStream = this.getInvocation().invoke(tCommandStatement, this.getAccessCollection(), tNonXMLObject.getDoctype(), tNonXMLObject.getDocname());
            tResponse = this.responseBuilder.buildForNonXML(tInputStream);
            TObjectContentItem tObjectContentItem = (TObjectContentItem)((TResponseHandle)tResponse).getInfoContent().getItem(0, TObjectContentItem.SPECIFIER);
            if (tObjectContentItem != null) {
                tNonXMLObject.setId(tObjectContentItem.getId());
                tNonXMLObject.setCollection(tObjectContentItem.getCollection());
                tNonXMLObject.setDoctype(tObjectContentItem.getDoctype());
                this.headerEnlister.enlistLastModified(tResponse, (TDataObject)tNonXMLObject);
            }
        }
        catch (TInvocationException tInvocationException) {
            throw new TInsertException(tInvocationException);
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TInsertException(tResponseBuildException);
        }
        this.accessFailureVerifier.verifyInsertResponse(tResponse);
        return tResponse;
    }

    public synchronized TResponse update(TNonXMLObject tNonXMLObject) throws TUpdateException {
        TContractVerifier.precondition(tNonXMLObject != null, "");
        TContractVerifier.precondition(tNonXMLObject.getCollection().equals("") || tNonXMLObject.getCollection().equals(this.getAccessCollection()), "The accessor's collection " + this.getAccessCollection() + " does not match the xmlObject's collection " + tNonXMLObject.getCollection() + "!");
        TContractVerifier.precondition(!tNonXMLObject.getDoctype().equals(""), "TNonXMLObject does not contain doctype information!");
        TContractVerifier.precondition(tNonXMLObject.hasId() || tNonXMLObject.hasDocname(), "Either id or docname has to be given on TNonXMLObject instance!");
        TContractVerifier.precondition(!tNonXMLObject.getContentType().equals(""), "TNonXMLObject does not contain content type information!");
        TTrace.trace(this, "Update");
        TCommandStatement tCommandStatement = this.getCommandStatement();
        tCommandStatement.addCommand(TCommand.PROCESS, new TCommandValue(tNonXMLObject));
        TResponse tResponse = null;
        try {
            String string = tNonXMLObject.getDocname();
            string = !string.equals("") ? string : "@" + tNonXMLObject.getId();
            TInputStream tInputStream = this.getInvocation().invoke(tCommandStatement, this.getAccessCollection(), tNonXMLObject.getDoctype(), string);
            tResponse = this.responseBuilder.buildForNonXML(tInputStream);
            TObjectContentItem tObjectContentItem = (TObjectContentItem)((TResponseHandle)tResponse).getInfoContent().getItem(0, TObjectContentItem.SPECIFIER);
            if (tObjectContentItem != null) {
                tNonXMLObject.setId(tObjectContentItem.getId());
                tNonXMLObject.setCollection(tObjectContentItem.getCollection());
                tNonXMLObject.setDoctype(tObjectContentItem.getDoctype());
                this.headerEnlister.enlistLastModified(tResponse, (TDataObject)tNonXMLObject);
            }
        }
        catch (TInvocationException tInvocationException) {
            throw new TUpdateException(tInvocationException);
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TUpdateException(tResponseBuildException);
        }
        this.accessFailureVerifier.verifyUpdateResponse(tResponse);
        return tResponse;
    }

    public synchronized TResponse delete(TNonXMLObject tNonXMLObject) throws TDeleteException {
        TContractVerifier.precondition(tNonXMLObject != null, "");
        TContractVerifier.precondition(tNonXMLObject.getCollection().equals("") || tNonXMLObject.getCollection().equals(this.getAccessCollection()), "The accessor's collection " + this.getAccessCollection() + " does not match the xmlObject's collection " + tNonXMLObject.getCollection() + "!");
        TContractVerifier.precondition(!tNonXMLObject.getDoctype().equals(""), "TNonXMLObject does not contain doctype information!");
        TContractVerifier.precondition(tNonXMLObject.hasDocname() || tNonXMLObject.hasId(), "TNonXMLObject does neither contain docname nor id information!");
        TQuery tQuery = null;
        tQuery = tNonXMLObject.hasId() ? TQueryBuilder.getInstance().buildFromId(tNonXMLObject.getDoctype(), tNonXMLObject.getId()) : TQueryBuilder.getInstance().buildFromDocname(tNonXMLObject.getDoctype(), tNonXMLObject.getDocname());
        TResponse tResponse = this.delete(tQuery);
        this.headerEnlister.enlistLastModified(tResponse, (TDataObject)tNonXMLObject);
        return tResponse;
    }

    public synchronized TResponse delete(TQuery tQuery) throws TDeleteException {
        TContractVerifier.precondition(tQuery != null, "XPath statement is not given!");
        TContractVerifier.precondition(!tQuery.getExpression().equals(""), "XPath statement is not given!");
        TTrace.trace(this, "Delete By Query");
        TCommandStatement tCommandStatement = this.getCommandStatement();
        tCommandStatement.addCommand(TCommand.DELETE, new TCommandValue(tQuery.getExpression()));
        TResponse tResponse = null;
        try {
            TInputStream tInputStream = this.getInvocation().invoke(tCommandStatement, this.getAccessCollection());
            tResponse = this.responseBuilder.buildForNonXML(tInputStream);
        }
        catch (TInvocationException tInvocationException) {
            throw new TDeleteException(tInvocationException);
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TDeleteException(tResponseBuildException);
        }
        this.accessFailureVerifier.verifyDeleteResponse(tResponse);
        return tResponse;
    }

    public synchronized TResponse query(TQuery tQuery) throws TQueryException {
        TContractVerifier.precondition(tQuery != null, "XPath statement is not given!");
        TContractVerifier.precondition(!tQuery.getExpression().equals(""), "XPath statement is not given!");
        TTrace.trace(this, "Query");
        TCommandStatement tCommandStatement = this.getCommandStatement();
        tCommandStatement.addCommand(TCommand.XQL, new TCommandValue(tQuery.getExpression()));
        TResponse tResponse = null;
        try {
            TInputStream tInputStream = this.getInvocation().invoke(tCommandStatement, this.getAccessCollection());
            tResponse = this.responseBuilder.buildForNonXML(tInputStream);
        }
        catch (TInvocationException tInvocationException) {
            throw new TQueryException(tInvocationException);
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TQueryException(tResponseBuildException);
        }
        this.accessFailureVerifier.verifyQueryResponse(tResponse);
        return tResponse;
    }

    public synchronized TNonXMLObject retrieve(TNonXMLObject tNonXMLObject) throws TRetrieveException {
        TContractVerifier.precondition(!tNonXMLObject.getDoctype().equals(""), "No doctype information given!");
        TContractVerifier.precondition(tNonXMLObject.hasId() || tNonXMLObject.hasDocname(), "Either no id or docname is given!");
        TTrace.trace(this, "retrieve");
        TCommandStatement tCommandStatement = this.getCommandStatement();
        tCommandStatement.addCommand(TCommand.XQL, new TCommandValue("?"));
        String string = tNonXMLObject.getDocname();
        string = !string.equals("") ? string : "@" + tNonXMLObject.getId();
        tCommandStatement.addCommandParameter(TCommandParameter.DOCUMENT, new TCommandParameterValue(string));
        tCommandStatement.addCommandParameter(TCommandParameter.DOCTYPE, new TCommandParameterValue(tNonXMLObject.getDoctype()));
        try {
            TInputStream tInputStream = this.getInvocation().invoke(null, this.getAccessCollection(), tNonXMLObject.getDoctype(), string);
            tNonXMLObject.readFrom(tInputStream);
            this.headerEnlister.enlistAll(tInputStream, (TDataObject)tNonXMLObject);
            return tNonXMLObject;
        }
        catch (TInvocationException tInvocationException) {
            throw new TRetrieveException(tInvocationException);
        }
        catch (TStreamReadException tStreamReadException) {
            throw new TRetrieveException(tStreamReadException);
        }
    }
}

