/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.accessor;

import com.softwareag.tamino.db.api.accessor.TAccessFailureMessage;
import com.softwareag.tamino.db.api.accessor.TDefineException;
import com.softwareag.tamino.db.api.accessor.TDeleteException;
import com.softwareag.tamino.db.api.accessor.TInsertException;
import com.softwareag.tamino.db.api.accessor.TQueryException;
import com.softwareag.tamino.db.api.accessor.TUndefineException;
import com.softwareag.tamino.db.api.accessor.TUpdateException;
import com.softwareag.tamino.db.api.response.TResponse;
import com.softwareag.tamino.db.api.response.TResponseHandle;

public class TAccessFailureVerifier {
    private static TAccessFailureVerifier singleton = null;

    public static synchronized TAccessFailureVerifier getInstance() {
        if (singleton == null) {
            singleton = new TAccessFailureVerifier();
        }
        return singleton;
    }

    public void verifyInsertResponse(TResponse tResponse) throws TInsertException {
        TAccessFailureMessage tAccessFailureMessage = this.verify(tResponse);
        if (tAccessFailureMessage != null) {
            throw new TInsertException(tAccessFailureMessage);
        }
    }

    public void verifyUpdateResponse(TResponse tResponse) throws TUpdateException {
        TAccessFailureMessage tAccessFailureMessage = this.verify(tResponse);
        if (tAccessFailureMessage != null) {
            throw new TUpdateException(tAccessFailureMessage);
        }
    }

    public void verifyDeleteResponse(TResponse tResponse) throws TDeleteException {
        TAccessFailureMessage tAccessFailureMessage = this.verify(tResponse);
        if (tAccessFailureMessage != null) {
            throw new TDeleteException(tAccessFailureMessage);
        }
    }

    public void verifyQueryResponse(TResponse tResponse) throws TQueryException {
        TAccessFailureMessage tAccessFailureMessage = this.verify(tResponse);
        if (tAccessFailureMessage != null) {
            throw new TQueryException(tAccessFailureMessage);
        }
    }

    public void verifyDefineResponse(TResponse tResponse) throws TDefineException {
        TAccessFailureMessage tAccessFailureMessage = this.verify(tResponse);
        if (tAccessFailureMessage != null) {
            throw new TDefineException(tAccessFailureMessage);
        }
    }

    public void verifyUndefineResponse(TResponse tResponse) throws TUndefineException {
        TAccessFailureMessage tAccessFailureMessage = this.verify(tResponse);
        if (tAccessFailureMessage != null) {
            throw new TUndefineException(tAccessFailureMessage);
        }
    }

    protected TAccessFailureMessage verify(TResponse tResponse) {
        TAccessFailureMessage tAccessFailureMessage = null;
        String string = tResponse.getReturnValue();
        if (!string.equals("0")) {
            tAccessFailureMessage = this.newAccessFailureMessage((TResponseHandle)tResponse);
        }
        return tAccessFailureMessage;
    }

    private TAccessFailureMessage newAccessFailureMessage(TResponseHandle tResponseHandle) {
        String string = tResponseHandle.getReturnValue();
        String string2 = tResponseHandle.getMessageCode();
        String string3 = tResponseHandle.getMessageText();
        String string4 = tResponseHandle.getMessageLine();
        return new TAccessFailureMessage(string, string2, string3, string4);
    }
}

