/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.accessor;

import com.softwareag.tamino.db.api.accessor.TAbstractAccessor;
import com.softwareag.tamino.db.api.accessor.TAccessFailureVerifier;
import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TDefineException;
import com.softwareag.tamino.db.api.accessor.TStreamAccessor;
import com.softwareag.tamino.db.api.accessor.TUndefineException;
import com.softwareag.tamino.db.api.common.TContractVerifier;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.response.TResponse;
import com.softwareag.tamino.db.api.response.TResponseBuildException;
import com.softwareag.tamino.db.api.response.TResponseBuilder;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class TAbstractSchemaDefinitionAccessor
extends TAbstractAccessor {
    private TStreamAccessor streamAccessor = null;
    private TResponseBuilder responseBuilder = null;
    private TAccessFailureVerifier accessFailureVerifier = TAccessFailureVerifier.getInstance();

    public TAbstractSchemaDefinitionAccessor(TStreamAccessor tStreamAccessor, TResponseBuilder tResponseBuilder) {
        super(tStreamAccessor.getAccessLocation(), null);
        this.streamAccessor = tStreamAccessor;
        this.responseBuilder = tResponseBuilder;
    }

    public synchronized TResponse define(TXMLObject tXMLObject) throws TDefineException {
        TResponse tResponse = null;
        String string = tXMLObject.getId();
        String string2 = tXMLObject.getDocname();
        try {
            tXMLObject.setId("");
            tXMLObject.setDocname("");
            tResponse = this.responseBuilder.buildForXML(this.streamAccessor.define(tXMLObject));
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TDefineException("Response could not be built", tResponseBuildException);
        }
        tXMLObject.setId(string);
        tXMLObject.setDocname(string2);
        this.accessFailureVerifier.verifyDefineResponse(tResponse);
        return tResponse;
    }

    public synchronized TResponse undefine(String string, String string2) throws TUndefineException {
        TResponse tResponse = null;
        try {
            tResponse = this.responseBuilder.buildForXML(this.streamAccessor.undefine(string, string2));
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TUndefineException("Response for undefine could not be built", tResponseBuildException);
        }
        this.accessFailureVerifier.verifyUndefineResponse(tResponse);
        return tResponse;
    }

    public synchronized void setAccessLocation(TAccessLocation tAccessLocation) {
        TContractVerifier.precondition(false, "Access location is fixed. Setting a new value is not possible");
    }

    protected Document getDocument(InputStream inputStream) throws Exception {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return documentBuilder.parse(new InputSource(inputStream));
    }

    protected final TStreamAccessor getStreamAccessor() {
        return this.streamAccessor;
    }

    protected final TResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }

    protected final TAccessFailureVerifier getAccessFailureVerifier() {
        return this.accessFailureVerifier;
    }
}

