/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.common.instrumentation.logging;

import com.softwareag.common.instrumentation.logging.LogParmsClassMethodMessage;
import com.softwareag.common.instrumentation.logging.LogParmsClassMethodMessageParams;
import com.softwareag.common.instrumentation.logging.LogParmsEnter;
import com.softwareag.common.instrumentation.logging.LogParmsEnterWithParams;
import com.softwareag.common.instrumentation.logging.LogParmsExit;
import com.softwareag.common.instrumentation.logging.LogParmsExitWithResult;
import com.softwareag.common.instrumentation.logging.LogParmsMessageParams;
import com.softwareag.common.instrumentation.logging.LogParmsObjArray;
import com.softwareag.common.instrumentation.logging.Logger;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class Log4jLogger
implements Logger {
    private static final String LOG_NAME = "com.softwareag.common.instrumentation.logging.Log4jLogger";
    private static Category log = Category.getInstance((String)"com.softwareag.common.instrumentation.logging.Log4jLogger");
    protected Category cat;
    protected static int useCount = 0;
    private static final String LOG_SWITCH_NAME = "com.softwareag.LoggingOn";
    public static final String RESOURCE_BUNDLE_NAME = "log4j";
    private static boolean logStatusKnown = false;
    private static boolean loggingOn = false;

    private static void setLogStatusKnown(boolean bl) {
        log.debug((Object)("Set LogStatusKnown = " + bl));
        logStatusKnown = bl;
    }

    private static boolean isLogStatusKnown() {
        return logStatusKnown;
    }

    protected static void setSwitchLogging(boolean bl) {
        log.debug((Object)("Set Switch Logging = " + bl));
        loggingOn = bl;
        Log4jLogger.setLogStatusKnown(true);
    }

    protected static boolean isLoggingOn() {
        Log4jLogger.readLogStatus();
        return loggingOn;
    }

    protected Log4jLogger(String string) {
        this.cat = Category.getInstance((String)string);
    }

    public static Log4jLogger getLogger(String string) {
        log.debug((Object)("ENTER: com.softwareag.common.instrumentation.logging.Log4jLogger:getLogger name = " + string));
        if (useCount == 0) {
            Log4jLogger.readLogStatus();
        }
        ++useCount;
        log.debug((Object)"LEAVE: com.softwareag.common.instrumentation.logging.Log4jLogger:getLogger");
        return new Log4jLogger(string);
    }

    private static void readLogStatus() {
        log.debug((Object)"ENTER: com.softwareag.common.instrumentation.logging.Log4jLogger:readLogStatus");
        if (!Log4jLogger.isLogStatusKnown()) {
            try {
                Boolean bl = new Boolean(System.getProperty(LOG_SWITCH_NAME));
                Log4jLogger.setLogStatusKnown(true);
                Log4jLogger.setSwitchLogging(bl);
            }
            catch (SecurityException securityException) {
                Log4jLogger.setLogStatusKnown(false);
                log.warn((Object)"com.softwareag.common.instrumentation.logging.Log4jLogger:readLogStatus: SecurityException occurred by trying to get the System property com.softwareag.LoggingOn");
            }
        }
        log.debug((Object)"LEAVE: com.softwareag.common.instrumentation.logging.Log4jLogger:readLogStatus");
    }

    public boolean isLoggable(int n) {
        if (!loggingOn) {
            return false;
        }
        return this.cat.isEnabledFor(Priority.toPriority((int)n));
    }

    public void setLevel(int n) {
        this.cat.setPriority(Priority.toPriority((int)n));
    }

    public void entering(String string, String string2) {
        this.cat.debug((Object)new LogParmsEnter(string, string2));
    }

    public void entering(String string, String string2, Object[] objectArray) {
        this.cat.debug((Object)new LogParmsEnterWithParams(string, string2, objectArray));
    }

    public void exiting(String string, String string2) {
        this.cat.debug((Object)new LogParmsExit(string, string2));
    }

    public void exiting(String string, String string2, Object object) {
        this.cat.debug((Object)new LogParmsExitWithResult(string, string2, object));
    }

    public void fine(String string) {
        this.cat.debug((Object)string);
    }

    public void fine(String string, Object[] objectArray) {
        this.cat.debug((Object)(string + new LogParmsObjArray(objectArray).toString()));
    }

    public void fine(String string, String string2, String string3) {
        this.cat.debug((Object)new LogParmsClassMethodMessage(string, string2, string3));
    }

    public void fine(String string, String string2, String string3, Object[] objectArray) {
        this.cat.debug((Object)new LogParmsClassMethodMessageParams(string, string2, string3, objectArray));
    }

    public void info(String string) {
        this.cat.info((Object)string);
    }

    public void info(String string, Object[] objectArray) {
        this.cat.info((Object)new LogParmsMessageParams(string, objectArray));
    }

    public void info(String string, String string2, String string3) {
        this.cat.info((Object)new LogParmsClassMethodMessage(string, string2, string3));
    }

    public void info(String string, String string2, String string3, Object[] objectArray) {
        this.cat.info((Object)new LogParmsClassMethodMessageParams(string, string2, string3, objectArray));
    }

    public void log(int n, String string, String string2, String string3, Throwable throwable) {
        this.cat.log(Priority.toPriority((int)n), (Object)new LogParmsClassMethodMessage(string, string2, string3), throwable);
    }

    public void log(int n, String string, Throwable throwable) {
        this.cat.log(Priority.toPriority((int)n), (Object)string, throwable);
    }

    public void severe(String string) {
        this.cat.error((Object)string);
    }

    public void severe(String string, Object[] objectArray) {
        this.cat.error((Object)new LogParmsMessageParams(string, objectArray));
    }

    public void severe(String string, String string2, String string3) {
        this.cat.error((Object)new LogParmsClassMethodMessage(string, string2, string3));
    }

    public void severe(String string, String string2, String string3, Object[] objectArray) {
        this.cat.error((Object)new LogParmsClassMethodMessageParams(string, string2, string3, objectArray));
    }

    public void throwing(String string, String string2, Throwable throwable) {
        this.cat.debug((Object)new LogParmsClassMethodMessage(string, string2, "THROW"), throwable);
    }

    public void warning(String string) {
        this.cat.warn((Object)string);
    }

    public void warning(String string, Object[] objectArray) {
        this.cat.warn((Object)new LogParmsMessageParams(string, objectArray));
    }

    public void warning(String string, String string2, String string3) {
        this.cat.warn((Object)new LogParmsClassMethodMessage(string, string2, string3));
    }

    public void warning(String string, String string2, String string3, Object[] objectArray) {
        this.cat.warn((Object)new LogParmsClassMethodMessageParams(string, string2, string3, objectArray));
    }
}

