/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Layout;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

public class PatternLayout
extends Layout {
    public static final String CONVERSION_PATTERN_OPTION = "ConversionPattern";
    public static final String DEFAULT_CONVERSION_PATTERN = "%m\n";
    public static final String TTCC_CONVERSION_PATTERN = "%r [%t] %p %c %x - %m%n";
    protected final int BUF_SIZE;
    protected final int MAX_CAPACITY;
    private StringBuffer sbuf = new StringBuffer(256);
    private PatternConverter head;
    private String timezone;

    public void activateOptions() {
    }

    protected PatternParser createPatternParser(String string) {
        return new PatternParser(string);
    }

    public String format(LoggingEvent loggingEvent) {
        if (this.sbuf.capacity() > 1024) {
            this.sbuf = new StringBuffer(256);
        } else {
            this.sbuf.setLength(0);
        }
        PatternConverter patternConverter = this.head;
        while (patternConverter != null) {
            patternConverter.format(this.sbuf, loggingEvent);
            patternConverter = patternConverter.next;
        }
        return this.sbuf.toString();
    }

    public String[] getOptionStrings() {
        return new String[]{CONVERSION_PATTERN_OPTION};
    }

    public boolean ignoresThrowable() {
        return true;
    }

    public void setConversionPattern(String string) {
        this.setOption(CONVERSION_PATTERN_OPTION, string);
    }

    public void setOption(String string, String string2) {
        if (string2 == null) {
            return;
        }
        if (string.equalsIgnoreCase(CONVERSION_PATTERN_OPTION)) {
            this.head = this.createPatternParser(string2).parse();
        }
    }

    public PatternLayout() {
        this(DEFAULT_CONVERSION_PATTERN);
    }

    public PatternLayout(String string) {
        this.BUF_SIZE = 256;
        this.MAX_CAPACITY = 1024;
        this.head = this.createPatternParser(string == null ? DEFAULT_CONVERSION_PATTERN : string).parse();
    }
}

