package com.vrs.dataservices.common;

import java.util.Hashtable;

import com.softwareag.entirex.aci.Broker;
import com.softwareag.entirex.aci.BrokerException;
import com.softwareag.entirex.xml.rt.XMLRPCService;

import com.vrs.dataservices.exceptions.DataServiceException;


/**
 * This class provide a pool for parsed EntireX Broker IDL/XML mapping (XMM) files.<br/>
 * <i>This class is a singleton</i>.
 * <br/><br/>
 * <style type="text/css">
 *  table { border:1px inset gray; }
 *  th { border:1px solid gray; padding-left:6px; padding-right:6px; }
 *  td { border:1px solid gray; padding-left:6px; padding-right:6px; }
 * </style>
 * <table>
 *  <tr>
 *   <th align="center">PWR #</th>
 *   <th align="center">Date</th>
 *   <th align="center">Name</th>
 *   <th align="center">Description</th>
 *  </tr>
 *  <tr>
 *   <td align="left">CP-04474</td>
 *   <td align="left">03/02/2005</td>
 *   <td align="left">Dyke</td>
 *   <td align="left">Initial creation</td>
 *  </tr>
 * </table>
 */

/*
 * $Header: com/vrs/dataservices/common/XMLRPCServicePool.java 1.4 2005/09/19 15:20:25EDT Brent Purcell Exp  $
 *
 * $Log: com/vrs/dataservices/common/XMLRPCServicePool.java  $
 * Revision 1.4 2005/09/19 15:20:25EDT Brent Purcell 
 * Fixed javadoc comments
 * Revision 1.3 2005/09/19 14:51:31EDT Brent Purcell 
 * Fixed javadoc comments
 * Revision 1.2 2005/08/26 16:07:15EDT Brent Purcell 
 * Added mks headers
 *
 */

public class XMLRPCServicePool {

    private static XMLRPCServicePool thisPool = new XMLRPCServicePool();
    private static Hashtable pool = new Hashtable();
    private static Hashtable brokerPool = new Hashtable();

    /**
     * Private, parameterless constructor
     */
    private XMLRPCServicePool() {
    }

    /**
     * Method for retrieving a reference to the single occurence of this object
     * @return
     */
    public static XMLRPCServicePool getInstance() {
        return thisPool;
    }

    /**
     * Retireves an XMLRPCService either from the pool or by creating a new one.<br/>
     * If a new one if created, it is added to the pool.
     * @param brokerId the Broker Id of the broker for which the service is desired
     * @param brokerService the Broker Service id of the broker for which the service is desired
     * @param brokerUserId the User id to be used when a new service is created
     * @param brokerPassword the Password to be used when a new serivce is created
     * @param xmmFile the name of the services XMM file
     * @param naturalLibrary the name of the Natural library to be used when a new service is created
     * @return an XMLRPCService
     * @throws DataServiceException
     */
    public synchronized XMLRPCService aquireService(String brokerId, String brokerService,
            String brokerUserId, String brokerPassword, String xmmFile, String naturalLibrary)
            throws DataServiceException {
        /*
         * Check the pool to see if the service is already there. If it is, return it.
         */
        if (pool.containsKey(xmmFile)) {
            return (XMLRPCService) pool.get(xmmFile);
        }
        /*
         * Check to see if a Broker object exists for the specifed Broker Id. 
         * If it does, use it, if not, create one and put it into a pool
         */
        Broker broker = null;
        if (brokerPool.containsKey(brokerId)) {
            broker = (Broker) brokerPool.get(brokerId);
        } else {
            try {
                broker = new Broker(brokerId, brokerUserId);
                broker.logon();
                brokerPool.put(brokerId, broker);
            } catch (BrokerException e) {
                throw new DataServiceException("200", e);
            }
        }
        /*
         * Create a new service
         */
        try {
            XMLRPCService service = null;
            service = new XMLRPCService(broker, brokerService, xmmFile);
            if (naturalLibrary != null) {
                service.setLibraryName(naturalLibrary);
            }
            if (service == null) {
                throw new DataServiceException("200", "Can't get service");
            }
            pool.put(xmmFile, service);
            return service;
        } catch (Exception e) {
            throw new DataServiceException("200", e);
        }
    }
}
