package com.vrs.dataservices.dataaccessors;

import com.vrs.dataservices.dataobjects.ContributionData;
import com.vrs.dataservices.exceptions.DataServiceException;


/**
 * The class gets Contribution data from RIMS.
 * <br/><br/>
 * <style type="text/css">
 *  table { border:1px inset gray; }
 *  th { border:1px solid gray; padding-left:6px; padding-right:6px; }
 *  td { border:1px solid gray; padding-left:6px; padding-right:6px; }
 * </style>
 * <table>
 *  <tr>
 *   <th align="center">PWR #</th>
 *   <th align="center">Date</th>
 *   <th align="center">Name</th>
 *   <th align="center">Description</th>
 *  </tr>
 *  <tr>
 *   <td align="left">CP-04474</td>
 *   <td align="left">02/01/2005</td>
 *   <td align="left">edyke</td>
 *   <td align="left">Initial creation</td>
 *  </tr>
 * </table>
 */

/*
 * $Header: com/vrs/dataservices/dataaccessors/ContributionDA.java 1.3 2005/09/19 14:51:37EDT Brent Purcell Exp  $
 *
 * $Log: com/vrs/dataservices/dataaccessors/ContributionDA.java  $
 * Revision 1.3 2005/09/19 14:51:37EDT Brent Purcell 
 * Fixed javadoc comments
 * Revision 1.2 2005/07/11 15:42:05EDT Brent Purcell 
 * Added/Udpated standard headers...
 *
 */

public class ContributionDA extends DataAccessorNatRPC {

    private static final String BROKER_XMM_FILE_NAME = "/ivr0004j.xmm"; // must exists on classpath

    public ContributionDA() {
        super();
        this.setXmmFile(BROKER_XMM_FILE_NAME);
    }

    public ContributionData getContributionData(String SSN) throws DataServiceException {
        StringBuffer requestXML = new StringBuffer(200);
        requestXML.append("<getContributionData><request><SSN>");
        requestXML.append(SSN);
        requestXML.append("</SSN></request></getContributionData>");
        ContributionData dataBean = new ContributionData();
        getDataFromRIMS(requestXML);
        dataBean.setRIMSXMLResponse(xmlResponse);
        return dataBean;
    }
}
