package com.webmethods.caf.locallogininfo;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;

import com.webmethods.caf.faces.data.dir.PrincipalModelFactory;
import com.webmethods.caf.faces.data.dir.UserModel;
import com.webmethods.portal.bizPolicy.IContext;
import com.webmethods.portal.bizPolicy.IPrincipalData;
import com.webmethods.portal.framework.auth.AuthInfo;

public class LoginInfo {

	protected String userId;
	protected boolean isAdmin;
	protected String clientLocation;
	protected UserModel userModel;
	
	protected static Map<String, String> s_machineMap = new HashMap<String, String>();
	
	public LoginInfo(IContext context) throws Exception {
		userId = context.getUserName();
		isAdmin = context.isAdminSession();
        IPrincipalData principalData = context.getInternalPrincipalData();
        if (principalData instanceof AuthInfo) {
            AuthInfo authInfo = (AuthInfo)principalData;
            clientLocation = getClientLocation(authInfo.getRemoteAddr());
        }
        userModel = (UserModel)PrincipalModelFactory.createPrincipalModelFromID(userId);
    }
	
    public String getUserId() {
		return userId;
	}

	public boolean isAdmin() {
		return isAdmin;
	}

	public String getClientLocation() {
		return clientLocation;
	}

	public UserModel getUserModel() {
		return userModel;
	}

	protected static String getClientLocation(String remoteAddr) throws Exception {
        if (s_machineMap.containsKey(remoteAddr)) {
            return s_machineMap.get(remoteAddr);
        }

        InetAddress inetAddr = InetAddress.getByName(remoteAddr);
        String machineName = inetAddr.getHostName();
        s_machineMap.put(remoteAddr, machineName);
        return machineName;
    }
}
