/**
 * 
 */
package com.webmethods.caf.locallogininfo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import com.webmethods.caf.faces.bean.BasePageBean;
import com.webmethods.portal.bizPolicy.IContext;
import com.webmethods.portal.bizPolicy.IContextProvider;
import com.webmethods.portal.system.PortalSystem;

public class LocalLoginInfoDefaultviewView extends BasePageBean {

	private static final long serialVersionUID = 1L;
	private static final String[][] INITIALIZE_PROPERTY_BINDINGS = new String[][] {
	};
	private LocalLoginInfo localLoginInfo;
	private List<LoginInfo> localLoginList;

	/**
	 * Initialize page
	 */
	public String initialize() {
		try {
		    resolveDataBinding(INITIALIZE_PROPERTY_BINDINGS, null, "initialize", true, false);
			return OUTCOME_OK;
		} catch (Exception e) {
			error(e);
			log(e);
			return OUTCOME_ERROR; 
		}	
	}

	public LocalLoginInfo getLocalLoginInfo()  {
		if (localLoginInfo == null) {
		    localLoginInfo = (LocalLoginInfo)resolveExpression("#{LocalLoginInfo}");
		}
		return localLoginInfo;
	}
	
	public void refreshLoginInfo() {
		localLoginList.clear();
		localLoginList = null;
	}
	
	public List<LoginInfo> getLogins() throws Exception {
		if (localLoginList == null) {
			localLoginList = new ArrayList<LoginInfo>();
			IContextProvider contextProvider = (IContextProvider)PortalSystem.getContextProvider();
            List<?> contexts = contextProvider.getContexts();
			for (Iterator<?> it = contexts.iterator(); it.hasNext();) {
				IContext ctx = (IContext)it.next();
				localLoginList.add(new LoginInfo(ctx));
			}
		}
		return localLoginList;
	}
}