/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.store;

import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TAccessorException;
import com.softwareag.tamino.db.api.accessor.TQuery;
import com.softwareag.tamino.db.api.accessor.TQueryException;
import com.softwareag.tamino.db.api.accessor.TSchemaDefinition2Accessor;
import com.softwareag.tamino.db.api.accessor.TSchemaDefinition3Accessor;
import com.softwareag.tamino.db.api.accessor.TStreamAccessor;
import com.softwareag.tamino.db.api.accessor.TSystemAccessor;
import com.softwareag.tamino.db.api.accessor.TUndefineException;
import com.softwareag.tamino.db.api.accessor.TXMLObjectAccessor;
import com.softwareag.tamino.db.api.common.TException;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionFactory;
import com.softwareag.tamino.db.api.connection.TIsolationLevel;
import com.softwareag.tamino.db.api.connection.TLocalTransaction;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;
import com.softwareag.tamino.db.api.connection.TServerNotAvailableException;
import com.softwareag.tamino.db.api.connection.TTransactionException;
import com.softwareag.tamino.db.api.connection.TTransactionModeChangeException;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectIterator;
import com.softwareag.tamino.db.api.objectModel.dom.TDOMObjectModel;
import com.softwareag.tamino.db.api.objectModel.jdom.TJDOMObjectModel;
import com.softwareag.tamino.db.api.response.TResponse;
import com.softwareag.xtools.xapplication.businessdocument.Schema;
import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.common.Util;
import com.softwareag.xtools.xapplication.store.DeletedDocumentException;
import com.softwareag.xtools.xapplication.store.ElementIterator;
import com.softwareag.xtools.xapplication.store.Store;
import com.softwareag.xtools.xapplication.store.StoreException;
import com.softwareag.xtools.xapplication.store.TaminoElementIterator;
import com.softwareag.xtools.xapplication.store.Timestamp;
import com.softwareag.xtools.xapplication.store.UpdateAssertionFailed;
import com.softwareag.xtools.xapplication.store.UpdateConflictException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TaminoStore
implements Store {
    private int iteratorCount;
    public static final Namespace INO_NS = Namespace.getNamespace((String)"ino", (String)"http://namespaces.softwareag.com/tamino/response2");
    public static final Namespace XQL_NS = Namespace.getNamespace((String)"xql", (String)"http://metalab.unc.edu/xql/");
    private static final String ID = "id";
    protected TConnection connection;
    private TLocalTransaction transaction;
    protected Map collectionMap;
    private URL url;
    private boolean fakeTsd;
    private String userId;
    private String password;
    public static final String FAKE_SCHEMA_DOCTYPE = "xs:schema";
    private static final int MAX_RETRY = 5;
    private static final int DELAY_RETRY = 100;
    private static final String ANY_TEMPLATE = "<?xml version=\"1.0\"?>\n<ino:collection xmlns:ino = \"" + INO_NS.getURI() + "\" ino:name=\"{0}\" ino:key=\"ID002\"\n>" + "  <ino:doctype ino:name=\"{1}\" ino:key=\"ID_xsd:{1}schema\" ino:options=\"READ INSERT UPDATE DELETE\">\n" + "    <ino:node ino:name=\"{1}\" ino:key=\"xsd:{1}schema2\" ino:obj-type=\"ANY\" ino:parent=\"ID_xsd:{1}schema\" ino:search-type=\"no\" ino:map-type=\"Native\"/>\n" + "  </ino:doctype>\n" + "</ino:collection>\n";
    private static final String ANY_SI_TEMPLATE = "<?xml version=\"1.0\"?>\n<ino:collection xmlns:ino = \"" + INO_NS.getURI() + "\" ino:name=\"{0}\" ino:key=\"ID002\"\n>" + "  <ino:doctype ino:name=\"{1}\" ino:key=\"ID_xsd:{1}schema\" ino:structure-index=\"{2}\" ino:options=\"READ INSERT UPDATE DELETE\">\n" + "    <ino:node ino:name=\"{1}\" ino:key=\"xsd:{1}schema2\" ino:obj-type=\"ANY\" ino:parent=\"ID_xsd:{1}schema\" ino:search-type=\"no\" ino:map-type=\"Native\"/>\n" + "  </ino:doctype>\n" + "</ino:collection>\n";

    void incIteratorCount() {
        ++this.iteratorCount;
    }

    void decIteratorCount() {
        if (this.iteratorCount > 0) {
            --this.iteratorCount;
        } else {
            System.out.println("WARNING: unexpected open iterator");
        }
    }

    public int getIteratorCount() {
        return this.iteratorCount;
    }

    public TaminoStore(String urlstr, String username, String password) throws StoreException {
        if (urlstr == null) {
            throw new PreconditionViolation("url for tamino db is not defined.");
        }
        if (username == null && password != null) {
            throw new PreconditionViolation("password must not be defined without username.");
        }
        if (username != null && password == null) {
            throw new PreconditionViolation("username must not be defined without password.");
        }
        this.iteratorCount = 0;
        this.userId = username;
        this.password = password;
        try {
            this.url = new URL(urlstr);
        }
        catch (MalformedURLException e) {
            throw new StoreException("malformed url:" + urlstr, e);
        }
        this.transaction = null;
        this.collectionMap = new HashMap();
        this.connection = TaminoStore.connect(urlstr, this.userId, password);
        this.connection.setLockwaitMode(TLockwaitMode.YES);
        try {
            this.connection.setIsolationLevel(TIsolationLevel.PROTECTED);
            this.connection.useAutoCommitMode();
        }
        catch (TTransactionModeChangeException e) {
            throw new StoreException(e);
        }
        if (this.getVersion().startsWith("2.")) {
            throw new StoreException("Tamino 3.x expected. Found " + this.getVersion());
        }
        this.fakeTsd = false;
    }

    public TaminoStore(String url) throws StoreException {
        this(url, null, null);
    }

    private static TConnection connect(String urlstr, String username, String password) throws StoreException {
        int retry = 0;
        while (true) {
            try {
                TConnection connection = username != null ? TConnectionFactory.getInstance().newConnection(urlstr, username, password) : TConnectionFactory.getInstance().newConnection(urlstr);
                return connection;
            }
            catch (TServerNotAvailableException e) {
                if (retry == 5) {
                    throw new StoreException("Error connecting Tamino: server not available. ", e);
                }
                System.err.println(urlstr + ": connect failed -- retry #" + retry);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException f) {
                    // empty catch block
                }
                ++retry;
                continue;
            }
            break;
        }
    }

    public String getVersion() throws StoreException {
        String version;
        TSystemAccessor tamino = this.connection.newSystemAccessor();
        try {
            version = tamino.getServerVersion();
        }
        catch (TAccessorException e) {
            throw new StoreException("cannot determin tamino version: " + (Object)((Object)e), e);
        }
        return version;
    }

    public void registerDoctypeCollection(String doctype, String collection) {
        if (doctype == null) {
            throw new PreconditionViolation("doctype: argument has to defined");
        }
        if (collection == null) {
            throw new PreconditionViolation("collection: argument has to defined");
        }
        this.collectionMap.put(doctype, collection);
    }

    public boolean inTransaction() {
        return this.transaction != null;
    }

    public void startTransaction() throws StoreException {
        if (this.inTransaction()) {
            throw new PreconditionViolation("already within a transaction");
        }
        if (this.connection.getIsolationLevel() != TIsolationLevel.PROTECTED) {
            throw new AssertionFailed("isolation level changed");
        }
        if (this.connection.getLockwaitMode() != TLockwaitMode.YES) {
            throw new AssertionFailed("lockwait mode changed");
        }
        if (!this.connection.usesAutoCommitMode()) {
            throw new AssertionFailed("auto commit mode expected");
        }
        try {
            this.transaction = this.connection.useLocalTransactionMode();
        }
        catch (TTransactionModeChangeException e) {
            throw new StoreException(e);
        }
    }

    public void commitTransaction() throws StoreException {
        if (!this.inTransaction()) {
            throw new PreconditionViolation("not within a transaction");
        }
        if (this.connection.getIsolationLevel() != TIsolationLevel.PROTECTED) {
            throw new AssertionFailed("isolation level changed");
        }
        if (this.connection.getLockwaitMode() != TLockwaitMode.YES) {
            throw new AssertionFailed("lockwait mode changed");
        }
        if (!this.connection.usesLocalTransactionMode()) {
            throw new AssertionFailed("local transaction mode expected");
        }
        try {
            try {
                this.transaction.commit();
            }
            catch (TTransactionException e) {
                e.printStackTrace();
                try {
                    this.connection.useAutoCommitMode();
                }
                catch (TTransactionModeChangeException f) {
                    throw new AssertionFailed("cannot change to autocommit mode", (Exception)((Object)e));
                }
                throw new StoreException(e);
            }
            Object var4_1 = null;
            this.transaction = null;
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            this.transaction = null;
            throw throwable;
        }
        try {
            this.connection.useAutoCommitMode();
        }
        catch (TTransactionModeChangeException e) {
            if (!this.connection.usesAutoCommitMode()) {
                throw new AssertionFailed("fallback into autocommit mode expected", (Exception)((Object)e));
            }
            throw new StoreException(e);
        }
    }

    public void rollbackTransaction() throws StoreException {
        if (!this.inTransaction()) {
            throw new PreconditionViolation("not within a transaction");
        }
        if (this.connection.getIsolationLevel() != TIsolationLevel.PROTECTED) {
            throw new AssertionFailed("isolation level changed");
        }
        if (this.connection.getLockwaitMode() != TLockwaitMode.YES) {
            throw new AssertionFailed("lockwait mode changed");
        }
        if (!this.connection.usesLocalTransactionMode()) {
            throw new AssertionFailed("local transaction mode expected");
        }
        try {
            try {
                this.transaction.rollback();
            }
            catch (TTransactionException e) {
                try {
                    this.connection.useAutoCommitMode();
                }
                catch (TTransactionModeChangeException f) {
                    throw new StoreException("could not change to autocommit mode after rollback exception", f);
                }
                throw new StoreException(e);
            }
            Object var4_1 = null;
            this.transaction = null;
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            this.transaction = null;
            throw throwable;
        }
        try {
            this.connection.useAutoCommitMode();
        }
        catch (TTransactionModeChangeException e) {
            if (!this.connection.usesAutoCommitMode()) {
                throw new AssertionFailed("fallback into autocommit mode expected");
            }
            throw new StoreException(e);
        }
    }

    public ElementIterator query(String str) throws StoreException {
        return this.query(this.getCollectionInQuery(str), str, 10);
    }

    public ElementIterator query(String str, int pageSize) throws StoreException {
        return this.query(this.getCollectionInQuery(str), str, pageSize);
    }

    private ElementIterator query(String collection, String str, int pageSize) throws StoreException {
        if (str == null) {
            throw new PreconditionViolation("query: argument must not be null.");
        }
        if (str.length() <= 0) {
            throw new PreconditionViolation("query: argument must not be empty string.");
        }
        TConnection cursorConnection = TaminoStore.connect(this.url.toString(), this.userId, this.password);
        cursorConnection.setLockwaitMode(TLockwaitMode.YES);
        try {
            cursorConnection.setIsolationLevel(TIsolationLevel.UNPROTECTED);
            TLocalTransaction cursorTransaction = cursorConnection.useLocalTransactionMode();
        }
        catch (TTransactionModeChangeException e) {
            try {
                cursorConnection.close();
            }
            catch (TException f) {
                System.err.println("close failed: " + (Object)((Object)f));
            }
            throw new StoreException(e);
        }
        TAccessLocation location = TAccessLocation.newInstance((String)collection);
        TXMLObjectAccessor accessor = cursorConnection.newXMLObjectAccessor(location, (Object)TJDOMObjectModel.getInstance());
        try {
            TResponse response = accessor.query(TQuery.newInstance((String)str), pageSize);
            return new TaminoElementIterator(this, cursorConnection, response.getXMLObjectIterator());
        }
        catch (TException e) {
            try {
                cursorConnection.close();
            }
            catch (TException f) {
                System.err.println("close failed: " + (Object)((Object)f));
            }
            throw new StoreException("query failed: " + str + ": " + (Object)((Object)e), e);
        }
    }

    public int count(String query) throws StoreException {
        if (query == null) {
            throw new PreconditionViolation("query: argument must not be null.");
        }
        if (query.length() <= 0) {
            throw new PreconditionViolation("query: argument must not be empty string.");
        }
        String collection = this.getCollectionInQuery(query);
        TAccessLocation location = TAccessLocation.newInstance((String)collection);
        TStreamAccessor accessor = this.connection.newStreamAccessor(location);
        try {
            int sortByIndex = query.indexOf(" sortby (");
            String countQuery = "count(" + (sortByIndex >= 0 ? query.substring(0, sortByIndex) : query) + "[true()])";
            TInputStream response = accessor.query(TQuery.newInstance((String)countQuery));
            Element responseRoot = Util.inputToElement((InputStream)response);
            Element resultNode = responseRoot.getChild("result", XQL_NS);
            if (resultNode == null) {
                throw new AssertionFailed("invalid result for count query '" + countQuery + "' : " + Util.elementToString(responseRoot));
            }
            String result = resultNode.getText();
            return Integer.parseInt(result);
        }
        catch (TException e) {
            throw new StoreException("read failed: count(" + query + "): " + (Object)((Object)e), e);
        }
        catch (JDOMException e) {
            throw new StoreException("could no build JDOM represenation of the count result", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Element read(String str) throws StoreException {
        Element e2;
        TXMLObjectIterator iter;
        Element element = null;
        if (str == null) {
            throw new PreconditionViolation("query: argument must not be null.");
        }
        if (str.length() <= 0) {
            throw new PreconditionViolation("query: argument must not be empty string.");
        }
        String collection = this.getCollectionInQuery(str);
        TAccessLocation location = TAccessLocation.newInstance((String)collection);
        TXMLObjectAccessor accessor = this.connection.newXMLObjectAccessor(location, (Object)TJDOMObjectModel.getInstance());
        try {
            TResponse response = accessor.query(TQuery.newInstance((String)str));
            iter = response.getXMLObjectIterator();
        }
        catch (TException e2) {
            throw new StoreException("read failed: " + str + ": " + (Object)((Object)e2), e2);
        }
        try {
            try {
                if (!iter.hasNext()) {
                    throw new StoreException("element not found in database: " + str);
                }
                element = (Element)iter.next().getElement();
                if (iter.hasNext()) {
                    throw new StoreException("more than one element found in database: " + str);
                }
                e2 = element;
                Object var11_11 = null;
            }
            catch (TException e3) {
                throw new StoreException("read failed: " + str + ": " + (Object)((Object)e3), e3);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            try {
                iter.close();
                throw throwable;
            }
            catch (TException e2) {
                throw new StoreException("read failed: cannot close iterator", e2);
            }
        }
        try {}
        catch (TException e2) {
            throw new StoreException("read failed: cannot close iterator", e2);
        }
        iter.close();
        return e2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Element read(String str, Timestamp timestamp) throws StoreException {
        Element result;
        block7: {
            if (str == null) {
                throw new PreconditionViolation("read: argument must not be null.");
            }
            if (str.length() <= 0) {
                throw new PreconditionViolation("read: argument must not be empty string.");
            }
            if (timestamp == null) {
                throw new PreconditionViolation("read: timestamp must not be null.");
            }
            boolean transactionExists = this.inTransaction();
            if (!transactionExists) {
                this.startTransaction();
            }
            boolean commit = false;
            try {
                result = this.read(str);
                timestamp.setTime(this.getLastUpdateTime(result));
                commit = true;
                Object var7_6 = null;
                if (transactionExists) return result;
                if (!commit) break block7;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (transactionExists) throw throwable;
                if (commit) {
                    this.commitTransaction();
                    throw throwable;
                }
                this.rollbackTransaction();
                throw throwable;
            }
            this.commitTransaction();
            return result;
        }
        this.rollbackTransaction();
        return result;
    }

    public String getIdQuery(Element elem) {
        String id = this.getId(elem);
        if (id != null) {
            return "/" + elem.getName() + "[@ino:id='" + id + "']";
        }
        return null;
    }

    public String getId(Element elem) {
        Attribute attr = elem.getAttribute(ID, INO_NS);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    private String getCollectionInQuery(String query) throws StoreException {
        int endSpace;
        int endFilter;
        if (query == null) {
            throw new PreconditionViolation("query: argument must not be null.");
        }
        if (query.length() <= 0) {
            throw new PreconditionViolation("query: argument must not be empty string.");
        }
        int start = query.charAt(0) == '/' ? 1 : 0;
        int endSlash = query.indexOf(47, start + 1);
        if (endSlash == -1) {
            endSlash = query.length();
        }
        if ((endFilter = query.indexOf(91, start + 1)) == -1) {
            endFilter = query.length();
        }
        if ((endSpace = query.indexOf(32, start + 1)) == -1) {
            endSpace = query.length();
        }
        int end = Math.min(endSlash, endFilter);
        end = Math.min(end, endSpace);
        String doctype = query.substring(start, end);
        return this.getRegisteredDoctypeCollection(doctype);
    }

    public String getRegisteredDoctypeCollection(String doctype) throws StoreException {
        if (!this.collectionMap.containsKey(doctype)) {
            throw new StoreException("collection for the doctype '" + doctype + "' is not registered.");
        }
        return (String)this.collectionMap.get(doctype);
    }

    public void insert(String doctype, Element root) throws StoreException {
        TXMLObject obj = this.createXmlObject(doctype, root);
        TXMLObjectAccessor accessor = this.newAccessor(this.getRegisteredDoctypeCollection(doctype));
        try {
            TResponse response = accessor.insert(obj);
        }
        catch (TException e) {
            throw new StoreException("insert failed", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(String doctype, Element root, Timestamp timestamp) throws StoreException {
        block8: {
            if (doctype == null) {
                throw new PreconditionViolation("insert: doctype must not be null.");
            }
            if (doctype.length() <= 0) {
                throw new PreconditionViolation("insert: doctype must not be empty string.");
            }
            if (root == null) {
                throw new PreconditionViolation("insert: root element must not be null.");
            }
            if (timestamp == null) {
                throw new PreconditionViolation("insert: timestamp must not be null.");
            }
            boolean transactionExists = this.inTransaction();
            if (!transactionExists) {
                this.startTransaction();
            }
            boolean commit = false;
            try {
                this.insert(doctype, root);
                timestamp.setTime(this.getLastUpdateTime(root));
                commit = true;
                Object var7_6 = null;
                if (transactionExists) return;
                if (!commit) break block8;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (transactionExists) throw throwable;
                if (commit) {
                    this.commitTransaction();
                    throw throwable;
                }
                this.rollbackTransaction();
                throw throwable;
            }
            this.commitTransaction();
            return;
        }
        this.rollbackTransaction();
    }

    private TXMLObjectAccessor newAccessor(String collection) {
        TAccessLocation location = TAccessLocation.newInstance((String)collection);
        return this.connection.newXMLObjectAccessor(location, (Object)TJDOMObjectModel.getInstance());
    }

    protected TXMLObject update(String doctype, Element root, boolean retrieve) throws StoreException {
        if (doctype == null) {
            throw new PreconditionViolation("update: doctype must not be null.");
        }
        if (doctype.length() <= 0) {
            throw new PreconditionViolation("update: doctype must not be empty string.");
        }
        if (root == null) {
            throw new PreconditionViolation("update: root element must not be null.");
        }
        TXMLObject obj = this.createXmlObject(doctype, root);
        TXMLObjectAccessor accessor = this.newAccessor(this.getRegisteredDoctypeCollection(doctype));
        try {
            accessor.update(obj);
            if (retrieve) {
                return accessor.retrieve(obj);
            }
            return obj;
        }
        catch (TException e) {
            throw new StoreException("update failed", e);
        }
    }

    public void update(String doctype, Element root) throws StoreException {
        if (doctype == null) {
            throw new PreconditionViolation("update: doctype must not be null.");
        }
        if (doctype.length() <= 0) {
            throw new PreconditionViolation("update: doctype must not be empty string.");
        }
        if (root == null) {
            throw new PreconditionViolation("update: root element must not be null.");
        }
        this.update(doctype, root, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(String doctype, Element root, Timestamp timestamp) throws StoreException, UpdateAssertionFailed, UpdateConflictException {
        block10: {
            if (doctype == null) {
                throw new PreconditionViolation("update: doctype must not be null.");
            }
            if (doctype.length() <= 0) {
                throw new PreconditionViolation("update: doctype must not be empty string.");
            }
            if (root == null) {
                throw new PreconditionViolation("update: root element must not be null.");
            }
            if (timestamp == null) {
                throw new PreconditionViolation("update: timestamp must not be null.");
            }
            Timestamp lastModificationDate = new Timestamp();
            boolean transactionExists = this.inTransaction();
            if (!transactionExists) {
                this.startTransaction();
            }
            boolean commit = false;
            try {
                this.lockDocument(root);
                lastModificationDate.setTime(this.getLastUpdateTime(root));
                if (!lastModificationDate.equals(timestamp)) {
                    throw new UpdateConflictException("document '" + this.getIdQuery(root) + "' was modified");
                }
                TXMLObject obj = this.update(doctype, root, true);
                timestamp.setTime(obj.getLastModified());
                if (timestamp.equals(lastModificationDate)) {
                    throw new UpdateAssertionFailed("update operation lesser than 1 sec. for document '" + this.getIdQuery(root) + "'");
                }
                commit = true;
                Object var9_8 = null;
                if (transactionExists) return;
                if (!commit) break block10;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (transactionExists) throw throwable;
                if (commit) {
                    this.commitTransaction();
                    throw throwable;
                }
                this.rollbackTransaction();
                throw throwable;
            }
            this.commitTransaction();
            return;
        }
        this.rollbackTransaction();
    }

    public void delete(String doctype, Element root) throws UpdateConflictException, StoreException {
        this.delete(this.getRegisteredDoctypeCollection(doctype), doctype, root);
    }

    private void delete(String collection, String doctype, Element root) throws StoreException {
        TXMLObject obj = this.createXmlObject(collection, doctype, root);
        TXMLObjectAccessor accessor = this.newAccessor(collection);
        try {
            TResponse response = accessor.delete(obj);
        }
        catch (TException e) {
            throw new StoreException("delete failed", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(String doctype, Element root, Timestamp timestamp) throws StoreException {
        block6: {
            boolean transactionExists = this.inTransaction();
            if (!transactionExists) {
                this.startTransaction();
            }
            boolean commit = false;
            try {
                this.lockDocument(root);
                Timestamp lastModificationDate = new Timestamp();
                String lastModified = this.getLastUpdateTime(root);
                if (lastModified == null) {
                    throw new DeletedDocumentException("doucment '" + this.getIdQuery(root) + "' was deleted by another process");
                }
                lastModificationDate.setTime(lastModified);
                if (!lastModificationDate.equals(timestamp)) {
                    throw new UpdateConflictException("document '" + this.getIdQuery(root) + "' was modified");
                }
                this.delete(doctype, root);
                commit = true;
                Object var9_8 = null;
                if (transactionExists) return;
                if (!commit) break block6;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (transactionExists) throw throwable;
                if (commit) {
                    this.commitTransaction();
                    throw throwable;
                }
                this.rollbackTransaction();
                throw throwable;
            }
            this.commitTransaction();
            return;
        }
        this.rollbackTransaction();
    }

    private TXMLObject createXmlObject(String doctype, Element root) throws StoreException {
        return this.createXmlObject(this.getRegisteredDoctypeCollection(doctype), doctype, root);
    }

    private TXMLObject createXmlObject(String collection, String doctype, Element root) throws StoreException {
        TXMLObject obj = TXMLObject.newInstance((Object)root);
        obj.setCollection(collection);
        obj.setDoctype(doctype);
        return obj;
    }

    public String getLastUpdateTime(Element document) throws StoreException {
        String doctype = document.getName();
        String queryString = this.getIdQuery(document);
        try {
            TAccessLocation location = TAccessLocation.newInstance((String)this.getRegisteredDoctypeCollection(doctype));
            TXMLObjectAccessor accessor = this.connection.newXMLObjectAccessor(location, (Object)TJDOMObjectModel.getInstance());
            TResponse response = accessor.query(TQuery.newInstance((String)queryString));
            TXMLObject obj = response.getFirstXMLObject();
            if (obj == null) {
                throw new DeletedDocumentException("tried to access the last modifcation date of the deleted document '" + this.getIdQuery(document) + "'");
            }
            accessor.retrieve(obj);
            return obj.getLastModified();
        }
        catch (TException e) {
            throw new StoreException("could not request the last modified date for object '" + queryString + "'", e);
        }
    }

    public Element readTsd(String doctype) throws StoreException {
        return this.readTsd(this.getRegisteredDoctypeCollection(doctype), doctype);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Element readTsd(String collection, String doctype) throws StoreException {
        Element element;
        ElementIterator iter;
        block7: {
            Element element2;
            block6: {
                String metaCollection;
                String query;
                if (this.fakeTsd) {
                    query = "xs:schema[xs:annotation/xs:appinfo/tsd:schemaInfo/tsd:doctype/@name='" + doctype + "']";
                    metaCollection = collection;
                } else {
                    query = "xs:schema[xs:annotation/xs:appinfo/tsd:schemaInfo/tsd:doctype/@name='" + doctype + "']" + "[xs:annotation/xs:appinfo/tsd:schemaInfo/tsd:collection/@name='" + collection + "']";
                    metaCollection = "ino:collection";
                }
                iter = this.query(metaCollection, query, 2);
                try {
                    if (!iter.hasNext()) {
                        element2 = null;
                        Object var9_8 = null;
                        break block6;
                    }
                    Element schema = iter.next();
                    if (iter.hasNext()) {
                        throw new StoreException("schema ambiguous: doctype=" + doctype + " collection=" + collection);
                    }
                    element = schema;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    iter.close();
                    throw throwable;
                }
            }
            iter.close();
            return element2;
        }
        Object var9_9 = null;
        iter.close();
        return element;
    }

    public void define(String collection, Element schema, String[] doctypes, PrintStream progress) throws StoreException {
        if (this.fakeTsd) {
            this.defineFakeTsd(collection, schema, doctypes, progress);
        } else {
            this.defineTrueTsd(schema, progress);
        }
    }

    private static final Node toDom(String xml) throws IOException {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("" + e);
        }
        try {
            return builder.parse(new ByteArrayInputStream(xml.getBytes())).getFirstChild();
        }
        catch (SAXException e) {
            throw new IOException("" + e);
        }
    }

    private void defineTrueTsd(Element schema, PrintStream progress) throws StoreException {
        progress.println("defining true tsd schema.");
        TSchemaDefinition3Accessor accessor = this.connection.newSchemaDefinition3Accessor((Object)TJDOMObjectModel.getInstance());
        TXMLObject obj = TXMLObject.newInstance((Object)schema);
        try {
            TResponse response = accessor.define(obj);
        }
        catch (TException e) {
            throw new StoreException("defining new schema failed", e);
        }
    }

    private void defineFakeTsd(String collection, Element schema, String[] doctypes, PrintStream progress) throws StoreException {
        progress.println("defining fake tsd schema.");
        String structureIndex = TaminoStore.getStructureIndex(schema);
        int i = 0;
        while (i < doctypes.length) {
            if (!this.isDefinedTSD2(collection, doctypes[i])) {
                String tsd2str = TaminoStore.getAnyTSD2(structureIndex, collection, doctypes[i]);
                this.defineTSD2(tsd2str, progress);
            }
            ++i;
        }
        TXMLObjectAccessor accessor = this.newAccessor(collection);
        if (!this.isDefinedTSD2(collection, FAKE_SCHEMA_DOCTYPE)) {
            progress.println("defining meta tsd2 schema");
            String schemaSchemaStr = TaminoStore.getAnyTSD2(structureIndex, collection, FAKE_SCHEMA_DOCTYPE);
            try {
                Element schemaSchema = Util.stringToElement(schemaSchemaStr);
            }
            catch (JDOMException e) {
                throw new StoreException("any schema not well-formed:\n" + schemaSchemaStr + "\n" + e.getMessage(), e);
            }
            this.defineTSD2(schemaSchemaStr, progress);
        } else {
            i = 0;
            while (i < doctypes.length) {
                Element oldSchema = this.readTsd(collection, doctypes[i]);
                if (oldSchema != null) {
                    progress.println("removing existing schema for doctype " + doctypes[i]);
                    this.delete(collection, FAKE_SCHEMA_DOCTYPE, oldSchema);
                }
                ++i;
            }
        }
        TXMLObject obj = TXMLObject.newInstance((Object)schema);
        obj.setCollection(collection);
        obj.setDoctype(FAKE_SCHEMA_DOCTYPE);
        try {
            TResponse response = accessor.insert(obj);
        }
        catch (TException e) {
            throw new StoreException("defining new schema failed", e);
        }
    }

    private static String getStructureIndex(Element tsd) {
        Element child;
        String[] xsPath = new String[]{"annotation", "appinfo"};
        String[] tsdPath = new String[]{"schemaInfo", "doctype", "physical", "structureIndex"};
        Element element = tsd;
        int i = 0;
        while (i < xsPath.length) {
            child = element.getChild(xsPath[i], Schema.XS_NS);
            if (child == null) {
                return null;
            }
            element = child;
            ++i;
        }
        i = 0;
        while (i < tsdPath.length) {
            child = element.getChild(tsdPath[i], Schema.TSD_NS);
            if (child == null) {
                return null;
            }
            element = child;
            ++i;
        }
        if ("none".equals(element.getText())) {
            return "no";
        }
        return null;
    }

    private static final String getAnyTSD2(String structureIndex, String collection, String doctype) {
        if ("unspecified".equals(structureIndex)) {
            structureIndex = null;
        }
        if (structureIndex == null) {
            return MessageFormat.format(ANY_TEMPLATE, collection, doctype);
        }
        System.err.println("structure index attribute for doctype " + doctype + ": " + structureIndex);
        return MessageFormat.format(ANY_SI_TEMPLATE, collection, doctype, structureIndex);
    }

    private boolean isDefinedTSD2(String collection, String doctype) throws StoreException {
        boolean bl;
        String query = "ino:collection[@ino:name='" + collection + "']/" + "ino:doctype[@ino:name='" + doctype + "']";
        ElementIterator iter = this.query("ino:collection", query, 2);
        try {
            bl = iter.hasNext();
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            iter.close();
            throw throwable;
        }
        iter.close();
        return bl;
    }

    private String defineTSD2(String schema, PrintStream progress) throws StoreException {
        TSchemaDefinition2Accessor accessor = this.connection.newSchemaDefinition2Accessor((Object)TDOMObjectModel.getInstance());
        try {
            TXMLObject xmlObj = TXMLObject.newInstance((Object)TaminoStore.toDom(schema));
            accessor.define(xmlObj);
        }
        catch (TException e) {
            throw new StoreException("defineTSD2 failed:" + (Object)((Object)e), e);
        }
        catch (IOException e) {
            throw new StoreException("invalid TSD2 scheam '" + schema + "': " + e, e);
        }
        return null;
    }

    private String mhmDefineTSD2(String schema, PrintStream progress) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
        TaminoStore.requestDefineTSD2(connection, schema);
        return TaminoStore.getResponse(connection, progress);
    }

    private static void requestDefineTSD2(HttpURLConnection connection, String schema) throws IOException {
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Accept-Charset", "utf-8");
        connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        OutputStream out = connection.getOutputStream();
        int i = 0;
        while (i < schema.length()) {
            if (schema.charAt(i) >= '\u0080') {
                throw new PreconditionViolation("non-ascii-char: " + schema.charAt(i));
            }
            ++i;
        }
        out.write(("_define=" + URLEncoder.encode(schema)).getBytes());
        out.flush();
    }

    private static String getResponse(HttpURLConnection connection, PrintStream progress) throws IOException {
        Element response;
        byte[] buffer;
        String RESPONSE = "invalid tamino response: ";
        InputStream inputStream = connection.getInputStream();
        int len = inputStream.read(buffer = new byte[Integer.parseInt(connection.getHeaderField("content-length"))]);
        if (len != buffer.length) {
            throw new IllegalStateException("invalid tamino response: invalid content length: " + buffer.length + "!=" + len);
        }
        String body = new String(buffer);
        try {
            response = Util.stringToElement(body);
        }
        catch (JDOMException e) {
            throw new IOException("invalid tamino response: response is not wellformed: " + e.getMessage());
        }
        Namespace ns = response.getNamespace();
        Element message = response.getChild("message", ns);
        if (message == null) {
            throw new IOException("invalid tamino response: no 'message' element: " + body);
        }
        Attribute returnValue = message.getAttribute("returnvalue", ns);
        if (returnValue == null) {
            throw new IOException("invalid tamino response: no 'returnvalue' attribute: " + body);
        }
        Element messageLine = message.getChild("messageline", ns);
        if (messageLine == null) {
            throw new IOException("invalid tamino response: no 'messageline' element: " + body);
        }
        String msg = messageLine.getText();
        if (msg == null) {
            throw new IOException("invalid tamino response: 'messageline' is empty: " + body);
        }
        progress.println("returnvalue='" + returnValue.getValue() + "', messageline='" + msg + "'");
        if (returnValue.getValue().equals("0")) {
            return null;
        }
        return msg;
    }

    private static void printHeader(HttpURLConnection hurl) {
        HashMap header = new HashMap();
        int index = 1;
        while (((URLConnection)hurl).getHeaderFieldKey(index) != null) {
            System.out.println(((URLConnection)hurl).getHeaderFieldKey(index));
            System.out.println("\t" + ((URLConnection)hurl).getHeaderField(index));
            ++index;
        }
    }

    public void lockDocument(Element root) throws StoreException {
        if (root == null) {
            throw new PreconditionViolation("root element 'root' must not be null");
        }
        if (!this.inTransaction()) {
            throw new PreconditionViolation("lock must be invoked within transaction");
        }
        if (this.getId(root) == null) {
            throw new PreconditionViolation("ino id of the root element must be defined");
        }
        String collectionName = this.getRegisteredDoctypeCollection(root.getName());
        TStreamAccessor accessor = this.connection.newStreamAccessor(TAccessLocation.newInstance((String)collectionName));
        try {
            accessor.query(TQuery.newInstance((String)this.getIdQuery(root)));
        }
        catch (TAccessorException e) {
            throw new StoreException("could not lock document by query " + this.getIdQuery(root), e);
        }
    }

    public int deleteCollection(String collectionName) throws StoreException {
        Iterator iter;
        TSchemaDefinition3Accessor metadata = this.connection.newSchemaDefinition3Accessor((Object)TJDOMObjectModel.getInstance());
        try {
            iter = metadata.getSchemaNames(collectionName);
        }
        catch (TQueryException e) {
            throw new StoreException("cannot obtain schema names", e);
        }
        int count = 0;
        while (iter.hasNext()) {
            String schemaName = (String)iter.next();
            ++count;
            try {
                metadata.undefine(collectionName, schemaName);
            }
            catch (TUndefineException e) {
                throw new StoreException("cannot undefine schema " + schemaName, e);
            }
        }
        return count;
    }

    public List getCollectionNames() throws StoreException {
        Iterator iter;
        TSchemaDefinition3Accessor metadata = this.connection.newSchemaDefinition3Accessor((Object)TJDOMObjectModel.getInstance());
        try {
            iter = metadata.getCollectionNames();
        }
        catch (TQueryException e) {
            throw new StoreException("cannot obtain schema names", e);
        }
        ArrayList collectionNames = new ArrayList();
        while (iter.hasNext()) {
            collectionNames.add(iter.next());
        }
        return collectionNames;
    }
}

