/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.store;

import com.softwareag.tamino.db.api.common.TException;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionCloseException;
import com.softwareag.tamino.db.api.objectModel.TIteratorException;
import com.softwareag.tamino.db.api.objectModel.TNoSuchXMLObjectException;
import com.softwareag.tamino.db.api.objectModel.TXMLObjectIterator;
import com.softwareag.xtools.xapplication.store.ElementIterator;
import com.softwareag.xtools.xapplication.store.StoreException;
import com.softwareag.xtools.xapplication.store.TaminoStore;
import java.util.NoSuchElementException;
import org.jdom.Element;

class TaminoElementIterator
implements ElementIterator {
    private TConnection connection;
    private TXMLObjectIterator iter;
    private TaminoStore store;

    public TaminoElementIterator(TaminoStore store, TConnection connection, TXMLObjectIterator iter) {
        this.store = store;
        this.store.incIteratorCount();
        this.connection = connection;
        this.iter = iter;
    }

    public boolean canMoveBy(int index) throws StoreException {
        try {
            return this.iter.canMoveBy(index);
        }
        catch (TIteratorException e) {
            throw new StoreException(e);
        }
    }

    public void moveBy(int index) throws StoreException, NoSuchElementException {
        if (!this.canMoveBy(index)) {
            throw new NoSuchElementException();
        }
        try {
            this.iter.moveBy(index);
        }
        catch (TIteratorException e) {
            throw new StoreException(e);
        }
        catch (TNoSuchXMLObjectException e2) {
            throw new StoreException(e2);
        }
    }

    public void reset() throws StoreException {
        try {
            this.iter.reset();
        }
        catch (TIteratorException e) {
            throw new StoreException("reset failed", e);
        }
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public Element next() throws StoreException, NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            return (Element)this.iter.next().getElement();
        }
        catch (TException e) {
            throw new StoreException(e);
        }
    }

    public boolean hasPrevious() {
        return this.iter.hasPrevious();
    }

    public Element previous() throws StoreException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        try {
            return (Element)this.iter.previous().getElement();
        }
        catch (TIteratorException e) {
            throw new StoreException(e);
        }
        catch (TNoSuchXMLObjectException e) {
            throw new NoSuchElementException();
        }
    }

    public void close() throws StoreException {
        this.store.decIteratorCount();
        TIteratorException ie = null;
        try {
            this.iter.close();
        }
        catch (TIteratorException e) {
            ie = e;
        }
        TConnectionCloseException ce = null;
        try {
            this.connection.close();
        }
        catch (TConnectionCloseException e) {
            ce = e;
        }
        this.connection = null;
        if (ie != null) {
            throw new StoreException("close failed", ie);
        }
        if (ce != null) {
            throw new StoreException("close failed", ce);
        }
    }

    public boolean isClosed() {
        return this.connection == null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isClosed()) {
            System.err.println("WARNING: finalizing un-closed() TaminoElementIterator");
            try {
                this.close();
            }
            catch (StoreException e) {
                e.printStackTrace();
                System.err.println("close failed: " + e);
            }
        }
    }
}

