/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.store;

import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.store.ElementIterator;
import com.softwareag.xtools.xapplication.store.FileElementIterator;
import com.softwareag.xtools.xapplication.store.Store;
import com.softwareag.xtools.xapplication.store.StoreException;
import com.softwareag.xtools.xapplication.store.Timestamp;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class FileStore
implements Store {
    private File rootDir;
    private SAXBuilder builder;
    private XMLOutputter outputter;
    private static final Namespace INO_NS = Namespace.getNamespace((String)"ino", (String)"http://namespaces.softwareag.com/tamino/response2");
    private static final String ID = "id";
    public static final String BAK = ".bak";

    public FileStore(String rootDirName) {
        this.rootDir = new File(rootDirName);
        if (!this.rootDir.exists()) {
            throw new PreconditionViolation("root directory does not exist: " + rootDirName);
        }
        this.builder = new SAXBuilder();
        this.outputter = new XMLOutputter("  ", true);
    }

    public boolean inTransaction() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void startTransaction() throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void commitTransaction() throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void rollbackTransaction() throws StoreException {
        throw new UnsupportedOperationException();
    }

    public Element read(String id) throws StoreException {
        File file = this.createFile(id);
        try {
            Document doc = this.builder.build(file);
            Element tree = doc.getRootElement();
            FileStore.addFileName(tree, id);
            return tree;
        }
        catch (JDOMException e) {
            throw new StoreException("Invalid xml file: " + e.getMessage(), e);
        }
    }

    public Element read(String id, Timestamp timestamp) throws StoreException {
        File file = this.createFile(id);
        timestamp.setTime(Long.toString(file.lastModified()));
        Element result = this.read(id);
        return result;
    }

    public String getIdQuery(Element elem) {
        return FileStore.getFileName(elem);
    }

    public String getId(Element elem) {
        return FileStore.getFileName(elem);
    }

    public ElementIterator query(String substring) {
        return this.query(substring, 42);
    }

    public ElementIterator query(String substring, int pageSize) {
        ArrayList<Object> lst = new ArrayList<Object>();
        String[] all = this.rootDir.list();
        int i = 0;
        while (i < all.length) {
            if (!all[i].endsWith(BAK) && all[i].indexOf(substring) != -1) {
                try {
                    lst.add(this.read(all[i]));
                }
                catch (StoreException e) {
                    lst.add(e);
                }
            }
            ++i;
        }
        return new FileElementIterator(lst);
    }

    public int count(String query) throws StoreException {
        int n;
        ElementIterator counter = this.query(query);
        try {
            int result = 0;
            while (counter.hasNext()) {
                counter.next();
                ++result;
            }
            n = result;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            counter.close();
            throw throwable;
        }
        counter.close();
        return n;
    }

    public void insert(String doctype, Element root) throws StoreException {
        File file;
        String id = FileStore.getFileName(root);
        if (id != null) {
            throw new StoreException("insert failed: file exists");
        }
        try {
            file = File.createTempFile("filestore", ".xml", this.rootDir);
        }
        catch (IOException e) {
            throw new StoreException("insert failed: cannot create file", e);
        }
        id = file.getName();
        this.write(id, root);
        FileStore.addFileName(root, id);
    }

    public void insert(String doctype, Element root, Timestamp timestamp) throws StoreException {
        this.insert(doctype, root);
        File file = new File(FileStore.getFileName(root));
        timestamp.setTime(Long.toString(file.lastModified()));
    }

    public void update(String doctype, Element root) throws StoreException {
        String id = FileStore.getFileName(root);
        if (id == null) {
            throw new StoreException("update failed: missing file id");
        }
        File file = new File(this.rootDir, id);
        if (!file.exists()) {
            throw new StoreException("update failed: file not found: " + id);
        }
        FileStore.removeFileName(root);
        try {
            this.write(id, root);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            FileStore.addFileName(root, id);
            throw throwable;
        }
        FileStore.addFileName(root, id);
    }

    public void update(String doctype, Element root, Timestamp timestamp) throws StoreException {
        String id = FileStore.getFileName(root);
        File file = new File(this.rootDir, id);
        if (!file.exists()) {
            throw new StoreException("update failed: file not found: " + id);
        }
        Timestamp lastModifiedDate = new Timestamp();
        lastModifiedDate.setTime(Long.toString(file.lastModified()));
        if (!lastModifiedDate.equals(timestamp)) {
            throw new StoreException("update conflict: document was updated");
        }
        this.update(doctype, root);
        timestamp.setTime(Long.toString(file.lastModified()));
    }

    public void delete(String doctype, Element root) throws StoreException {
        String id = FileStore.getFileName(root);
        File file = new File(this.rootDir, id);
        if (!file.delete()) {
            throw new StoreException("delete failed");
        }
        FileStore.removeFileName(root);
    }

    public void delete(String doctype, Element root, Timestamp timestamp) throws StoreException {
        String id = FileStore.getFileName(root);
        File file = new File(this.rootDir, id);
        if (!file.exists()) {
            throw new StoreException("delete failed: file not found: " + id);
        }
        Timestamp lastModifiedDate = new Timestamp();
        lastModifiedDate.setTime(Long.toString(file.lastModified()));
        if (!lastModifiedDate.equals(timestamp)) {
            throw new StoreException("delete conflict: document was updated");
        }
        if (!file.delete()) {
            throw new StoreException("delete failed");
        }
        FileStore.removeFileName(root);
    }

    private void write(String id, Element root) throws StoreException {
        Document document = new Document(root);
        File file = this.createFile(id);
        try {
            this.backupFile(file);
            FileOutputStream out = new FileOutputStream(file);
            try {
                this.outputter.output(document, (OutputStream)out);
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                ((OutputStream)out).close();
                throw throwable;
            }
            ((OutputStream)out).close();
            {
            }
        }
        catch (IOException e) {
            throw new StoreException("cannot write file " + id, e);
        }
    }

    private static String getFileName(Element root) {
        Attribute attr = root.getAttribute(ID, INO_NS);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    private static void addFileName(Element root, String id) {
        root.addAttribute(new Attribute(ID, id, INO_NS));
    }

    private static void removeFileName(Element root) {
        if (!root.removeAttribute(ID, INO_NS)) {
            throw new AssertionFailed("no ino id found for node '" + root.getName() + "'");
        }
    }

    private File createFile(String id) {
        File file = new File(id);
        if (file.isAbsolute()) {
            throw new PreconditionViolation("relative file name expected: " + id);
        }
        return new File(this.rootDir, id);
    }

    private void backupFile(File file) throws IOException {
        if (file.exists()) {
            File orig = new File(file.getPath());
            String backupName = orig.getPath() + BAK;
            File backup = new File(backupName);
            if (backup.exists()) {
                backup.delete();
            }
            if (!orig.renameTo(backup)) {
                throw new IOException("cannot create backup file: " + backupName);
            }
        }
    }

    public int getIteratorCount() {
        throw new UnsupportedOperationException();
    }
}

