/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.store;

import com.softwareag.xtools.xapplication.store.ElementIterator;
import com.softwareag.xtools.xapplication.store.StoreException;
import java.util.List;
import java.util.NoSuchElementException;
import org.jdom.Element;

class FileElementIterator
implements ElementIterator {
    private List lst;
    private int idx;

    public FileElementIterator(List lst) {
        this.lst = lst;
    }

    public void reset() {
        this.idx = 0;
    }

    public boolean hasNext() {
        return this.idx < this.lst.size();
    }

    public int nextIndex() {
        return this.idx;
    }

    public boolean canMoveBy(int index) {
        return this.idx + index < this.lst.size() && this.idx + index >= 0;
    }

    public void moveBy(int index) throws StoreException, NoSuchElementException {
        this.gotoNextIndex(this.idx + index);
    }

    public void gotoNextIndex(int nextIdx) {
        if (nextIdx < 0 || nextIdx > this.lst.size()) {
            throw new NoSuchElementException();
        }
        this.idx = nextIdx;
    }

    public Element next() throws StoreException {
        if (this.hasNext()) {
            ++this.idx;
            return this.get(this.idx - 1);
        }
        throw new NoSuchElementException();
    }

    public boolean hasPrevious() {
        return this.idx > 0;
    }

    public int previousIndex() {
        return this.idx - 1;
    }

    public void gotoPreviousIndex(int previousIdx) {
        this.gotoNextIndex(previousIdx + 1);
    }

    public Element previous() throws StoreException {
        if (this.hasPrevious()) {
            --this.idx;
            return this.get(this.idx);
        }
        throw new NoSuchElementException();
    }

    public boolean isClosed() {
        return this.lst == null;
    }

    public void close() {
        this.lst = null;
    }

    private Element get(int myIdx) throws StoreException {
        Object obj = this.lst.get(myIdx);
        if (obj instanceof StoreException) {
            StoreException e = (StoreException)obj;
            throw new StoreException(e.getMessage(), e.getNestedException());
        }
        return (Element)obj;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isClosed()) {
            System.out.println("WARNING: finalizing un-closed() FileElementIterator");
            this.close();
        }
    }
}

