/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.jsp.util;

import com.softwareag.xtools.xapplication.common.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class HtmlOption {
    private List attributeNames;
    private List attributeValues;
    private String content;

    public HtmlOption(String value, String content) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (content == null) {
            throw new IllegalArgumentException();
        }
        this.attributeNames = new ArrayList();
        this.attributeNames.add("value");
        this.attributeValues = new ArrayList();
        this.attributeValues.add(value);
        this.content = content;
    }

    public HtmlOption(HtmlOption orig) {
        this.attributeNames = new ArrayList(orig.attributeNames);
        this.attributeValues = new ArrayList(orig.attributeValues);
        this.content = orig.content;
    }

    public HtmlOption(List attributeNames, List attributeValues, String content) {
        if (attributeNames == null) {
            throw new IllegalArgumentException();
        }
        if (attributeValues == null) {
            throw new IllegalArgumentException();
        }
        if (content == null) {
            throw new IllegalArgumentException();
        }
        this.attributeNames = attributeNames;
        this.attributeValues = attributeValues;
        this.content = content;
    }

    public void setAttribute(String name, String value) {
        int idx = this.attributeNames.indexOf(name);
        if (idx == -1) {
            this.attributeNames.add(name);
            this.attributeValues.add(value);
        } else {
            this.attributeValues.set(idx, value);
        }
    }

    public String getAttribute(String name) {
        int idx = this.attributeNames.indexOf(name);
        if (idx == -1) {
            return null;
        }
        return (String)this.attributeValues.get(idx);
    }

    public String getContent() {
        return this.content;
    }

    public void writeOut(Writer dest) throws IOException {
        dest.write("<option");
        int max = this.attributeNames.size();
        int i = 0;
        while (i < max) {
            dest.write(32);
            dest.write((String)this.attributeNames.get(i));
            dest.write(61);
            Util.writeAttributeValue((String)this.attributeValues.get(i), dest);
            ++i;
        }
        dest.write(62);
        Util.writeElementText(this.content, dest);
        dest.write("</option>");
    }
}

