/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.jsp.util;

import com.softwareag.xtools.xapplication.common.Util;
import com.softwareag.xtools.xapplication.jsp.ExceptionContainer;
import com.softwareag.xtools.xapplication.jsp.InvalidEmbeddedContentException;
import com.softwareag.xtools.xapplication.jsp.util.HtmlElement;
import com.softwareag.xtools.xapplication.jsp.util.HtmlOption;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class HtmlElementCache {
    private Map cache = new HashMap();

    public HtmlElement parse(SAXBuilder saxBuilder, String htmlString) throws ExceptionContainer, IOException {
        HtmlElement htmlElement;
        HtmlElementCache htmlElementCache = this;
        synchronized (htmlElementCache) {
            htmlElement = (HtmlElement)this.cache.get(htmlString);
        }
        if (htmlElement == null) {
            Element root = HtmlElementCache.doParse(saxBuilder, htmlString);
            htmlElement = HtmlElementCache.toHtmlElement(root);
            HtmlElementCache htmlElementCache2 = this;
            synchronized (htmlElementCache2) {
                this.cache.put(htmlString, htmlElement);
            }
        }
        return htmlElement;
    }

    private static HtmlElement toHtmlElement(Element elem) {
        String name = elem.getName().toLowerCase();
        ArrayList<String> attributeNames = new ArrayList<String>();
        ArrayList<String> attributeValues = new ArrayList<String>();
        List jdomAttributes = elem.getAttributes();
        int max = jdomAttributes.size();
        int i = 0;
        while (i < max) {
            Attribute a = (Attribute)jdomAttributes.get(i);
            attributeNames.add(a.getName().toLowerCase());
            attributeValues.add(a.getValue());
            ++i;
        }
        List content = HtmlElementCache.getContent(elem);
        return new HtmlElement(name, attributeNames, attributeValues, content);
    }

    private static List getContent(Element elem) {
        List jdomContent = elem.getMixedContent();
        int max = jdomContent.size();
        ArrayList<Object> content = new ArrayList<Object>();
        int i = 0;
        while (i < max) {
            Object obj = jdomContent.get(i);
            if (obj instanceof String) {
                content.add(obj);
            } else if (obj instanceof Element) {
                content.add(HtmlElementCache.getChildElement((Element)obj));
            } else {
                throw new InvalidEmbeddedContentException("unexpected content: " + obj.toString());
            }
            ++i;
        }
        return content;
    }

    private static Object getChildElement(Element childElem) {
        if (childElem.getName().equals("option")) {
            ArrayList<String> attributeNames = new ArrayList<String>();
            ArrayList<String> attributeValues = new ArrayList<String>();
            List jdomAttributes = childElem.getAttributes();
            int max = jdomAttributes.size();
            int i = 0;
            while (i < max) {
                Attribute a = (Attribute)jdomAttributes.get(i);
                attributeNames.add(a.getName());
                attributeValues.add(a.getValue());
                ++i;
            }
            return new HtmlOption(attributeNames, attributeValues, childElem.getText());
        }
        return Util.elementToString(childElem).toCharArray();
    }

    private static Element doParse(SAXBuilder builder, String htmlString) {
        Document doc;
        builder = new SAXBuilder();
        try {
            doc = builder.build((Reader)new StringReader(htmlString));
        }
        catch (JDOMException e) {
            System.err.println("while parsing:" + htmlString + " exception:" + e.toString());
            throw new InvalidEmbeddedContentException(e.getMessage(), htmlString);
        }
        return doc.getRootElement();
    }
}

