/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.jsp.util;

import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.Util;
import com.softwareag.xtools.xapplication.jsp.util.HtmlOption;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class HtmlElement {
    private String name;
    private List content;
    private final List attributeNames;
    private final List attributeValues;

    public HtmlElement(String name, List attributeNames, List attributeValues, List content) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (attributeNames == null) {
            throw new IllegalArgumentException();
        }
        if (attributeValues == null) {
            throw new IllegalArgumentException();
        }
        if (content == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.attributeNames = attributeNames;
        this.attributeValues = attributeValues;
        this.content = content;
    }

    public HtmlElement() {
        this.name = null;
        this.attributeNames = new ArrayList();
        this.attributeValues = new ArrayList();
        this.content = new ArrayList();
    }

    public void set(HtmlElement orig) {
        this.name = orig.name;
        this.attributeNames.clear();
        this.attributeNames.addAll(orig.attributeNames);
        this.attributeValues.clear();
        this.attributeValues.addAll(orig.attributeValues);
        this.content.clear();
        int max = orig.content.size();
        int i = 0;
        while (i < max) {
            Object obj = orig.content.get(i);
            if (obj instanceof HtmlOption) {
                this.content.add(new HtmlOption((HtmlOption)obj));
            } else {
                this.content.add(obj);
            }
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getAttribute(String name) {
        int idx = this.attributeNames.indexOf(name);
        if (idx == -1) {
            return null;
        }
        return (String)this.attributeValues.get(idx);
    }

    public void setAttribute(String name, String value) {
        int idx = this.attributeNames.indexOf(name);
        if (value == null || value.length() == 0) {
            if (idx != -1) {
                this.attributeNames.remove(idx);
                this.attributeValues.remove(idx);
            }
        } else if (idx == -1) {
            this.attributeNames.add(name);
            this.attributeValues.add(value);
        } else {
            this.attributeValues.set(idx, value);
        }
    }

    public void addContent(String text) {
        this.content.add(text);
    }

    public void addOption(String value, String text) {
        this.content.add(new HtmlOption(value, text));
    }

    public void setSelectedOption(String value) throws IllegalArgumentException {
        if (!this.getName().equals("select")) {
            throw new IllegalArgumentException("trying to set option value when field was not a SELECT tag");
        }
        int max = this.content.size();
        int i = 0;
        while (i < max) {
            Object c = this.content.get(i);
            if (c instanceof HtmlOption) {
                HtmlOption option = (HtmlOption)c;
                String s = option.getAttribute("value");
                if (s == null) {
                    s = option.getContent().trim();
                }
                if (s.equals(value)) {
                    option.setAttribute("selected", "true");
                }
            }
            ++i;
        }
    }

    public void writeOut(Writer dest) throws IOException {
        dest.write(60);
        dest.write(this.name);
        int max = this.attributeNames.size();
        int i = 0;
        while (i < max) {
            dest.write(32);
            dest.write((String)this.attributeNames.get(i));
            dest.write(61);
            Util.writeAttributeValue((String)this.attributeValues.get(i), dest);
            ++i;
        }
        max = this.content.size();
        if (max == 0) {
            dest.write("/>");
        } else {
            dest.write(62);
            i = 0;
            while (i < max) {
                Object obj = this.content.get(i);
                if (obj instanceof HtmlOption) {
                    HtmlOption option = (HtmlOption)obj;
                    option.writeOut(dest);
                } else if (obj instanceof char[]) {
                    dest.write((char[])obj);
                } else {
                    Util.writeElementText((String)obj, dest);
                }
                ++i;
            }
            dest.write("</");
            dest.write(this.name);
            dest.write(62);
        }
    }

    public String toString() {
        StringWriter dest = new StringWriter();
        try {
            this.writeOut(dest);
        }
        catch (IOException e) {
            throw new AssertionFailed("unexpected IOException for StringWriter: " + e.getMessage());
        }
        return dest.getBuffer().toString();
    }
}

