/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.jsp.util;

import com.softwareag.xtools.xapplication.jsp.util.Arguments;
import java.io.IOException;
import java.io.Writer;
import java.util.Random;

public class ArgumentsCodec {
    private final boolean enabled;
    private final Random random;
    public static final int MAX_CODES = 200;
    public static final int MAX_RANDOM = 10737418;
    private int current;
    private final int[] codes;
    private final Arguments[] args;

    public ArgumentsCodec(boolean coded) {
        this.enabled = coded;
        this.current = 0;
        this.codes = new int[200];
        this.args = new Arguments[200];
        this.random = new Random();
    }

    public String defineNormal(Arguments arguments) {
        if (this.enabled) {
            int code = this.define(arguments);
            return ":coded=" + code;
        }
        return arguments.toRequest();
    }

    public String defineJavaScript(Arguments arguments, String formName) {
        if (this.enabled) {
            int code = this.define(arguments);
            return "document.forms['" + formName + "'].elements[':coded'].value='" + code + "';";
        }
        return arguments.toJavaScript(formName);
    }

    public int define(Arguments arguments) {
        int code;
        this.codes[this.current] = code = this.createCode();
        this.args[this.current] = arguments;
        this.current = (this.current + 1) % 200;
        return code;
    }

    public Arguments decode(int code) {
        int idx = code % 200;
        if (this.codes[idx] == code) {
            return this.args[idx];
        }
        return null;
    }

    public boolean decode(Arguments arguments) {
        String codeStr;
        if (this.enabled && (codeStr = arguments.eatNoneEmptyValue(":coded")) != null) {
            int code;
            try {
                code = Integer.parseInt(codeStr);
            }
            catch (NumberFormatException e) {
                return false;
            }
            Arguments decoded = this.decode(code);
            if (decoded != null) {
                arguments.add(decoded);
            } else {
                return false;
            }
        }
        return true;
    }

    private int createCode() {
        int n = this.random.nextInt(10737418);
        n = n * 200 + this.current;
        return n;
    }

    public void writeHiddenFields(Writer dest) throws IOException {
        if (this.enabled) {
            dest.write("<input type=\"hidden\" name=\":coded\"/>");
        } else {
            dest.write("<input type=\"hidden\" name=\":action\"/>");
            dest.write("<input type=\"hidden\" name=\":linkaction\"/>");
            dest.write("<input type=\"hidden\" name=\":document\"/>");
            dest.write("<input type=\"hidden\" name=\":docid\"/>");
            dest.write("<input type=\"hidden\" name=\":base\"/>");
            dest.write("<input type=\"hidden\" name=\":baseindex\"/>");
            dest.write("<input type=\"hidden\" name=\":basestruct\"/>");
            dest.write("<input type=\"hidden\" name=\":elementaction\"/>");
            dest.write("<input type=\"hidden\" name=\":pos\"/>");
            dest.write("<input type=\"hidden\" name=\":usecursorname\"/>");
            dest.write("<input type=\"hidden\" name=\":usecursorindex\"/>");
            dest.write("<input type=\"hidden\" name=\":select\"/>");
            dest.write("<input type=\"hidden\" name=\":extselect\"/>");
            dest.write("<input type=\"hidden\" name=\":setchoice\"/>");
        }
    }
}

