/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.jsp.util;

import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletRequest;

public class Arguments {
    private Map map = new HashMap();

    public void add(ServletRequest request) {
        Enumeration pos = request.getParameterNames();
        while (pos.hasMoreElements()) {
            String name = (String)pos.nextElement();
            this.add(name, request.getParameterValues(name));
        }
    }

    public void add(Arguments arguments) {
        Iterator pos = arguments.getNames();
        while (pos.hasNext()) {
            String name = (String)pos.next();
            this.add(name, arguments.getValues(name));
        }
    }

    public void add(String name, String value) {
        if (name == null) {
            throw new PreconditionViolation();
        }
        if (value == null) {
            throw new PreconditionViolation();
        }
        if (this.map.get(name) != null) {
            throw new PreconditionViolation();
        }
        this.map.put(name, new String[]{value});
    }

    public void add(String name, String[] values) {
        if (name == null) {
            throw new PreconditionViolation();
        }
        if (values == null) {
            throw new PreconditionViolation();
        }
        if (this.map.get(name) != null) {
            throw new PreconditionViolation();
        }
        this.map.put(name, values);
    }

    public String[] getValues(String name) {
        return (String[])this.map.get(name);
    }

    public String getValue(String name) {
        String[] values = this.getValues(name);
        if (values == null) {
            return null;
        }
        if (values.length != 1) {
            throw new AssertionFailed("argument " + name + " is not unique, there are " + values.length + " values");
        }
        return values[0];
    }

    public String eatNoneEmptyValue(String name) {
        String value = this.getValue(name);
        if (value == null || value.length() == 0) {
            return null;
        }
        this.map.remove(name);
        return value;
    }

    public Iterator getNames() {
        return this.map.keySet().iterator();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator pos = this.getNames();
        while (pos.hasNext()) {
            String name = (String)pos.next();
            String[] values = this.getValues(name);
            buffer.append(name);
            buffer.append(": ");
            int i = 0;
            while (i < values.length) {
                buffer.append(values[i]);
                buffer.append(' ');
                ++i;
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public String toRequest() {
        StringBuffer buffer = new StringBuffer();
        Iterator pos = this.getNames();
        String name = null;
        while (pos.hasNext()) {
            if (name != null) {
                buffer.append('&');
            }
            name = (String)pos.next();
            String value = this.getValue(name);
            buffer.append(name);
            buffer.append('=');
            buffer.append(value);
        }
        return buffer.toString();
    }

    public String toJavaScript(String formName) {
        StringBuffer buffer = new StringBuffer();
        Iterator pos = this.getNames();
        while (pos.hasNext()) {
            String name = (String)pos.next();
            String value = this.getValue(name);
            buffer.append("document.forms['");
            buffer.append(formName);
            buffer.append("'].elements['");
            buffer.append(name);
            buffer.append("'].value='");
            buffer.append(Arguments.escape(value));
            buffer.append("';");
        }
        return buffer.toString();
    }

    private static String escape(String str) {
        StringBuffer buffer = new StringBuffer(str);
        int i = 0;
        while (i < buffer.length()) {
            if (buffer.charAt(i) == '\'') {
                buffer.insert(i, '\\');
                ++i;
            }
            ++i;
        }
        return buffer.toString();
    }
}

