/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.jsp.taglib;

import com.softwareag.xtools.xapplication.businessdocument.BusinessDocument;
import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentException;
import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentPage;
import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentStateException;
import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentWorkspace;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNode;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNodePage;
import com.softwareag.xtools.xapplication.businessdocument.InvalidXPathException;
import com.softwareag.xtools.xapplication.businessdocument.Page;
import com.softwareag.xtools.xapplication.businessdocument.QueryContainer;
import com.softwareag.xtools.xapplication.businessdocument.QueryElement;
import com.softwareag.xtools.xapplication.businessdocument.QuerySort;
import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.jsp.ExceptionContainer;
import com.softwareag.xtools.xapplication.jsp.InvalidActionException;
import com.softwareag.xtools.xapplication.jsp.JspTag;
import com.softwareag.xtools.xapplication.jsp.NavigationException;
import com.softwareag.xtools.xapplication.store.DeletedDocumentException;
import com.softwareag.xtools.xapplication.store.StoreException;
import com.softwareag.xtools.xapplication.store.UpdateConflictException;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.servlet.jsp.tagext.BodyContent;

public class ModuleTag
extends JspTag {
    private QueryContainer myContainer = null;
    private String myContainerDocument = null;
    private final int NO_CHOICE_NUM = -99;
    private long startMillis;

    public int doStartTagCore() throws ExceptionContainer, NavigationException {
        String document = this.requestContext.getDocument();
        if (!(document != null && document.length() != 0 || (document = this.requestContext.getDocument()) != null && document.length() != 0)) {
            document = "current";
        }
        boolean setFieldValues = true;
        String s = this.requestContext.getLinkaction();
        if (s == null || s.length() == 0) {
            s = this.requestContext.getLinkaction();
        }
        if (s != null && s.equalsIgnoreCase("Cancel")) {
            setFieldValues = false;
        }
        if ((s = this.requestContext.getAction()) == null || s.length() == 0) {
            s = this.requestContext.getAction();
        }
        if (s != null && s.equalsIgnoreCase("abandon")) {
            setFieldValues = false;
        }
        this.processRequestParameters(document, setFieldValues);
        try {
            String baseStruct = this.requestContext.getBasestruct();
            if (this.requestContext.getBasestruct() != null) {
                baseStruct = this.requestContext.getBasestruct();
            }
            if (baseStruct != null) {
                this.processBaseStruct(baseStruct);
            }
            this.processDocumentAction(document);
            this.processElementAction(document);
            this.processSetChoiceAction(document);
        }
        catch (BusinessDocumentStateException e) {
            e.printStackTrace();
            throw new ExceptionContainer("225", e);
        }
        this.processPositioning();
        if (this.myContainer != null) {
            if (this.myContainer.getDoctype() == null) {
                throw new ExceptionContainer("200");
            }
            if (this.myContainerDocument == null) {
                this.sessionContext.setQuery(this.requestContext, "current", this.myContainer);
            } else {
                this.sessionContext.setQuery(this.requestContext, this.myContainerDocument, this.myContainer);
            }
        }
        return 2;
    }

    public int doAfterBodyCore() throws ExceptionContainer, IOException {
        BodyContent bc = this.getBodyContent();
        bc.writeOut((Writer)bc.getEnclosingWriter());
        return 0;
    }

    public int doEndTagCore() {
        this.sessionContext.request = this.requestContext.getHeaderURI();
        this.sessionContext.servletPath = this.requestContext.getRequestURI();
        this.unlockSessionContext();
        return 6;
    }

    public void processRequestParameters(String document, boolean setFieldValues) throws ExceptionContainer {
        int i;
        String docId = this.requestContext.getDocid();
        String currentDocId = null;
        BusinessDocument temp = this.sessionContext.getDocument(document);
        if (temp != null) {
            currentDocId = temp.getDocumentId();
        }
        String action = this.getAction(docId, currentDocId);
        BusinessDocument currentBD = this.sessionContext.getDocument(document);
        QueryContainer container = null;
        String queryDocument = null;
        if (setFieldValues) {
            i = 0;
            while (i < this.requestContext.getFieldnames().length) {
                this.setFieldValues(this.requestContext.getFieldnames()[i], this.requestContext.getFields()[i], currentBD);
                ++i;
            }
        }
        if (this.requestContext.getQuerysortname() != null) {
            if (container == null) {
                container = new QueryContainer();
            }
            i = 0;
            while (i < this.requestContext.getQuerysort().length) {
                this.processSortField(container, this.requestContext.getQuerysortname(), this.requestContext.getQuerysort()[i]);
                ++i;
            }
        }
        if (this.requestContext.getQueryschema() != null) {
            if (container == null) {
                container = new QueryContainer();
            }
            container.setDoctype(this.requestContext.getQueryschema());
        }
        if (this.requestContext.getQuerydocument() != null) {
            queryDocument = this.requestContext.getQuerydocument();
        }
        int qi = 0;
        while (qi < this.requestContext.getQuerynames().length) {
            i = 0;
            while (i < this.requestContext.getQuery()[qi].length) {
                if (container == null) {
                    container = new QueryContainer();
                }
                if (this.requestContext.getQuery()[qi][i] != null && this.requestContext.getQuery()[qi][i].length() > 0 && !this.requestContext.getQuery()[qi][i].equals(" ")) {
                    this.processQueryField(container, this.requestContext.getQuerynames()[qi], this.requestContext.getQuery()[qi][i]);
                }
                ++i;
            }
            ++qi;
        }
        if (container != null) {
            this.myContainer = container;
            this.myContainerDocument = queryDocument;
        } else {
            this.myContainer = null;
        }
    }

    private void setFieldValues(String parmName, String[] parmValue, BusinessDocument currentBD) throws ExceptionContainer {
        int i;
        BusinessDocument useThisBD = currentBD;
        if (parmName.startsWith("#")) {
            i = parmName.substring(1).indexOf("#");
            String t1 = parmName.substring(1, i + 1);
            parmName = parmName.substring(i + 2);
            useThisBD = this.sessionContext.getDocument(t1);
            if (useThisBD == null) {
                throw new ExceptionContainer("201", t1);
            }
        } else if (currentBD == null) {
            throw new ExceptionContainer("202");
        }
        try {
            if (useThisBD.getState() == 1) {
                useThisBD.modify();
            }
            i = 0;
            while (i < parmValue.length) {
                Exception failure;
                try {
                    useThisBD.getDescendant(parmName).setValue(parmValue[i]);
                    failure = null;
                }
                catch (UnsupportedOperationException e) {
                    failure = e;
                }
                catch (InvalidXPathException e) {
                    failure = e;
                }
                catch (IllegalArgumentException e) {
                    failure = e;
                }
                if (failure != null) {
                    throw new ExceptionContainer("203", new Object[]{parmName, parmValue[i], failure.toString()}, (Throwable)new InvalidActionException());
                }
                ++i;
            }
        }
        catch (BusinessDocumentStateException e) {
            throw new ExceptionContainer("204", e);
        }
    }

    private String getAction(String docId, String currentDocId) throws ExceptionContainer {
        boolean hasFields = this.requestContext.hasFields();
        String action = this.requestContext.getAction();
        if (action == null || action.length() == 0) {
            action = this.requestContext.getAction();
        }
        if (action != null && hasFields) {
            if (docId != null && docId.length() != 0 && !docId.equals(currentDocId) && currentDocId != null) {
                throw new ExceptionContainer("205", new Object[]{docId, currentDocId}, (Throwable)new InvalidActionException());
            }
            if (docId == null && currentDocId != null) {
                throw new ExceptionContainer("206", currentDocId, (Throwable)new InvalidActionException());
            }
            if (docId != null && currentDocId == null) {
                throw new ExceptionContainer("207", docId, (Throwable)new InvalidActionException());
            }
        }
        return action;
    }

    private void processQueryField(QueryContainer container, String parmName, String parmValue) throws ExceptionContainer {
        StringTokenizer tok = new StringTokenizer(parmName, "(),", true);
        boolean open = false;
        String dataType = "string";
        int c = 0;
        String[] args = new String[10];
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken();
            if (str.equals("(")) {
                open = true;
                continue;
            }
            if (str.equals(")")) {
                open = false;
                continue;
            }
            if (str.equals(",")) {
                ++c;
                continue;
            }
            args[c] = str;
        }
        if (c > 2) {
            throw new ExceptionContainer("208", parmName);
        }
        String elemName = args[0];
        if (c == 2) {
            dataType = args[2].toLowerCase();
        }
        if (c == 0) {
            container.add(new QueryElement(elemName, parmValue));
        } else {
            container.add(new QueryElement(elemName, parmValue, args[1], dataType));
        }
    }

    private void processSortField(QueryContainer container, String parmName, String parmValue) throws ExceptionContainer {
        if (parmValue == null || parmValue.length() == 0) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(parmValue, "(),", true);
        boolean open = false;
        int c = 0;
        String[] args = new String[10];
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken();
            if (str.equals("(")) {
                open = true;
                continue;
            }
            if (str.equals(")")) {
                open = false;
                continue;
            }
            if (str.equals(",")) {
                ++c;
                continue;
            }
            args[c] = str;
        }
        if (args[0].length() == 0) {
            throw new ExceptionContainer("209", parmName);
        }
        if (c > 1) {
            throw new ExceptionContainer("210", parmName);
        }
        String elemName = args[0];
        if (c == 0) {
            container.add(new QuerySort(elemName));
        } else if (args[1].toLowerCase().startsWith("a")) {
            container.add(new QuerySort(elemName, 1));
        } else if (args[1].toLowerCase().startsWith("d")) {
            container.add(new QuerySort(elemName, 2));
        } else {
            throw new ExceptionContainer("211", parmName);
        }
    }

    private void processDocumentAction(String document) throws ExceptionContainer, BusinessDocumentStateException {
        block34: {
            String action = this.requestContext.getAction();
            if (action != null) {
                action = action.toLowerCase();
            }
            int useCursorIndex = 0;
            String t1 = this.requestContext.getUsecursorindex();
            if (t1 != null) {
                try {
                    useCursorIndex = Integer.parseInt(t1);
                }
                catch (NumberFormatException e) {
                    System.err.println("invalid parameter :usecursorindex '" + t1 + "'");
                }
            }
            String useCursorName = this.requestContext.getUsecursorname();
            if (action != null && action.length() > 0) {
                action = action.toLowerCase();
                try {
                    String docId = this.requestContext.getDocid();
                    String currentDocId = null;
                    BusinessDocument temp = this.sessionContext.getDocument(document);
                    if (temp != null) {
                        currentDocId = temp.getDocumentId();
                    }
                    if (action.equals("read")) {
                        if (useCursorIndex != 0) {
                            this.locateDocument(useCursorName, useCursorIndex, docId, document);
                        } else {
                            this.sessionContext.read(document, docId);
                        }
                        break block34;
                    }
                    if (action.equals("create")) {
                        String schema = this.requestContext.getSchema();
                        this.sessionContext.create(document, schema);
                        break block34;
                    }
                    if (action.equals("delete")) {
                        if (docId != null && docId.length() != 0 && !docId.equals(currentDocId)) {
                            if (useCursorIndex != 0) {
                                this.locateDocument(useCursorName, useCursorIndex, docId, document);
                            } else {
                                this.sessionContext.read(document, docId);
                            }
                        }
                        String[] docList = ModuleTag.splitStringList(document);
                        int i = 0;
                        while (i < docList.length) {
                            this.sessionContext.delete(docList[i]);
                            ++i;
                        }
                        break block34;
                    }
                    if (action.equals("modify")) {
                        if (docId != null && docId.length() != 0 && !docId.equals(currentDocId)) {
                            if (useCursorIndex != 0) {
                                this.locateDocument(useCursorName, useCursorIndex, docId, document);
                            } else {
                                this.sessionContext.read(document, docId);
                            }
                        }
                        String[] docList = ModuleTag.splitStringList(document);
                        int i = 0;
                        while (i < docList.length) {
                            this.sessionContext.modify(docList[i]);
                            ++i;
                        }
                        break block34;
                    }
                    if (action.equals("commit")) {
                        if (docId != null && docId.length() != 0 && !docId.equals(currentDocId) && currentDocId != null) {
                            throw new ExceptionContainer("212", new Object[]{docId, currentDocId}, (Throwable)new InvalidActionException());
                        }
                        if (docId == null && currentDocId != null) {
                            throw new ExceptionContainer("213", currentDocId, (Throwable)new InvalidActionException());
                        }
                        if (docId != null && currentDocId == null) {
                            throw new ExceptionContainer("214", docId, (Throwable)new InvalidActionException());
                        }
                        String[] docList = ModuleTag.splitStringList(document);
                        this.sessionContext.commitAll(docList);
                        break block34;
                    }
                    if (action.equals("abandon")) {
                        if (docId != null && docId.length() != 0 && !docId.equals(currentDocId) && currentDocId != null) {
                            throw new ExceptionContainer("215", new Object[]{docId, currentDocId}, (Throwable)new InvalidActionException());
                        }
                        String[] docList = ModuleTag.splitStringList(document);
                        int i = 0;
                        while (i < docList.length) {
                            this.sessionContext.abandon(docList[i]);
                            ++i;
                        }
                        break block34;
                    }
                    if (action.equals("commitall")) {
                        this.sessionContext.commitAll();
                        break block34;
                    }
                    if (action.equals("abandonall")) {
                        this.sessionContext.abandonAll();
                        break block34;
                    }
                    if (action.equals("closeusersession")) {
                        this.closeSession();
                        break block34;
                    }
                    throw new ExceptionContainer("216", action);
                }
                catch (UpdateConflictException e) {
                    e.printStackTrace();
                    throw new ExceptionContainer("224", e);
                }
                catch (DeletedDocumentException e) {
                    throw new ExceptionContainer("226", e);
                }
                catch (StoreException e) {
                    e.printStackTrace();
                    throw new ExceptionContainer("217", action, (Throwable)e);
                }
            }
        }
    }

    private void processElementAction(String document) throws ExceptionContainer, BusinessDocumentStateException {
        String action = this.requestContext.getElementaction();
        if (action == null || action.length() <= 0) {
            return;
        }
        int start = action.indexOf(40);
        int separator = action.lastIndexOf(59);
        int end = action.lastIndexOf(41);
        String posExpr = action.substring(start + 1, separator);
        int idx = Integer.parseInt(action.substring(separator + 1, end));
        if ((action = action.toLowerCase()).startsWith("select")) {
            this.processSelectAction(document, posExpr, idx);
        } else if (action.startsWith("insert")) {
            this.processInsertAction(document, posExpr, idx);
        } else if (action.startsWith("remove")) {
            this.processRemoveAction(document, posExpr, idx);
        } else {
            throw new ExceptionContainer("218", action);
        }
    }

    private BusinessNode processSelectAction(String document) throws ExceptionContainer {
        BusinessNodePage np = this.getNodePage();
        int baseIndex = this.getBaseIndex();
        np.gotoPageWithIndex(baseIndex);
        int relIndex = baseIndex - (np.getPageStartElementNo() + 1);
        this.getDocument(document, false).map(np.getPageName(), np.get(relIndex));
        return np.get(relIndex);
    }

    private BusinessNode processSelectAction(String document, String posExpr, int idx) throws ExceptionContainer {
        BusinessNodePage np = (BusinessNodePage)this.processPositionExpression(posExpr);
        this.sessionContext.setPage(np.getPageName(), np);
        this.getDocument(document, false).map(np.getPageName(), np.get(idx));
        return np.get(idx);
    }

    private void processInsertAction(String document, String posExpr, int idx) throws ExceptionContainer {
        BusinessDocument doc = this.getDocument(document, true);
        BusinessNodePage np = (BusinessNodePage)this.processPositionExpression(posExpr);
        np.insert(idx);
        doc.map(np.getPageName(), np.get(idx));
    }

    private void processRemoveAction(String document, String posExpr, int idx) throws ExceptionContainer {
        try {
            this.getDocument(document, true);
            BusinessNodePage np = (BusinessNodePage)this.processPositionExpression(posExpr);
            np.remove(idx);
        }
        catch (BusinessDocumentException e) {
            throw new ExceptionContainer("009", e);
        }
    }

    private void processSetChoiceAction(String document) throws ExceptionContainer, BusinessDocumentStateException {
        String action = this.requestContext.getSetchoice();
        if (action == null || action.length() <= 0) {
            return;
        }
        BusinessDocument doc = this.getDocument(document, true);
        BusinessNode baseNode = doc.getRoot();
        if (this.hasBase()) {
            if (this.hasBaseIndex()) {
                baseNode = this.processSelectAction(document);
            } else {
                BusinessNode lookUp = doc.lookup(this.requestContext.getBase());
                if (lookUp != null) {
                    baseNode = lookUp;
                }
            }
        }
        int choiceInt = this.getChoiceIndex(action);
        String select = this.requestContext.getSelect();
        String extSelect = this.requestContext.getExtselect();
        try {
            if (select != null) {
                baseNode = baseNode.getDescendant(select);
            }
            if (choiceInt != -99) {
                baseNode.setChoice(choiceInt);
            } else if (extSelect != null) {
                baseNode.setChoice(extSelect, action);
            } else {
                baseNode.setChoice(action);
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println("path error with setting choice " + action + " for xpath=" + select);
        }
        catch (InvalidXPathException e) {
            throw new ExceptionContainer("219", new Object[]{select, extSelect, baseNode.getPath()}, (Throwable)e);
        }
    }

    private void processBaseStruct(String baseStruct) throws ExceptionContainer {
        String[] baseList = ModuleTag.splitStringList(baseStruct);
        int i = 0;
        while (i < baseList.length) {
            int cursorIndex = 0;
            String cursorName = null;
            int baseIndex = 0;
            try {
                cursorIndex = Integer.parseInt(baseList[i]);
                cursorName = baseList[i + 1];
                baseIndex = Integer.parseInt(baseList[i + 2]);
            }
            catch (NumberFormatException e) {
                System.err.println("internal parameter error, baseStruct=" + baseStruct);
            }
            if (baseIndex >= 0) {
                if (this.sessionContext.activatePageFromCache(cursorIndex, cursorName)) {
                    if (cursorName != null) {
                        Page mc = this.sessionContext.getPage(cursorName);
                        if (mc instanceof BusinessNodePage) {
                            this.activateNodePage((BusinessNodePage)mc, baseIndex, cursorName);
                        } else {
                            try {
                                this.activateDocumentPage((BusinessDocumentPage)mc, baseIndex, cursorName);
                            }
                            catch (StoreException e) {
                                System.err.println("" + e);
                            }
                            catch (NoSuchElementException e) {
                                throw new ExceptionContainer("222", e);
                            }
                        }
                    }
                } else {
                    System.err.println("warning cursorIndex=" + cursorIndex + " with name=" + cursorName + " could not be reactivated.");
                }
            }
            i += 3;
        }
    }

    private void processPositioning() throws ExceptionContainer {
        if (this.requestContext.getPos() != null && this.requestContext.getPos().length() > 0) {
            this.processPositionExpression(this.requestContext.getPos());
        }
        if (this.requestContext.getGoto() != null && this.requestContext.getGoto().length() > 0) {
            this.processGotoExpression(this.requestContext.getGoto());
        }
    }

    private void processGotoExpression(String expr) throws ExceptionContainer {
        if (expr.startsWith(",")) {
            expr = "current" + expr;
        }
        String[] list = ModuleTag.splitStringList(expr);
        int val = 1;
        try {
            val = list.length > 1 ? Integer.parseInt(list[1]) : 1;
        }
        catch (NumberFormatException e) {
            System.err.println("invalid goto value " + list[1] + ", using " + val);
        }
        expr = list[0] + "," + (val - 1);
        this.processPositionExpression(expr);
    }

    private Page processPositionExpression(String expr) throws ExceptionContainer {
        Page mc;
        block16: {
            int idx;
            String[] list = ModuleTag.splitStringList(expr);
            if (list.length > 0 && list.length % 2 != 0) {
                throw new PreconditionViolation("expected a list defining a cursor position with the format 'cursor1,index1,cursor2,index2,...', but got '" + expr + "'");
            }
            mc = this.sessionContext.getPage(list[0]);
            int i = 0;
            while (i < list.length - 2) {
                try {
                    if (mc == null) {
                        throw new ExceptionContainer("227", new String[]{list[i], expr});
                    }
                    idx = Integer.parseInt(list[i + 1]);
                    if (mc.getSubPages(idx) == null) {
                        throw new AssertionFailed("no registered page for cursor with name '" + list[i + 2] + "' within expression '" + expr + "'");
                    }
                    mc = (Page)mc.getSubPages(idx).get(list[i + 2]);
                }
                catch (NumberFormatException e) {
                    throw new AssertionFailed("invalid number '" + list[i + 1] + "' within the parameter position expression '" + expr + "'", e);
                }
                i += 2;
            }
            try {
                if (mc == null) {
                    throw new ExceptionContainer("227", new String[]{list[list.length - 2], expr});
                }
                idx = Integer.parseInt(list[list.length - 1]);
                if (mc instanceof BusinessDocumentPage) {
                    BusinessDocumentPage dp = (BusinessDocumentPage)mc;
                    if (dp.getPageStartElementNo() + 1 != idx || dp.containsDeadDocuments()) {
                        dp.gotoPageStartingAt(idx);
                        if (dp.containsDeadDocuments()) {
                            throw new AssertionFailed("document page must not contain dead documents after repositioning at " + idx);
                        }
                    }
                    break block16;
                }
                if (mc instanceof BusinessNodePage) {
                    BusinessNodePage np = (BusinessNodePage)mc;
                    if (np.getPageStartElementNo() + 1 != idx) {
                        np.gotoPageStartingAt(idx);
                    }
                    break block16;
                }
                throw new AssertionFailed("unexpected sub-class '" + mc.getClass().getName() + "' for module cursor '" + list[list.length - 2] + "'");
            }
            catch (NumberFormatException e) {
                throw new AssertionFailed("invalid number '" + list[list.length - 1] + "' within the position expr '" + expr + "'", e);
            }
            catch (StoreException e) {
                throw new ExceptionContainer("220", new Object[]{expr, list[list.length - 1], list[list.length - 2]}, (Throwable)e);
            }
            catch (NoSuchElementException e) {
                throw new ExceptionContainer("228", new Object[]{expr, list[list.length - 1], list[list.length - 2]}, (Throwable)e);
            }
        }
        return mc;
    }

    private void locateDocument(String useCursorName, int useCursorIndex, String docId, String document) throws StoreException, ExceptionContainer, NavigationException {
        try {
            BusinessDocumentPage dp;
            if (useCursorName == null) {
                useCursorName = "current";
            }
            if ((dp = (BusinessDocumentPage)this.sessionContext.getPage(useCursorName)) == null) {
                throw new ExceptionContainer("221", new Object[]{useCursorName, this.sessionContext.servletPath}, (Throwable)new NavigationException());
            }
            int pageIndex = dp.findDocument(useCursorIndex - 1, docId);
            BusinessDocument bd = dp.get(pageIndex);
            this.sessionContext.map(document, bd);
        }
        catch (NoSuchElementException e) {
            throw new ExceptionContainer("222", e);
        }
    }

    private static String[] splitStringList(String stringList) {
        StringTokenizer tok = new StringTokenizer(stringList, ", ");
        String[] retStr = new String[tok.countTokens()];
        int i = 0;
        while (i < retStr.length) {
            retStr[i] = tok.nextToken();
            ++i;
        }
        return retStr;
    }

    protected void startDumpDiagnosis() throws ExceptionContainer {
        this.startMillis = System.currentTimeMillis();
        Date accessTime = new Date(this.startMillis / 1000L * 1000L);
        DateFormat dateFormat = DateFormat.getTimeInstance();
        this.traceInfo.startElement("Page");
        this.traceInfo.addAttribute("titel", this.requestContext.getHeaderURI().substring(this.requestContext.getHeaderURI().lastIndexOf("/") + 1));
        this.traceInfo.addAttribute("accesstime", dateFormat.format(accessTime));
        this.dumpServletContext();
        super.startDumpDiagnosis();
        this.traceInfo.startElement("WorkspaceContent");
        this.traceInfo.startElement("Before");
        this.dumpWorkspaceContent();
        this.traceInfo.endElement();
        this.traceInfo.endElement();
    }

    protected void endDumpDiagnosis() throws ExceptionContainer {
        this.traceInfo.moveToChildElement("WorkspaceContent");
        this.traceInfo.startElement("After");
        this.dumpWorkspaceContent();
        this.traceInfo.endElement();
        this.traceInfo.endElement();
        long ms = System.currentTimeMillis() - this.startMillis;
        this.traceInfo.addElementWithInfo("processing_time", ms + " ms", 0);
        System.err.println("page processing time " + ms);
        super.endDumpDiagnosis();
        this.traceInfo.endElement();
    }

    private void dumpWorkspaceContent() throws ExceptionContainer {
        BusinessDocumentWorkspace bdw = this.sessionContext.getWorkspace();
        Iterator iterator = bdw.iterateNames();
        String state = null;
        this.traceInfo.startElement("DocumentsInWorkspace");
        while (iterator.hasNext()) {
            this.traceInfo.startElement("Document");
            String buffer = iterator.next().toString();
            if (buffer != null) {
                this.traceInfo.addAttribute("Name", buffer);
                if (this.sessionContext.getDocument(buffer) != null) {
                    this.traceInfo.addAttribute("DocID", this.sessionContext.getDocument(buffer).getDocumentId());
                    if (0 == this.sessionContext.getDocument(buffer).getState()) {
                        state = "Created";
                    }
                    if (4 == this.sessionContext.getDocument(buffer).getState()) {
                        state = "Dead";
                    }
                    if (3 == this.sessionContext.getDocument(buffer).getState()) {
                        state = "Deleted";
                    }
                    if (2 == this.sessionContext.getDocument(buffer).getState()) {
                        state = "Modifiable";
                    }
                    if (5 == this.sessionContext.getDocument(buffer).getState()) {
                        state = "Quasi Commited";
                    }
                    if (1 == this.sessionContext.getDocument(buffer).getState()) {
                        state = "Read";
                    }
                    this.traceInfo.addAttribute("State", state);
                } else {
                    this.traceInfo.addAttribute("DocID", "");
                    this.traceInfo.addAttribute("State", "");
                }
            }
            this.traceInfo.endElement();
        }
        this.traceInfo.endElement();
    }

    private boolean hasBase() {
        String base = this.requestContext.getBase();
        return base != null && base.length() >= 0;
    }

    BusinessNodePage getNodePage() throws ExceptionContainer {
        String base = this.requestContext.getBase();
        BusinessNodePage result = (BusinessNodePage)this.sessionContext.getPage(base);
        if (result == null) {
            throw new ExceptionContainer("223", base);
        }
        return result;
    }

    BusinessDocument getDocument(String document, boolean modifiable) {
        BusinessDocument doc = this.sessionContext.getDocument(document);
        if (doc != null && modifiable && doc.getState() == 1) {
            doc.modify();
        }
        return doc;
    }

    boolean hasBaseIndex() {
        String bi = this.requestContext.getBaseindex();
        return bi != null && bi.length() > 0;
    }

    int getBaseIndex() {
        if (!this.hasBaseIndex()) {
            throw new PreconditionViolation(":baseindex is not defined within the environment");
        }
        try {
            int result = Integer.parseInt(this.requestContext.getBaseindex());
            return result;
        }
        catch (NumberFormatException e) {
            throw new AssertionFailed("received an invalid number '" + this.requestContext.getBaseindex() + "' for the parameter ':baseindex'", e);
        }
    }

    int getChoiceIndex(String choiceIdx) {
        if (choiceIdx == null || choiceIdx.length() <= 0) {
            throw new PreconditionViolation("choice value '" + choiceIdx + "' must not be null or empty");
        }
        try {
            return Integer.parseInt(choiceIdx);
        }
        catch (NumberFormatException e) {
            return -99;
        }
    }

    void activateNodePage(BusinessNodePage np, int idx, String cursorName) throws ExceptionContainer {
        np.gotoPageWithIndex(idx);
        np.getDocument().map(cursorName, np.get(idx - np.getPageStartElementNo() - 1));
    }

    void activateDocumentPage(BusinessDocumentPage dp, int idx, String cursorName) throws StoreException {
        dp.gotoPageWithIndex(idx);
        this.sessionContext.getWorkspace().map(cursorName, dp.get(idx - dp.getPageStartElementNo() - 1));
    }
}

