/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.jsp.taglib;

import com.softwareag.xtools.xapplication.businessdocument.BusinessDocument;
import com.softwareag.xtools.xapplication.businessdocument.BusinessDocumentPage;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNode;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNodeCursor;
import com.softwareag.xtools.xapplication.businessdocument.BusinessNodePage;
import com.softwareag.xtools.xapplication.businessdocument.InvalidXPathException;
import com.softwareag.xtools.xapplication.businessdocument.Page;
import com.softwareag.xtools.xapplication.common.AssertionFailed;
import com.softwareag.xtools.xapplication.common.PreconditionViolation;
import com.softwareag.xtools.xapplication.jsp.ExceptionContainer;
import com.softwareag.xtools.xapplication.jsp.taglib.IteratingContextTag;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.tagext.BodyContent;

public class LoopTag
extends IteratingContextTag {
    private String targetBase = null;
    private String select = null;
    private String iterate = null;
    private String extSelect = null;
    private int initialSize = -1;
    private int nodeIndex;
    private BusinessNodePage currentPage;

    public void setTargetbase(String targetBase) {
        this.targetBase = targetBase;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public void setIterate(String iterate) {
        this.iterate = iterate;
    }

    public void setExtSelect(String extSelect) {
        this.extSelect = extSelect;
    }

    public String getPageName() {
        return this.targetBase;
    }

    public void setPagesize(String size) {
        try {
            this.initialSize = Integer.parseInt(size);
        }
        catch (NumberFormatException e) {
            this.unlockSessionContext();
            throw e;
        }
    }

    protected String getThisBaseStruct() {
        if (this.targetBase != null) {
            BusinessNodePage np = (BusinessNodePage)this.getActivePage();
            int i = this.sessionContext.registerPageInCache(np);
            return i + "," + np.getPageName() + "," + this.getCurrentNodeIndex();
        }
        return null;
    }

    public String getElementValueBaseName() {
        return this.targetBase;
    }

    public int doStartTagCore() throws ExceptionContainer {
        BusinessDocument currentDoc;
        if (this.iterate == null && this.extSelect != null) {
            throw new ExceptionContainer("138");
        }
        int result = super.doStartTagCore();
        this.nodeIndex = 0;
        Page page = this.getActivePage();
        if (!this.checkPage(page, currentDoc = this.sessionContext.getDocument(this.getDocument()))) {
            page = this.createNewPage(currentDoc);
        }
        if (page == null) {
            return 0;
        }
        if (!(page instanceof BusinessNodePage)) {
            throw new AssertionFailed("current must exist and it must be a node page, but was " + (page == null ? "null" : page.getClass().getName()));
        }
        this.currentPage = (BusinessNodePage)page;
        this.registerNodePage(this.getBase(), this.targetBase, this.currentPage);
        if (result == 0 || this.currentPage.size() == this.currentPage.getPageStartElementNo() + 1) {
            this.setEmpty(true);
            return 0;
        }
        if (this.initialSize >= 0 && this.currentPage.getPageCapacity() != this.initialSize) {
            this.currentPage.setPageCapacity(this.initialSize);
        }
        this.sessionContext.setPage(this.currentPage.getPageName(), this.currentPage);
        currentDoc.map(this.currentPage.getPageName(), this.currentPage.get(this.nodeIndex));
        this.activateSubPages(this.nodeIndex, this.currentPage);
        return result;
    }

    public void doInitBodyCore() throws ExceptionContainer {
    }

    public int doAfterBodyCore() throws ExceptionContainer, IOException {
        BodyContent bc = this.getBodyContent();
        bc.writeOut((Writer)bc.getEnclosingWriter());
        bc.clearBody();
        ++this.nodeIndex;
        if (this.nodeIndex < this.currentPage.getPageCapacity() && this.currentPage.get(this.nodeIndex) != null) {
            this.sessionContext.setPage(this.currentPage.getPageName(), this.currentPage);
            BusinessDocument currentDoc = this.sessionContext.getDocument(this.getDocument());
            currentDoc.map(this.currentPage.getPageName(), this.currentPage.get(this.nodeIndex));
            this.activateSubPages(this.nodeIndex, this.currentPage);
            return 2;
        }
        return 0;
    }

    public boolean checkPage(Page mc, BusinessDocument currentDoc) throws ExceptionContainer {
        if (currentDoc == null) {
            throw new ExceptionContainer("139");
        }
        if (!(mc instanceof BusinessNodePage) || !((BusinessNodePage)mc).isActive() || ((BusinessNodePage)mc).getDocument() != currentDoc) {
            return false;
        }
        BusinessNodePage np = (BusinessNodePage)mc;
        IteratingContextTag ict = this.getEnclosingContext();
        Page basePage = np.getBasePage();
        String baseName = this.getBase();
        if (ict != null) {
            if (basePage != null != (baseName != null)) {
                return false;
            }
            if (basePage == null) {
                return true;
            }
            if (np != basePage.getSubPage(ict.getCurrentIndex(), this.getPageName())) {
                return false;
            }
            try {
                BusinessNode occNode = this.getIterationNode(currentDoc.lookup(baseName), this.select, this.extSelect, this.iterate, this.getPageName());
                return occNode == np.getOccurrenceNode();
            }
            catch (InvalidXPathException e) {
                return false;
            }
        }
        if (basePage instanceof BusinessDocumentPage) {
            return true;
        }
        if (basePage != null) {
            return false;
        }
        if (baseName != null) {
            try {
                BusinessNode occNode = this.getIterationNode(currentDoc.lookup(baseName), this.select, this.extSelect, this.iterate, this.getPageName());
                return occNode == np.getOccurrenceNode();
            }
            catch (InvalidXPathException e) {
                return false;
            }
        }
        return true;
    }

    public boolean isFirst() {
        return this.firstOnPage() && ((BusinessNodePage)this.getActivePage()).getPageStartElementNo() == -1;
    }

    public boolean isLast() {
        return this.nodeIndex == this.currentPage.getLastNodeIndex() && !this.currentPage.hasNextPage();
    }

    public boolean firstOnPage() {
        return this.nodeIndex == 0;
    }

    public boolean lastOnPage() {
        return this.nodeIndex == this.currentPage.getLastNodeIndex();
    }

    public boolean atEvenPos() {
        return (this.nodeIndex + ((BusinessNodePage)this.getActivePage()).getLastNodeIndex() + 2) % 2 == 0;
    }

    public boolean atOddPos() {
        return !this.atEvenPos();
    }

    public boolean atEvenPosOnPage() {
        return (this.nodeIndex + 1) % 2 == 0;
    }

    public boolean atOddPosOnPage() {
        return !this.atEvenPosOnPage();
    }

    public BusinessNodePage createNewPage(BusinessDocument currentDoc) throws ExceptionContainer {
        if (currentDoc == null) {
            throw new PreconditionViolation("parameter 'currentDoc' must not be null");
        }
        BusinessNode baseNode = null;
        if (this.getBase() != null) {
            baseNode = currentDoc.lookup(this.getBase());
            if (baseNode == null) {
                Page basePage = this.sessionContext.getPage(this.getBase());
                if (basePage == null) {
                    throw new ExceptionContainer("140", this.getBase());
                }
                if (basePage.size() == 0) {
                    throw new AssertionFailed("loop tag was evaluated although its underlaying base page '" + basePage.getPageName() + "' was empty");
                }
                throw new ExceptionContainer("156", this.getBase());
            }
        } else {
            baseNode = currentDoc.getRoot();
        }
        try {
            BusinessNode occ = this.getIterationNode(baseNode, this.select, this.extSelect, this.iterate, this.getPageName());
            BusinessNodePage result = new BusinessNodePage(occ, this.getPageName(), this.initialSize);
            this.sessionContext.setPage(this.getPageName(), result);
            return result;
        }
        catch (InvalidXPathException e) {
            System.err.println("Warning (LoopTag): A loop for sub-nodes of a non-existing field which might be optional in readonly state has to be created.");
            System.err.println("\tIf the path '" + this.select + (this.extSelect != null ? "/" + this.extSelect : "") + "'" + (this.iterate != null ? " to iterate the content '" + this.iterate + "'" : "") + " is correct and contains an optional field, you can ignore this warning.");
            return null;
        }
    }

    public int getCurrentNodeIndex() {
        if (0 > this.nodeIndex || this.nodeIndex > this.currentPage.getPageCapacity() - 1) {
            throw new AssertionFailed("relative document index " + this.nodeIndex + " must be in range [0.." + (this.currentPage.getPageCapacity() - 1) + "]");
        }
        int result = this.currentPage.getPageStartElementNo() + 1 + this.nodeIndex;
        if (result < 0) {
            throw new AssertionFailed("absolute document index " + result + " must be greater than Zero");
        }
        return result;
    }

    public int getCurrentIndex() {
        return this.nodeIndex;
    }

    private BusinessNode getIterationNode(BusinessNode baseNode, String path, String sPath, String content, String pageName) throws InvalidXPathException {
        BusinessNode node = this.getSubNode(baseNode, path);
        BusinessNodeCursor help = sPath != null ? (BusinessNodeCursor)node.iterate(sPath, content, pageName) : (content != null ? (BusinessNodeCursor)node.iterate(content, pageName) : (BusinessNodeCursor)node.iterate(pageName));
        node = help.getIterationNode();
        help.close();
        return node;
    }

    private BusinessNode getSubNode(BusinessNode n, String path) throws InvalidXPathException {
        BusinessNode result;
        try {
            result = n.getDescendant(path);
        }
        catch (InvalidXPathException e) {
            if (n.getDocument().isWriteAble()) {
                n.touchDescendants(path);
                result = n.getDescendant(path);
            }
            throw e;
        }
        return result;
    }

    protected void registerNodePage(String baseId, String targetName, BusinessNodePage np) {
        if (baseId == null || !baseId.equals(this.targetBase)) {
            super.registerNodePage(baseId, targetName, np);
        } else {
            this.currentPage.addSubPage(this.nodeIndex, targetName, np);
        }
    }

    protected boolean appendPosition(StringBuffer sb) {
        boolean result = super.appendPosition(sb);
        if (result) {
            sb.append(',');
        }
        sb.append(this.targetBase);
        sb.append(',');
        sb.append(this.nodeIndex);
        return true;
    }
}

