/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.xtools.xapplication.jsp.taglib;

import com.softwareag.xtools.xapplication.businessdocument.BusinessNodePage;
import com.softwareag.xtools.xapplication.businessdocument.Page;
import com.softwareag.xtools.xapplication.jsp.ExceptionContainer;
import com.softwareag.xtools.xapplication.jsp.taglib.NavigationTag;
import com.softwareag.xtools.xapplication.jsp.util.Arguments;
import java.io.IOException;

public class LoopNavigationTag
extends NavigationTag {
    private String loopTargetName;
    private String form;

    public void setTargetbase(String name) {
        this.loopTargetName = name;
    }

    public void setForm(String value) {
        this.form = value;
    }

    public Page getActivePage() {
        return this.sessionContext.getPage(this.loopTargetName);
    }

    public void processNavigation() throws ExceptionContainer, IOException {
        if (this.direction == null || !this.direction.equals("next") && !this.direction.equals("previous")) {
            throw new ExceptionContainer("136", new String[]{this.loopTargetName, this.direction});
        }
        BusinessNodePage np = this.checkCursor(this.getActivePage());
        if (np != null) {
            int pos;
            if (this.direction.equals("next") && np.hasNextPage()) {
                pos = np.getPageCapacity();
            } else if (this.direction.equals("previous") && np.hasPreviousPage()) {
                pos = -np.getPageCapacity();
            } else {
                return;
            }
            Arguments args = this.createArguments(pos, np);
            this.createBodyContent(this.form, "loopnavigation", this.direction, args);
            this.getBodyContent().clearBody();
        }
    }

    private BusinessNodePage checkCursor(Page mc) throws ExceptionContainer {
        if (mc == null || mc instanceof BusinessNodePage) {
            return (BusinessNodePage)mc;
        }
        throw new ExceptionContainer("137", this.loopTargetName);
    }

    private Arguments createArguments(int pos, BusinessNodePage np) {
        Arguments result = new Arguments();
        result.add(":pos", np.getPositionVector(pos));
        return result;
    }

    protected void endDumpDiagnosis() throws ExceptionContainer {
        this.traceInfo.addAttribute("form", this.form);
        this.traceInfo.addAttribute("targetbase", this.loopTargetName);
        super.endDumpDiagnosis();
    }
}

